"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPL_TOKEN_SETS = exports.ID = void 0;
exports.ID = 'PPL';
/**
 * PPL token type lookup table organized by Monaco editor token class
 * Maps Monaco token types to Sets of ANTLR token types for O(1) lookup performance
 */
exports.PPL_TOKEN_SETS = {
    keyword: new Set([
        'SEARCH',
        'DESCRIBE',
        'SHOW',
        'FROM',
        'WHERE',
        'FIELDS',
        'RENAME',
        'STATS',
        'DEDUP',
        'SORT',
        'EVAL',
        'HEAD',
        'TOP',
        'RARE',
        'PARSE',
        'METHOD',
        'REGEX',
        'PUNCT',
        'GROK',
        'PATTERN',
        'PATTERNS',
        'NEW_FIELD',
        'KMEANS',
        'AD',
        'ML',
        'SOURCE',
        'NOT',
        'OR',
        'AND',
        'XOR',
        'TRUE',
        'FALSE',
        'REGEXP',
        'CASE',
        'IN',
    ]),
    attribute: new Set([
        'AS',
        'BY',
        'INDEX',
        'D',
        'DESC',
        'DATASOURCES',
        'SORTBY',
        'KEEPEMPTY',
        'CONSECUTIVE',
        'DEDUP_SPLITVALUES',
        'PARTITIONS',
        'ALLNUM',
        'DELIM',
        'CENTROIDS',
        'ITERATIONS',
        'DISTANCE_TYPE',
        'NUMBER_OF_TREES',
        'SHINGLE_SIZE',
        'SAMPLE_SIZE',
        'OUTPUT_AFTER',
        'TIME_DECAY',
        'ANOMALY_RATE',
        'CATEGORY_FIELD',
        'TIME_FIELD',
        'TIME_ZONE',
        'TRAINING_DATA_SIZE',
        'ANOMALY_SCORE_THRESHOLD',
        'ALLOW_LEADING_WILDCARD',
        'ANALYZE_WILDCARD',
        'ANALYZER',
        'AUTO_GENERATE_SYNONYMS_PHRASE_QUERY',
        'BOOST',
        'CUTOFF_FREQUENCY',
        'DEFAULT_FIELD',
        'DEFAULT_OPERATOR',
        'ENABLE_POSITION_INCREMENTS',
        'ESCAPE',
        'FLAGS',
        'FUZZY_MAX_EXPANSIONS',
        'FUZZY_PREFIX_LENGTH',
        'FUZZY_TRANSPOSITIONS',
        'FUZZY_REWRITE',
        'FUZZINESS',
        'LENIENT',
        'LOW_FREQ_OPERATOR',
        'MAX_DETERMINIZED_STATES',
        'MAX_EXPANSIONS',
        'MINIMUM_SHOULD_MATCH',
        'OPERATOR',
        'PHRASE_SLOP',
        'PREFIX_LENGTH',
        'QUOTE_ANALYZER',
        'QUOTE_FIELD_SUFFIX',
        'REWRITE',
        'SLOP',
        'TIE_BREAKER',
        'TYPE',
        'ZERO_TERMS_QUERY',
    ]),
    type: new Set([
        'AUTO',
        'STR',
        'IP',
        'NUM',
        'INT',
        'INTEGER',
        'DOUBLE',
        'LONG',
        'FLOAT',
        'STRING',
        'BOOLEAN',
        'MS',
        'S',
        'M',
        'H',
        'W',
        'Q',
        'Y',
        'CONVERT_TZ',
        'DATETIME',
        'DAY',
        'DAY_HOUR',
        'DAY_MICROSECOND',
        'DAY_MINUTE',
        'DAY_OF_YEAR',
        'DAY_SECOND',
        'HOUR',
        'HOUR_MICROSECOND',
        'HOUR_MINUTE',
        'HOUR_OF_DAY',
        'HOUR_SECOND',
        'INTERVAL',
        'MICROSECOND',
        'MILLISECOND',
        'MINUTE',
        'MINUTE_MICROSECOND',
        'MINUTE_OF_DAY',
        'MINUTE_OF_HOUR',
        'MINUTE_SECOND',
        'MONTH',
        'MONTH_OF_YEAR',
        'QUARTER',
        'SECOND',
        'SECOND_MICROSECOND',
        'SECOND_OF_MINUTE',
        'WEEK',
        'WEEK_OF_YEAR',
        'YEAR',
        'YEAR_MONTH',
    ]),
    tag: new Set(['DATAMODEL', 'LOOKUP', 'SAVEDSEARCH']),
    'predefined.function': new Set([
        'AVG',
        'COUNT',
        'DISTINCT_COUNT',
        'ESTDC',
        'ESTDC_ERROR',
        'MAX',
        'MEAN',
        'MEDIAN',
        'MIN',
        'MODE',
        'RANGE',
        'STDEV',
        'STDEVP',
        'SUM',
        'SUMSQ',
        'VAR_SAMP',
        'VAR_POP',
        'STDDEV_SAMP',
        'STDDEV_POP',
        'PERCENTILE',
        'TAKE',
        'FIRST',
        'LAST',
        'LIST',
        'VALUES',
        'EARLIEST',
        'EARLIEST_TIME',
        'LATEST',
        'LATEST_TIME',
        'PER_DAY',
        'PER_HOUR',
        'PER_MINUTE',
        'PER_SECOND',
        'RATE',
        'SPARKLINE',
        'C',
        'DC',
        'ABS',
        'CBRT',
        'CEIL',
        'CEILING',
        'CONV',
        'CRC32',
        'E',
        'EXP',
        'FLOOR',
        'LN',
        'LOG',
        'LOG10',
        'LOG2',
        'MOD',
        'PI',
        'POSITION',
        'POW',
        'POWER',
        'RAND',
        'ROUND',
        'SIGN',
        'SQRT',
        'TRUNCATE',
        'ACOS',
        'ASIN',
        'ATAN',
        'ATAN2',
        'COS',
        'COT',
        'DEGREES',
        'RADIANS',
        'SIN',
        'TAN',
        'SPAN',
        'MATCH',
        'MATCH_PHRASE',
        'MATCH_PHRASE_PREFIX',
        'MATCH_BOOL_PREFIX',
    ]),
    predefined: new Set([
        'ADDDATE',
        'ADDTIME',
        'CURDATE',
        'CURRENT_DATE',
        'CURRENT_TIME',
        'CURRENT_TIMESTAMP',
        'CURTIME',
        'DATE',
        'DATEDIFF',
        'DATE_ADD',
        'DATE_FORMAT',
        'DATE_SUB',
        'DAYNAME',
        'DAYOFMONTH',
        'DAYOFWEEK',
        'DAYOFYEAR',
        'DAY_OF_MONTH',
        'DAY_OF_WEEK',
        'EXTRACT',
        'FROM_DAYS',
        'FROM_UNIXTIME',
        'GET_FORMAT',
        'LAST_DAY',
        'LOCALTIME',
        'LOCALTIMESTAMP',
        'MAKEDATE',
        'MAKETIME',
        'MONTHNAME',
        'NOW',
        'PERIOD_ADD',
        'PERIOD_DIFF',
        'SEC_TO_TIME',
        'STR_TO_DATE',
        'SUBDATE',
        'SUBTIME',
        'SYSDATE',
        'TIME',
        'TIMEDIFF',
        'TIMESTAMPADD',
        'TIMESTAMPDIFF',
        'TIME_FORMAT',
        'TIME_TO_SEC',
        'TO_DAYS',
        'TO_SECONDS',
        'UNIX_TIMESTAMP',
        'UTC_DATE',
        'UTC_TIME',
        'UTC_TIMESTAMP',
        'WEEKDAY',
        'YEARWEEK',
        'SUBSTR',
        'SUBSTRING',
        'LTRIM',
        'RTRIM',
        'TRIM',
        'TO',
        'LOWER',
        'UPPER',
        'CONCAT',
        'CONCAT_WS',
        'LENGTH',
        'STRCMP',
        'RIGHT',
        'LEFT',
        'ASCII',
        'LOCATE',
        'REPLACE',
        'REVERSE',
        'CAST',
        'LIKE',
        'ISNULL',
        'ISNOTNULL',
        'IFNULL',
        'NULLIF',
        'IF',
        'TYPEOF',
        'SIMPLE_QUERY_STRING',
        'MULTI_MATCH',
        'QUERY_STRING',
    ]),
    operator: new Set([
        'PIPE',
        'COMMA',
        'DOT',
        'EQUAL',
        'GREATER',
        'LESS',
        'NOT_GREATER',
        'NOT_LESS',
        'NOT_EQUAL',
        'PLUS',
        'MINUS',
        'STAR',
        'DIVIDE',
        'MODULE',
        'EXCLAMATION_SYMBOL',
        'COLON',
        'BIT_NOT_OP',
        'BIT_AND_OP',
        'BIT_XOR_OP',
    ]),
    delimiter: new Set([
        'LT_PRTHS',
        'RT_PRTHS',
        'LT_SQR_PRTHS',
        'RT_SQR_PRTHS',
        'SINGLE_QUOTE',
        'DOUBLE_QUOTE',
        'BACKTICK',
    ]),
    variable: new Set(['ID', 'CLUSTER', 'TIMESTAMP', 'BQUOTA_STRING']),
    string: new Set(['DQUOTA_STRING', 'SQUOTA_STRING']),
    number: new Set(['INTEGER_LITERAL', 'DECIMAL_LITERAL']),
    comment: new Set(['COMMENT', 'LINE_COMMENT']),
    white: new Set(['SPACE']),
};
//# sourceMappingURL=constants.js.map