/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.dataprocessor.ImputationMethod;
import org.opensearch.timeseries.dataprocessor.ImputationOption;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ShingleGetter;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.settings.TimeSeriesSettings;
import org.opensearch.timeseries.util.TimeUtil;
import org.owasp.encoder.Encode;

public abstract class Config
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(Config.class);
    public static final int MAX_RESULT_INDEX_NAME_SIZE = 255;
    public static final String RESULT_INDEX_NAME_PATTERN = "[a-z0-9_-]+";
    public static final String NO_ID = "";
    public static final String TIMEOUT = "timeout";
    public static final String GENERAL_SETTINGS = "general_settings";
    public static final String AGGREGATION = "aggregation_issue";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String TIMEFIELD_FIELD = "time_field";
    public static final String INDICES_FIELD = "indices";
    public static final String UI_METADATA_FIELD = "ui_metadata";
    public static final String FILTER_QUERY_FIELD = "filter_query";
    public static final String FEATURE_ATTRIBUTES_FIELD = "feature_attributes";
    public static final String WINDOW_DELAY_FIELD = "window_delay";
    public static final String SHINGLE_SIZE_FIELD = "shingle_size";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String CATEGORY_FIELD = "category_field";
    public static final String USER_FIELD = "user";
    public static final String RESULT_INDEX_FIELD = "result_index";
    public static final String IMPUTATION_OPTION_FIELD = "imputation_option";
    public static final String SEASONALITY_FIELD = "suggested_seasonality";
    public static final String RECENCY_EMPHASIS_FIELD = "recency_emphasis";
    public static final String HISTORY_INTERVAL_FIELD = "history";
    public static final String RESULT_INDEX_FIELD_MIN_SIZE = "result_index_min_size";
    public static final String RESULT_INDEX_FIELD_MIN_AGE = "result_index_min_age";
    public static final String RESULT_INDEX_FIELD_TTL = "result_index_ttl";
    public static final String FLATTEN_CUSTOM_RESULT_INDEX = "flatten_custom_result_index";
    public static final String AUTO_CREATED_FIELD = "auto_created";
    public static final String BREAKING_UI_CHANGE_TIME = "last_ui_breaking_change_time";
    public static final String FREQUENCY_FIELD = "frequency";
    protected String id;
    protected Long version;
    protected String name;
    protected String description;
    protected String timeField;
    protected List<String> indices;
    protected List<Feature> featureAttributes;
    protected QueryBuilder filterQuery;
    protected TimeConfiguration interval;
    protected TimeConfiguration windowDelay;
    protected Integer shingleSize;
    protected String customResultIndexOrAlias;
    protected Map<String, Object> uiMetadata;
    protected Integer schemaVersion;
    protected Instant lastUpdateTime;
    protected List<String> categoryFields;
    protected User user;
    protected ImputationOption imputationOption;
    protected Integer recencyEmphasis;
    protected String errorMessage;
    protected ValidationIssueType issueType;
    protected Integer seasonIntervals;
    protected Integer historyIntervals;
    protected Integer customResultIndexMinSize;
    protected Integer customResultIndexMinAge;
    protected Integer customResultIndexTTL;
    protected Boolean flattenResultIndexMapping;
    protected Instant lastUIBreakingChangeTime;
    protected TimeConfiguration frequency;
    protected Boolean autoCreated;
    public static String INVALID_RESULT_INDEX_NAME_SIZE = "Result index name size must contains less than 255 characters";

    protected Config(String id, Long version, String name, String description, String timeField, List<String> indices, List<Feature> features, QueryBuilder filterQuery, TimeConfiguration windowDelay, Integer shingleSize, Map<String, Object> uiMetadata, Integer schemaVersion, Instant lastUpdateTime, List<String> categoryFields, User user, String resultIndex, TimeConfiguration interval, ImputationOption imputationOption, Integer recencyEmphasis, Integer seasonIntervals, ShingleGetter shingleGetter, Integer historyIntervals, Integer customResultIndexMinSize, Integer customResultIndexMinAge, Integer customResultIndexTTL, Boolean flattenResultIndexMapping, Instant lastBreakingUIChangeTime, TimeConfiguration frequency, Boolean autoCreated) {
        if (Strings.isBlank((String)name)) {
            this.errorMessage = CommonMessages.EMPTY_NAME;
            this.issueType = ValidationIssueType.NAME;
            return;
        }
        if (Strings.isBlank((String)timeField)) {
            this.errorMessage = CommonMessages.NULL_TIME_FIELD;
            this.issueType = ValidationIssueType.TIMEFIELD_FIELD;
            return;
        }
        if (indices == null || indices.isEmpty()) {
            this.errorMessage = CommonMessages.EMPTY_INDICES;
            this.issueType = ValidationIssueType.INDICES;
            return;
        }
        if (this.failIfOutOfRange(this.invalidShingleSizeRange(shingleSize), this.getMinimumShingle(), 128, shingleSize, ValidationIssueType.SHINGLE_SIZE_FIELD, "Suggested shingle size")) {
            return;
        }
        int minSeasonality = this.getMinimumShingle() * 2;
        int maxSeasonality = 256;
        if (this.failIfOutOfRange(this.invalidSeasonality(seasonIntervals), minSeasonality, maxSeasonality, seasonIntervals, ValidationIssueType.SUGGESTED_SEASONALITY_FIELD, "Suggested seasonality")) {
            return;
        }
        this.errorMessage = this.validateCustomResultIndex(resultIndex);
        if (this.errorMessage != null) {
            this.issueType = ValidationIssueType.RESULT_INDEX;
            return;
        }
        if (recencyEmphasis != null && recencyEmphasis <= 1) {
            this.issueType = ValidationIssueType.RECENCY_EMPHASIS;
            this.errorMessage = "Recency emphasis must be an integer greater than 1.";
            return;
        }
        this.errorMessage = this.validateDescription(description);
        if (this.errorMessage != null) {
            this.issueType = ValidationIssueType.DESCRIPTION;
            return;
        }
        if (historyIntervals != null && (historyIntervals <= 0 || historyIntervals > 10000)) {
            this.issueType = ValidationIssueType.HISTORY;
            this.errorMessage = "We cannot look back more than 10000 intervals.";
            return;
        }
        List<String> redundantNames = Config.findRedundantNames(features);
        if (redundantNames.size() > 0) {
            this.issueType = ValidationIssueType.FEATURE_ATTRIBUTES;
            this.errorMessage = String.valueOf(redundantNames) + " appears more than once. Feature name has to be unique";
            return;
        }
        if (imputationOption != null && imputationOption.getMethod() == ImputationMethod.FIXED_VALUES) {
            List enabledFeatures = features == null ? null : features.stream().filter(Feature::getEnabled).collect(Collectors.toList());
            Map<String, Double> defaultFill = imputationOption.getDefaultFill();
            if (enabledFeatures == null && defaultFill != null && !defaultFill.isEmpty()) {
                this.issueType = ValidationIssueType.IMPUTATION;
                this.errorMessage = "Enabled features list is null, but default fill values are provided.";
                return;
            }
            if (enabledFeatures != null && (defaultFill == null || defaultFill.isEmpty())) {
                this.issueType = ValidationIssueType.IMPUTATION;
                this.errorMessage = "Enabled features are present, but no default fill values are provided.";
                return;
            }
            if (enabledFeatures != null && defaultFill != null && defaultFill.size() != enabledFeatures.size()) {
                this.issueType = ValidationIssueType.IMPUTATION;
                this.errorMessage = String.format(Locale.ROOT, "Mismatch between the number of enabled features and default fill values. Number of default fill values: %d. Number of enabled features: %d.", defaultFill.size(), enabledFeatures.size());
                return;
            }
            for (int i = 0; i < enabledFeatures.size(); ++i) {
                if (defaultFill.containsKey(((Feature)enabledFeatures.get(i)).getName())) continue;
                this.issueType = ValidationIssueType.IMPUTATION;
                this.errorMessage = String.format(Locale.ROOT, "Missing feature name: %s.", ((Feature)enabledFeatures.get(i)).getName());
                return;
            }
        }
        if (frequency != null && interval != null) {
            Duration frequencyDuration = ((IntervalTimeConfiguration)frequency).toDuration();
            Duration intervalDuration = ((IntervalTimeConfiguration)interval).toDuration();
            if (intervalDuration.isZero()) {
                return;
            }
            if (frequencyDuration.isZero()) {
                this.issueType = ValidationIssueType.FREQUENCY;
                this.errorMessage = "Frequency must be greater than 0.";
                return;
            }
            if (!TimeUtil.isMultiple(frequencyDuration, intervalDuration)) {
                this.issueType = ValidationIssueType.FREQUENCY;
                this.errorMessage = String.format(Locale.ROOT, "Frequency (%s) must be a multiple of interval (%s), including the interval itself.", frequency.toString(), interval.toString());
                return;
            }
            long multiple = TimeUtil.getMultiple(frequencyDuration, intervalDuration);
            if (multiple > 10000L) {
                this.issueType = ValidationIssueType.FREQUENCY;
                this.errorMessage = String.format(Locale.ROOT, "Frequency multiple (%d) exceeds the maximum allowed value (%d). Frequency: %s, Interval: %s.", multiple, 10000, frequency.toString(), interval.toString());
                return;
            }
        }
        this.id = id;
        this.version = version;
        this.name = name;
        this.description = description;
        this.timeField = timeField;
        this.indices = indices;
        this.featureAttributes = features == null ? ImmutableList.of() : ImmutableList.copyOf(features);
        this.filterQuery = filterQuery;
        this.interval = interval;
        this.windowDelay = windowDelay;
        this.shingleSize = shingleGetter.getShingleSize(shingleSize);
        this.uiMetadata = uiMetadata;
        this.schemaVersion = schemaVersion;
        this.lastUpdateTime = lastUpdateTime;
        this.categoryFields = categoryFields;
        this.user = user;
        this.customResultIndexOrAlias = Strings.trimToNull((String)resultIndex);
        this.imputationOption = imputationOption;
        this.issueType = null;
        this.errorMessage = null;
        this.recencyEmphasis = Optional.ofNullable(recencyEmphasis).orElse(2560);
        this.seasonIntervals = seasonIntervals;
        this.historyIntervals = historyIntervals == null ? this.getDefaultHistory() : historyIntervals.intValue();
        this.customResultIndexMinSize = Strings.trimToNull((String)resultIndex) == null ? null : customResultIndexMinSize;
        this.customResultIndexMinAge = Strings.trimToNull((String)resultIndex) == null ? null : customResultIndexMinAge;
        this.customResultIndexTTL = Strings.trimToNull((String)resultIndex) == null ? null : customResultIndexTTL;
        this.flattenResultIndexMapping = Strings.trimToNull((String)resultIndex) == null ? null : flattenResultIndexMapping;
        this.lastUIBreakingChangeTime = lastBreakingUIChangeTime;
        this.frequency = frequency;
        this.autoCreated = autoCreated != null ? autoCreated : false;
    }

    private boolean failIfOutOfRange(boolean invalid, int min, int max, Integer actual, ValidationIssueType type, String label) {
        if (!invalid || actual == null) {
            return false;
        }
        this.errorMessage = String.format(Locale.ROOT, "%s must be between %d and %d. Got %d.", label, min, max, actual);
        this.issueType = type;
        return true;
    }

    public int getDefaultHistory() {
        return 32 + this.shingleSize;
    }

    public Config(StreamInput input) throws IOException {
        this.id = input.readOptionalString();
        this.version = input.readOptionalLong();
        this.name = input.readString();
        this.description = input.readOptionalString();
        this.timeField = input.readString();
        this.indices = input.readStringList();
        this.featureAttributes = input.readList(Feature::new);
        this.filterQuery = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
        this.interval = IntervalTimeConfiguration.readFrom(input);
        this.windowDelay = IntervalTimeConfiguration.readFrom(input);
        this.shingleSize = input.readInt();
        this.schemaVersion = input.readInt();
        this.categoryFields = input.readOptionalStringList();
        this.lastUpdateTime = input.readInstant();
        this.user = input.readBoolean() ? new User(input) : null;
        this.uiMetadata = input.readBoolean() ? input.readMap() : null;
        this.customResultIndexOrAlias = input.readOptionalString();
        this.imputationOption = input.readBoolean() ? new ImputationOption(input) : null;
        this.recencyEmphasis = input.readInt();
        this.seasonIntervals = input.readOptionalInt();
        this.historyIntervals = input.readInt();
        this.customResultIndexMinSize = input.readOptionalInt();
        this.customResultIndexMinAge = input.readOptionalInt();
        this.customResultIndexTTL = input.readOptionalInt();
        this.flattenResultIndexMapping = input.readOptionalBoolean();
        this.lastUIBreakingChangeTime = input.readOptionalInstant();
        this.frequency = input.readBoolean() ? IntervalTimeConfiguration.readFrom(input) : null;
        this.autoCreated = input.readOptionalBoolean();
    }

    public Config() {
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeOptionalString(this.id);
        output.writeOptionalLong(this.version);
        output.writeString(this.name);
        output.writeOptionalString(this.description);
        output.writeString(this.timeField);
        output.writeStringCollection(this.indices);
        output.writeList(this.featureAttributes);
        output.writeNamedWriteable((NamedWriteable)this.filterQuery);
        this.interval.writeTo(output);
        this.windowDelay.writeTo(output);
        output.writeInt(this.shingleSize.intValue());
        output.writeInt(this.schemaVersion.intValue());
        output.writeOptionalStringCollection(this.categoryFields);
        output.writeInstant(this.lastUpdateTime);
        if (this.user != null) {
            output.writeBoolean(true);
            this.user.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        if (this.uiMetadata != null) {
            output.writeBoolean(true);
            output.writeMap(this.uiMetadata);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.customResultIndexOrAlias);
        if (this.imputationOption != null) {
            output.writeBoolean(true);
            this.imputationOption.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeInt(this.recencyEmphasis.intValue());
        output.writeOptionalInt(this.seasonIntervals);
        output.writeInt(this.historyIntervals.intValue());
        output.writeOptionalInt(this.customResultIndexMinSize);
        output.writeOptionalInt(this.customResultIndexMinAge);
        output.writeOptionalInt(this.customResultIndexTTL);
        output.writeOptionalBoolean(this.flattenResultIndexMapping);
        output.writeOptionalInstant(this.lastUIBreakingChangeTime);
        if (this.frequency != null) {
            output.writeBoolean(true);
            this.frequency.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalBoolean(this.autoCreated);
    }

    public boolean invalidShingleSizeRange(Integer shingleSizeToTest) {
        return shingleSizeToTest != null && (shingleSizeToTest < 1 || shingleSizeToTest > 128);
    }

    public boolean invalidSeasonality(Integer seasonalityToTest) {
        if (seasonalityToTest == null) {
            return false;
        }
        return this.invalidShingleSizeRange(Math.max(1, seasonalityToTest / 2));
    }

    protected abstract ValidationAspect getConfigValidationAspect();

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equal((Object)this.name, (Object)config.name) && Objects.equal((Object)this.description, (Object)config.description) && Objects.equal((Object)this.timeField, (Object)config.timeField) && Objects.equal(this.indices, config.indices) && Objects.equal(this.featureAttributes, config.featureAttributes) && Objects.equal((Object)this.filterQuery, (Object)config.filterQuery) && Objects.equal((Object)this.interval, (Object)config.interval) && Objects.equal((Object)this.windowDelay, (Object)config.windowDelay) && Objects.equal((Object)this.shingleSize, (Object)config.shingleSize) && Objects.equal(this.categoryFields, config.categoryFields) && Objects.equal((Object)this.user, (Object)config.user) && Objects.equal((Object)this.customResultIndexOrAlias, (Object)config.customResultIndexOrAlias) && Objects.equal((Object)this.imputationOption, (Object)config.imputationOption) && Objects.equal((Object)this.recencyEmphasis, (Object)config.recencyEmphasis) && Objects.equal((Object)this.seasonIntervals, (Object)config.seasonIntervals) && Objects.equal((Object)this.historyIntervals, (Object)config.historyIntervals) && Objects.equal((Object)this.customResultIndexMinSize, (Object)config.customResultIndexMinSize) && Objects.equal((Object)this.customResultIndexMinAge, (Object)config.customResultIndexMinAge) && Objects.equal((Object)this.customResultIndexTTL, (Object)config.customResultIndexTTL) && Objects.equal((Object)this.flattenResultIndexMapping, (Object)config.flattenResultIndexMapping) && Objects.equal((Object)this.frequency, (Object)config.frequency) && Objects.equal((Object)this.autoCreated, (Object)config.autoCreated);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.timeField, this.indices, this.featureAttributes, this.filterQuery, this.interval, this.windowDelay, this.shingleSize, this.categoryFields, this.schemaVersion, this.user, this.customResultIndexOrAlias, this.imputationOption, this.recencyEmphasis, this.seasonIntervals, this.historyIntervals, this.customResultIndexMinSize, this.customResultIndexMinAge, this.customResultIndexTTL, this.flattenResultIndexMapping, this.frequency, this.autoCreated});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NAME_FIELD, this.name).field(DESCRIPTION_FIELD, Encode.forHtml((String)this.description)).field(TIMEFIELD_FIELD, this.timeField).field(INDICES_FIELD, (Object)this.indices.toArray()).field(FILTER_QUERY_FIELD, (ToXContent)this.filterQuery).field(WINDOW_DELAY_FIELD, (ToXContent)this.windowDelay).field(SHINGLE_SIZE_FIELD, this.shingleSize).field("schema_version", this.schemaVersion).field(FEATURE_ATTRIBUTES_FIELD, (Object)this.featureAttributes.toArray()).field(RECENCY_EMPHASIS_FIELD, this.recencyEmphasis).field(HISTORY_INTERVAL_FIELD, this.historyIntervals);
        if (this.uiMetadata != null && !this.uiMetadata.isEmpty()) {
            builder.field(UI_METADATA_FIELD, this.uiMetadata);
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.categoryFields != null) {
            builder.field(CATEGORY_FIELD, (Object)this.categoryFields.toArray());
        }
        if (this.user != null) {
            builder.field(USER_FIELD, (ToXContent)this.user);
        }
        if (this.customResultIndexOrAlias != null) {
            builder.field(RESULT_INDEX_FIELD, this.customResultIndexOrAlias);
        }
        if (this.imputationOption != null) {
            builder.field(IMPUTATION_OPTION_FIELD, (ToXContent)this.imputationOption);
        }
        if (this.seasonIntervals != null) {
            builder.field(SEASONALITY_FIELD, this.seasonIntervals);
        }
        if (this.customResultIndexMinSize != null) {
            builder.field(RESULT_INDEX_FIELD_MIN_SIZE, this.customResultIndexMinSize);
        }
        if (this.customResultIndexMinAge != null) {
            builder.field(RESULT_INDEX_FIELD_MIN_AGE, this.customResultIndexMinAge);
        }
        if (this.customResultIndexTTL != null) {
            builder.field(RESULT_INDEX_FIELD_TTL, this.customResultIndexTTL);
        }
        if (this.flattenResultIndexMapping != null) {
            builder.field(FLATTEN_CUSTOM_RESULT_INDEX, this.flattenResultIndexMapping);
        }
        if (this.lastUIBreakingChangeTime != null) {
            builder.field(BREAKING_UI_CHANGE_TIME, this.lastUIBreakingChangeTime.toEpochMilli());
        }
        if (this.frequency != null) {
            builder.field(FREQUENCY_FIELD, (ToXContent)this.frequency);
        }
        if (this.autoCreated != null && this.autoCreated.booleanValue()) {
            builder.field(AUTO_CREATED_FIELD, this.autoCreated);
        }
        return builder;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public List<Feature> getFeatureAttributes() {
        return this.featureAttributes;
    }

    public QueryBuilder getFilterQuery() {
        return this.filterQuery;
    }

    public List<String> getEnabledFeatureIds() {
        return this.featureAttributes.stream().filter(Feature::getEnabled).map(Feature::getId).collect(Collectors.toList());
    }

    public List<String> getEnabledFeatureNames() {
        return this.featureAttributes.stream().filter(Feature::getEnabled).map(Feature::getName).collect(Collectors.toList());
    }

    public TimeConfiguration getInterval() {
        return this.interval;
    }

    public TimeConfiguration getWindowDelay() {
        return this.windowDelay;
    }

    public Integer getShingleSize() {
        return this.shingleSize;
    }

    public Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public List<String> getCategoryFields() {
        return this.categoryFields;
    }

    public String getId() {
        return this.id;
    }

    public long getIntervalInMilliseconds() {
        return ((IntervalTimeConfiguration)this.getInterval()).toDuration().toMillis();
    }

    public long getIntervalInSeconds() {
        return this.getIntervalInMilliseconds() / 1000L;
    }

    public long getIntervalInMinutes() {
        return this.getIntervalInMilliseconds() / 1000L / 60L;
    }

    public Duration getIntervalDuration() {
        return ((IntervalTimeConfiguration)this.getInterval()).toDuration();
    }

    public User getUser() {
        return this.user;
    }

    public TimeConfiguration getFrequency() {
        return this.frequency;
    }

    public TimeConfiguration getInferredFrequency() {
        return this.frequency == null ? this.getInterval() : this.frequency;
    }

    public long getInferredFrequencyInMilliseconds() {
        return ((IntervalTimeConfiguration)this.getInferredFrequency()).toDuration().toMillis();
    }

    public long getInferredFrequencyInMinutes() {
        return this.getInferredFrequencyInMilliseconds() / 1000L / 60L;
    }

    public Duration getInferredFrequencyDuration() {
        return ((IntervalTimeConfiguration)this.getInferredFrequency()).toDuration();
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getCustomResultIndexOrAlias() {
        return this.customResultIndexOrAlias;
    }

    public String getCustomResultIndexPattern() {
        return Strings.isEmpty((CharSequence)this.customResultIndexOrAlias) ? null : IndexManagement.getAllCustomResultIndexPattern(this.customResultIndexOrAlias);
    }

    public boolean isHighCardinality() {
        return Config.isHC(this.getCategoryFields());
    }

    public boolean hasMultipleCategories() {
        return this.categoryFields != null && this.categoryFields.size() > 1;
    }

    public String validateCustomResultIndex(String resultIndex) {
        if (resultIndex == null) {
            return null;
        }
        if (resultIndex.length() > 255) {
            return INVALID_RESULT_INDEX_NAME_SIZE;
        }
        if (!resultIndex.matches(RESULT_INDEX_NAME_PATTERN)) {
            return CommonMessages.INVALID_CHAR_IN_RESULT_INDEX_NAME;
        }
        return null;
    }

    public String validateDescription(String description) {
        if (Strings.isEmpty((CharSequence)description)) {
            return null;
        }
        if (description.length() > 1000) {
            return "Description length is too long. Max length is 1000 characters.";
        }
        return null;
    }

    public static boolean isHC(List<String> categoryFields) {
        return categoryFields != null && categoryFields.size() > 0;
    }

    public ImputationOption getImputationOption() {
        return this.imputationOption;
    }

    public Double getTimeDecay() {
        return 1.0 / (double)this.recencyEmphasis.intValue();
    }

    protected void checkAndThrowValidationErrors(ValidationAspect validationAspect) {
        if (this.errorMessage != null && this.issueType != null) {
            throw new ValidationException(this.errorMessage, this.issueType, validationAspect);
        }
        if (this.errorMessage != null || this.issueType != null) {
            throw new TimeSeriesException(CommonMessages.FAIL_TO_VALIDATE);
        }
    }

    public static Config parseConfig(Class<? extends Config> configClass, XContentParser parser) throws IOException {
        if (configClass == AnomalyDetector.class) {
            return AnomalyDetector.parse(parser);
        }
        if (configClass == Forecaster.class) {
            return Forecaster.parse(parser);
        }
        throw new IllegalArgumentException("Unsupported config type. Supported config types are [AnomalyDetector, Forecaster]");
    }

    public Integer getSeasonIntervals() {
        return this.seasonIntervals;
    }

    public Integer getRecencyEmphasis() {
        return this.recencyEmphasis;
    }

    public Integer getHistoryIntervals() {
        return this.historyIntervals;
    }

    public Integer getCustomResultIndexMinSize() {
        return this.customResultIndexMinSize;
    }

    public Integer getCustomResultIndexMinAge() {
        return this.customResultIndexMinAge;
    }

    public Integer getCustomResultIndexTTL() {
        return this.customResultIndexTTL;
    }

    public boolean getFlattenResultIndexMapping() {
        return this.flattenResultIndexMapping != null ? this.flattenResultIndexMapping : false;
    }

    public boolean getAutoCreated() {
        return this.autoCreated != null ? this.autoCreated : false;
    }

    public String getFlattenResultIndexAlias() {
        if (this.getFlattenResultIndexMapping()) {
            return (this.getCustomResultIndexOrAlias() + "_flattened_" + this.getName()).toLowerCase(Locale.ROOT);
        }
        return null;
    }

    public String getFlattenResultIndexIngestPipelineName() {
        if (this.getFlattenResultIndexMapping()) {
            return ("flatten_result_index_ingest_pipeline_" + this.getName()).toLowerCase(Locale.ROOT);
        }
        return null;
    }

    public Instant getLastBreakingUIChangeTime() {
        return this.lastUIBreakingChangeTime;
    }

    public static List<String> findRedundantNames(List<Feature> features) {
        if (features == null || features.isEmpty()) {
            return new ArrayList<String>();
        }
        Map nameCounts = features.stream().map(Feature::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List<String> redundantNames = nameCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        return redundantNames;
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append(NAME_FIELD, (Object)this.name).append(DESCRIPTION_FIELD, (Object)this.description).append("timeField", (Object)this.timeField).append(INDICES_FIELD, this.indices).append("featureAttributes", this.featureAttributes).append("filterQuery", (Object)this.filterQuery).append("interval", (Object)this.interval).append("windowDelay", (Object)this.windowDelay).append("shingleSize", (Object)this.shingleSize).append("categoryFields", this.categoryFields).append("schemaVersion", (Object)this.schemaVersion).append(USER_FIELD, (Object)this.user).append("customResultIndex", (Object)this.customResultIndexOrAlias).append("imputationOption", (Object)this.imputationOption).append("recencyEmphasis", (Object)this.recencyEmphasis).append("seasonIntervals", (Object)this.seasonIntervals).append("historyIntervals", (Object)this.historyIntervals).append("customResultIndexMinSize", (Object)this.customResultIndexMinSize).append("customResultIndexMinAge", (Object)this.customResultIndexMinAge).append("customResultIndexTTL", (Object)this.customResultIndexTTL).append("flattenResultIndexMapping", (Object)this.flattenResultIndexMapping).append(FREQUENCY_FIELD, (Object)this.frequency).append("autoCreated", (Object)this.autoCreated).toString();
    }

    protected static Integer onlyParseNumberValue(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return parser.intValue();
        }
        return null;
    }

    protected static Boolean onlyParseBooleanValue(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
            return parser.booleanValue();
        }
        return null;
    }

    protected int getMinimumShingle() {
        return 1;
    }

    public boolean isLongFrequency() {
        return this.getInferredFrequencyDuration().compareTo(TimeSeriesSettings.HOURLY_MAINTENANCE) >= 0;
    }
}

