/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.AbstractVectorModel;
import com.hankcs.hanlp.mining.word2vec.Vector;
import com.hankcs.hanlp.mining.word2vec.VectorsReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

public class WordVectorModel
extends AbstractVectorModel<String> {
    public WordVectorModel(String modelFileName) throws IOException {
        this(modelFileName, new TreeMap<String, Vector>());
    }

    public WordVectorModel(String modelFileName, Map<String, Vector> storage) throws IOException {
        super(WordVectorModel.loadVectorMap(modelFileName, storage));
    }

    private static Map<String, Vector> loadVectorMap(String modelFileName, Map<String, Vector> storage) throws IOException {
        VectorsReader reader = new VectorsReader(modelFileName);
        reader.readVectorFile();
        for (int i = 0; i < reader.vocab.length; ++i) {
            storage.put(reader.vocab[i], new Vector(reader.matrix[i]));
        }
        return storage;
    }

    public List<Map.Entry<String, Float>> analogy(String A, String B, String C) {
        return this.analogy(A, B, C, 10);
    }

    public List<Map.Entry<String, Float>> analogy(String A, String B, String C, int size) {
        Vector a = (Vector)this.storage.get(A);
        Vector b = (Vector)this.storage.get(B);
        Vector c = (Vector)this.storage.get(C);
        if (a == null || b == null || c == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<String, Float>> resultList = this.nearest(a.minus(b).add(c), size + 3);
        ListIterator listIterator = resultList.listIterator();
        while (listIterator.hasNext()) {
            String key = (String)listIterator.next().getKey();
            if (!key.equals(A) && !key.equals(B) && !key.equals(C)) continue;
            listIterator.remove();
        }
        if (resultList.size() > size) {
            resultList = resultList.subList(0, size);
        }
        return resultList;
    }

    @Override
    public Vector query(String query) {
        return this.vector(query);
    }
}

