/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.kubernetes;

import java.util.Map;
import org.keycloak.Config;
import org.keycloak.broker.kubernetes.KubernetesIdentityProvider;
import org.keycloak.broker.kubernetes.KubernetesIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class KubernetesIdentityProviderFactory
extends AbstractIdentityProviderFactory<KubernetesIdentityProvider>
implements EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "kubernetes";
    private String globalJwksUrl;

    public String getName() {
        return "Kubernetes";
    }

    public KubernetesIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new KubernetesIdentityProvider(session, new KubernetesIdentityProviderConfig(model), this.globalJwksUrl);
    }

    public void init(Config.Scope config) {
        String kubernetesServiceHost = System.getenv("KUBERNETES_SERVICE_HOST");
        String kubernetesServicePortHttps = System.getenv("KUBERNETES_SERVICE_PORT_HTTPS");
        if (kubernetesServiceHost != null && kubernetesServicePortHttps != null) {
            this.globalJwksUrl = "https://" + kubernetesServiceHost + ":" + kubernetesServicePortHttps + "/openid/v1/jwks";
        }
    }

    public Map<String, String> parseConfig(KeycloakSession session, String configString) {
        throw new UnsupportedOperationException();
    }

    public IdentityProviderModel createConfig() {
        return new KubernetesIdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.KUBERNETES_SERVICE_ACCOUNTS);
    }
}

