/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.FileLog;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.PrintStreamLogger;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;
import net.sourceforge.jnlp.util.logging.UnixSystemLog;
import net.sourceforge.jnlp.util.logging.WinSystemLog;
import net.sourceforge.jnlp.util.logging.headers.Header;
import net.sourceforge.jnlp.util.logging.headers.JavaMessage;
import net.sourceforge.jnlp.util.logging.headers.MessageWithHeader;

public class OutputController {
    private static final String NULL_OBJECT = "Trying to log null object";
    private PrintStreamLogger outLog;
    private PrintStreamLogger errLog;
    private final List<MessageWithHeader> messageQue = new LinkedList<MessageWithHeader>();
    private final MessageQueConsumer messageQueConsumer = new MessageQueConsumer();
    Thread consumerThread;
    private BufferedReader br;

    public synchronized void flush() {
        while (!this.messageQue.isEmpty()) {
            this.consume();
        }
    }

    public void close() throws Exception {
        this.flush();
        if (LogConfig.getLogConfig().isLogToFile()) {
            this.getFileLog().close();
        }
    }

    private void consume() {
        MessageWithHeader s = this.messageQue.get(0);
        this.messageQue.remove(0);
        if (LogConfig.getLogConfig().isLogToConsole()) {
            JavaConsole.getConsole().addMessage(s);
        }
        if (s.getHeader().isClientApp) {
            if (LogConfig.getLogConfig().isLogToFile() && LogConfig.getLogConfig().isLogToFileForClientApp()) {
                this.getAppFileLog().log(this.proceedHeader(s));
            }
            return;
        }
        if (!(JNLPRuntime.isDebug() || s.getHeader().level != Level.MESSAGE_DEBUG && s.getHeader().level != Level.WARNING_DEBUG && s.getHeader().level != Level.ERROR_DEBUG)) {
            return;
        }
        String message = this.proceedHeader(s);
        if (LogConfig.getLogConfig().isLogToStreams()) {
            if (s.getHeader().level.isOutput()) {
                this.outLog.log(message);
            }
            if (s.getHeader().level.isError()) {
                this.errLog.log(message);
            }
        }
        if (LogConfig.getLogConfig().isLogToFile()) {
            this.getFileLog().log(message);
        }
        if (LogConfig.getLogConfig().isLogToSysLog() && (s.getHeader().level.equals((Object)Level.ERROR_ALL) || s.getHeader().level.equals((Object)Level.WARNING_ALL)) && !s.getHeader().isC) {
            this.getSystemLog().log(s.getMessage());
        }
    }

    private String proceedHeader(MessageWithHeader s) {
        String message = s.getMessage();
        if (LogConfig.getLogConfig().isEnableHeaders()) {
            message = message.contains("\n") ? s.getHeader().toString() + "\n" + message : s.getHeader().toString() + " " + message;
        }
        return message;
    }

    private OutputController() {
        this(System.out, System.err);
    }

    public static OutputController getLogger() {
        return OutputControllerHolder.INSTANCE;
    }

    public OutputController(PrintStream out, PrintStream err) {
        if (out == null || err == null) {
            throw new IllegalArgumentException("No stream can be null");
        }
        this.outLog = new PrintStreamLogger(out);
        this.errLog = new PrintStreamLogger(err);
        this.consumerThread = new Thread((Runnable)this.messageQueConsumer, "Output controller consumer daemon");
        this.consumerThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                OutputController.this.flush();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConsumer() {
        this.consumerThread.start();
        OutputController outputController = this;
        synchronized (outputController) {
            this.notifyAll();
        }
    }

    public PrintStream getOut() {
        this.flush();
        return this.outLog.getStream();
    }

    public PrintStream getErr() {
        this.flush();
        return this.errLog.getStream();
    }

    public void setOut(PrintStream out) {
        this.flush();
        this.outLog.setStream(out);
    }

    public void setErr(PrintStream err) {
        this.flush();
        this.errLog.setStream(err);
    }

    public static String exceptionToString(Throwable t) {
        if (t == null) {
            return null;
        }
        String s = "Error during processing of exception";
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            s = sw.toString();
            pw.close();
            sw.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return s;
    }

    public void log(Level level, String s) {
        this.log(level, (Object)s);
    }

    public void log(Level level, Throwable s) {
        this.log(level, (Object)s);
    }

    public void log(String s) {
        this.log(Level.MESSAGE_DEBUG, (Object)s);
    }

    public void log(Throwable s) {
        this.log(Level.ERROR_DEBUG, (Object)s);
    }

    private void log(Level level, Object o) {
        String s = "";
        s = o == null ? NULL_OBJECT : (o instanceof Throwable ? OutputController.exceptionToString((Throwable)o) : o.toString());
        this.log(new JavaMessage(new Header(level, false), s));
    }

    synchronized void log(MessageWithHeader l) {
        this.messageQue.add(l);
        this.notifyAll();
    }

    private SingleStreamLogger getFileLog() {
        return FileLogHolder.INSTANCE;
    }

    private SingleStreamLogger getAppFileLog() {
        return AppFileLogHolder.INSTANCE;
    }

    private SingleStreamLogger getSystemLog() {
        return SystemLogHolder.INSTANCE;
    }

    public void printErrorLn(String e) {
        this.getErr().println(e);
    }

    public void printOutLn(String e) {
        this.getOut().println(e);
    }

    public void printWarningLn(String e) {
        this.printOutLn(e);
        this.printErrorLn(e);
    }

    public void printError(String e) {
        this.getErr().print(e);
    }

    public void printOut(String e) {
        this.getOut().print(e);
    }

    public void printWarning(String e) {
        this.printOut(e);
        this.printError(e);
    }

    void setErrLog(PrintStreamLogger errLog) {
        this.errLog = errLog;
    }

    void setFileLog(SingleStreamLogger fileLog) {
        FileLogHolder.INSTANCE = fileLog;
    }

    void setAppFileLog(SingleStreamLogger fileLog) {
        AppFileLogHolder.INSTANCE = fileLog;
    }

    void setOutLog(PrintStreamLogger outLog) {
        this.outLog = outLog;
    }

    void setSysLog(SingleStreamLogger sysLog) {
        SystemLogHolder.INSTANCE = sysLog;
    }

    public synchronized String readLine() throws IOException {
        if (this.br == null) {
            this.br = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.br.readLine();
    }

    private static class SystemLogHolder {
        private static volatile SingleStreamLogger INSTANCE = SystemLogHolder.initSystemLogger();

        private SystemLogHolder() {
        }

        private static SingleStreamLogger initSystemLogger() {
            if (JNLPRuntime.isWindows()) {
                return new WinSystemLog();
            }
            return new UnixSystemLog();
        }
    }

    private static class AppFileLogHolder {
        private static volatile SingleStreamLogger INSTANCE = FileLog.createAppFileLog();

        private AppFileLogHolder() {
        }
    }

    private static class FileLogHolder {
        private static volatile SingleStreamLogger INSTANCE = FileLog.createFileLog();

        private FileLogHolder() {
        }
    }

    private static class OutputControllerHolder {
        private static final OutputController INSTANCE = new OutputController();

        private OutputControllerHolder() {
        }
    }

    private class MessageQueConsumer
    implements Runnable {
        private MessageQueConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        OutputController outputController = OutputController.this;
                        synchronized (outputController) {
                            OutputController.this.wait(1000L);
                            if (OutputController.this != null && !OutputController.this.messageQue.isEmpty()) {
                                OutputController.this.flush();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    OutputController.getLogger().log(t);
                    continue;
                }
                break;
            }
        }
    }

    public static enum Level {
        MESSAGE_ALL,
        MESSAGE_DEBUG,
        WARNING_ALL,
        WARNING_DEBUG,
        ERROR_ALL,
        ERROR_DEBUG;


        public boolean isOutput() {
            return this == MESSAGE_ALL || this == MESSAGE_DEBUG || this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isError() {
            return this == ERROR_ALL || this == ERROR_DEBUG || this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isWarning() {
            return this == WARNING_ALL || this == WARNING_DEBUG;
        }

        public boolean isDebug() {
            return this == ERROR_DEBUG || this == MESSAGE_DEBUG || this == WARNING_DEBUG;
        }

        public boolean isInfo() {
            return this == ERROR_ALL || this == WARNING_ALL || this == MESSAGE_ALL;
        }
    }
}

