/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.SelectFromListDialog;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import java.util.List;

public class ListMountedFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)((ActionBuilder)new ActionBuilder("FSB List Mounted Filesystems", this.context.plugin().getName()).description("List Mounted Filesystems")).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).toolBarIcon(FSBIcons.LIST_MOUNTED).toolBarGroup("ZZZZ").popupMenuIcon(FSBIcons.LIST_MOUNTED).popupMenuPath(new String[]{"List Mounted Filesystems"}).popupMenuGroup("L").onAction(ac -> {
            FileSystemRef fsRef;
            FSRLRoot fsFSRL = (FSRLRoot)SelectFromListDialog.selectFromList(this.context.fsService().getMountedFilesystems(), (String)"Select filesystem", (String)"Choose filesystem to view", f -> f.toPrettyString());
            if (fsFSRL != null && (fsRef = this.context.fsService().getMountedFilesystem(fsFSRL)) != null) {
                this.context.fsbComponent().getPlugin().createNewFileSystemBrowser(fsRef, true);
            }
        }).build());
    }
}

