/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.dyld.OpcodeTable;
import ghidra.app.util.bin.format.macho.commands.dyld.RebaseOpcode;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RebaseTable
extends OpcodeTable {
    private List<Rebase> rebases = new ArrayList<Rebase>();

    public RebaseTable() {
    }

    public RebaseTable(BinaryReader reader, MachHeader header, long tableSize) throws IOException {
        this();
        int pointerSize = header.getAddressSize();
        long origIndex = reader.getPointerIndex();
        Rebase rebase = new Rebase();
        block11: while (reader.getPointerIndex() < origIndex + tableSize) {
            this.opcodeOffsets.add(reader.getPointerIndex() - origIndex);
            byte b = reader.readNextByte();
            RebaseOpcode opcode = RebaseOpcode.forOpcode(b & 0xF0);
            int immediate = b & 0xF;
            switch (opcode) {
                case REBASE_OPCODE_DONE: {
                    return;
                }
                case REBASE_OPCODE_SET_TYPE_IMM: {
                    rebase.type = immediate;
                    break;
                }
                case REBASE_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    rebase.segmentIndex = immediate;
                    rebase.segmentOffset = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case REBASE_OPCODE_ADD_ADDR_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    rebase.segmentOffset += (long)reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case REBASE_OPCODE_ADD_ADDR_IMM_SCALED: {
                    rebase.segmentOffset += (long)(immediate * pointerSize);
                    break;
                }
                case REBASE_OPCODE_DO_REBASE_IMM_TIMES: {
                    for (int i = 0; i < immediate; ++i) {
                        this.rebases.add(new Rebase(rebase));
                        rebase.segmentOffset += (long)pointerSize;
                    }
                    continue block11;
                }
                case REBASE_OPCODE_DO_REBASE_ULEB_TIMES: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    int count = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    for (int i = 0; i < count; ++i) {
                        this.rebases.add(new Rebase(rebase));
                        rebase.segmentOffset += (long)pointerSize;
                    }
                    continue block11;
                }
                case REBASE_OPCODE_DO_REBASE_ADD_ADDR_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    this.rebases.add(new Rebase(rebase));
                    rebase.segmentOffset += (long)reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case REBASE_OPCODE_DO_REBASE_ULEB_TIMES_SKIPPING_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    int count = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    int skip = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    for (int i = 0; i < count; ++i) {
                        this.rebases.add(new Rebase(rebase));
                        rebase.segmentOffset += (long)(skip + pointerSize);
                    }
                    continue block11;
                }
                default: {
                    Rebase unknownRebase = new Rebase(rebase);
                    unknownRebase.unknownOpcode = Byte.toUnsignedInt(b) & 0xF0;
                    this.rebases.add(unknownRebase);
                    return;
                }
            }
        }
    }

    public List<Rebase> getRebases() {
        return this.rebases;
    }

    public static class Rebase {
        private int type;
        private long segmentOffset;
        private int segmentIndex = -1;
        private Integer unknownOpcode;

        public Rebase() {
        }

        public Rebase(Rebase rebase) {
            this.segmentIndex = rebase.segmentIndex;
            this.segmentOffset = rebase.segmentOffset;
            this.type = rebase.type;
            this.unknownOpcode = rebase.unknownOpcode;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }

        public long getSegmentOffset() {
            return this.segmentOffset;
        }

        public int getType() {
            return this.type;
        }

        public Integer getUnknownOpcode() {
            return this.unknownOpcode;
        }

        public String toString() {
            return "segment: 0x%x, index: 0x%x, kind: %d".formatted(this.segmentIndex, this.segmentOffset, this.type);
        }
    }
}

