/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFLengthValue;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.line.DWARFFile;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineContentType;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineProgramExecutor;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineProgramState;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DWARFLine {
    private DWARFProgram dprog;
    private long startOffset;
    private long endOffset;
    private long length;
    private int intSize;
    private int dwarfVersion;
    private int minimum_instruction_length;
    private int maximum_operations_per_instruction;
    private boolean default_is_stmt;
    private int line_base;
    private int line_range;
    private int opcode_base;
    private int[] standard_opcode_length;
    private List<DWARFFile> directories = new ArrayList<DWARFFile>();
    private List<DWARFFile> files = new ArrayList<DWARFFile>();
    private int address_size;
    private int segment_selector_size;
    private long opcodes_start;

    public static DWARFLine empty() {
        return new DWARFLine();
    }

    public static DWARFLine read(BinaryReader reader, int defaultIntSize, DWARFCompilationUnit cu) throws IOException {
        DWARFLine result = new DWARFLine();
        result.dprog = cu.getProgram();
        result.startOffset = reader.getPointerIndex();
        DWARFLengthValue lengthInfo = DWARFLengthValue.read(reader, defaultIntSize);
        if (lengthInfo == null) {
            throw new DWARFException("Invalid DWARFLine length at 0x%x".formatted(result.startOffset));
        }
        result.length = lengthInfo.length();
        result.intSize = lengthInfo.intSize();
        result.endOffset = reader.getPointerIndex() + lengthInfo.length();
        result.dwarfVersion = reader.readNextUnsignedShort();
        if (result.dwarfVersion < 5) {
            DWARFLine.readV4(result, reader, cu);
        } else {
            DWARFLine.readV5(result, reader, cu);
        }
        return result;
    }

    private static void readV4(DWARFLine result, BinaryReader reader, DWARFCompilationUnit cu) throws IOException, DWARFException {
        DWARFFile file;
        long header_length = reader.readNextUnsignedValue(result.intSize);
        result.opcodes_start = reader.getPointerIndex() + header_length;
        result.minimum_instruction_length = reader.readNextUnsignedByte();
        result.maximum_operations_per_instruction = result.dwarfVersion >= 4 ? reader.readNextUnsignedByte() : 1;
        result.default_is_stmt = reader.readNextUnsignedByte() != 0;
        result.line_base = reader.readNextByte();
        result.line_range = reader.readNextUnsignedByte();
        result.opcode_base = reader.readNextUnsignedByte();
        result.standard_opcode_length = new int[result.opcode_base];
        result.standard_opcode_length[0] = 1;
        for (int i = 1; i < result.opcode_base; ++i) {
            result.standard_opcode_length[i] = reader.readNextUnsignedByte();
        }
        String defaultCompDir = cu.getCompileDirectory();
        if (defaultCompDir == null || defaultCompDir.isBlank()) {
            defaultCompDir = "";
        }
        result.directories.add(new DWARFFile(defaultCompDir));
        String dirName = reader.readNextAsciiString();
        while (dirName.length() != 0) {
            DWARFFile dir = new DWARFFile(dirName);
            dir = DWARFLine.fixupDir(dir, defaultCompDir);
            result.directories.add(dir);
            dirName = reader.readNextAsciiString();
        }
        while ((file = DWARFFile.readV4(reader)) != null) {
            result.files.add(file);
        }
    }

    private static void readV5(DWARFLine result, BinaryReader reader, DWARFCompilationUnit cu) throws IOException, DWARFException {
        result.address_size = reader.readNextUnsignedByte();
        result.segment_selector_size = reader.readNextUnsignedByte();
        long header_length = reader.readNextUnsignedValue(result.intSize);
        result.opcodes_start = reader.getPointerIndex() + header_length;
        result.minimum_instruction_length = reader.readNextUnsignedByte();
        result.maximum_operations_per_instruction = reader.readNextUnsignedByte();
        result.default_is_stmt = reader.readNextUnsignedByte() != 0;
        result.line_base = reader.readNextByte();
        result.line_range = reader.readNextUnsignedByte();
        result.opcode_base = reader.readNextUnsignedByte();
        result.standard_opcode_length = new int[result.opcode_base];
        result.standard_opcode_length[0] = 1;
        for (int i = 1; i < result.opcode_base; ++i) {
            result.standard_opcode_length[i] = reader.readNextUnsignedByte();
        }
        int directory_entry_format_count = reader.readNextUnsignedByte();
        ArrayList<DWARFLineContentType.Def> dirFormatDefs = new ArrayList<DWARFLineContentType.Def>();
        for (int i = 0; i < directory_entry_format_count; ++i) {
            DWARFLineContentType.Def lcntDef = DWARFLineContentType.Def.read(reader);
            dirFormatDefs.add(lcntDef);
        }
        String defaultCompDir = cu.getCompileDirectory();
        if (defaultCompDir == null || defaultCompDir.isBlank()) {
            defaultCompDir = "";
        }
        int directories_count = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        for (int i = 0; i < directories_count; ++i) {
            DWARFFile dir = DWARFFile.readV5(reader, dirFormatDefs, cu);
            dir = DWARFLine.fixupDir(dir, defaultCompDir);
            result.directories.add(dir);
        }
        int filename_entry_format_count = reader.readNextUnsignedByte();
        ArrayList<DWARFLineContentType.Def> fileFormatDefs = new ArrayList<DWARFLineContentType.Def>();
        for (int i = 0; i < filename_entry_format_count; ++i) {
            DWARFLineContentType.Def lcntDef = DWARFLineContentType.Def.read(reader);
            fileFormatDefs.add(lcntDef);
        }
        int file_names_count = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        for (int i = 0; i < file_names_count; ++i) {
            DWARFFile dir = DWARFFile.readV5(reader, fileFormatDefs, cu);
            result.files.add(dir);
        }
    }

    private static DWARFFile fixupDir(DWARFFile dir, String defaultCompDir) {
        if (!defaultCompDir.isEmpty()) {
            if (dir.getName().equals(".")) {
                return dir.withName(defaultCompDir);
            }
            if (!DWARFLine.isAbsolutePath(dir.getName())) {
                return dir.withName(FSUtilities.appendPath(defaultCompDir, dir.getName()));
            }
        }
        return dir;
    }

    private static boolean isAbsolutePath(String s) {
        return s.startsWith("/") || s.startsWith("\\") || s.length() > 3 && s.charAt(1) == ':' && (s.charAt(2) == '/' || s.charAt(2) == '\\');
    }

    private DWARFLine() {
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public DWARFLineProgramExecutor getLineProgramexecutor(DWARFCompilationUnit cu, BinaryReader reader) {
        DWARFLineProgramExecutor lpe = new DWARFLineProgramExecutor(reader.clone(this.opcodes_start), this.endOffset, cu.getPointerSize(), this.opcode_base, this.line_base, this.line_range, this.minimum_instruction_length, this.default_is_stmt);
        return lpe;
    }

    public List<SourceFileAddr> getAllSourceFileAddrInfo(DWARFCompilationUnit cu, BinaryReader reader) throws IOException {
        try (DWARFLineProgramExecutor lpe = this.getLineProgramexecutor(cu, reader);){
            ArrayList<SourceFileAddr> results = new ArrayList<SourceFileAddr>();
            for (DWARFLineProgramState row : lpe.allRows()) {
                String filePath;
                byte[] md5 = null;
                if (cu.getDWARFVersion() >= 5 && row.file < cu.getLine().getNumFiles()) {
                    md5 = cu.getLine().getFile(row.file).getMD5();
                }
                if ((filePath = this.getFilePath(row.file, true)) != null) {
                    results.add(new SourceFileAddr(row.address, filePath, md5, row.line, row.isEndSequence));
                    continue;
                }
                ++cu.getProgram().getImportSummary().badSourceFileCount;
            }
            ArrayList<SourceFileAddr> arrayList = results;
            return arrayList;
        }
    }

    public DWARFFile getDir(int index) throws IOException {
        if (0 <= index && index < this.directories.size()) {
            return this.directories.get(index);
        }
        throw new IOException("Invalid dir index %d for line table at 0x%x: ".formatted(index, this.startOffset));
    }

    public DWARFFile getFile(int index) throws IOException {
        if (this.dwarfVersion < 5) {
            if (0 < index && index <= this.files.size()) {
                return this.files.get(index - 1);
            }
        } else if (this.dwarfVersion >= 5 && 0 <= index && index < this.files.size()) {
            return this.files.get(index);
        }
        throw new IOException("Invalid file index %d for line table at 0x%x: ".formatted(index, this.startOffset));
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public String getFilePath(int index, boolean includePath) {
        try {
            DWARFFile f = this.getFile(index);
            if (!includePath) {
                return f.getName();
            }
            String dir = f.getDirectoryIndex() >= 0 ? this.getDir(f.getDirectoryIndex()).getName() : "";
            return FSUtilities.appendPath(dir, f.getName());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Line Entry");
        buffer.append(" Include Directories: [");
        for (DWARFFile dir : this.directories) {
            buffer.append(dir);
            buffer.append(", ");
        }
        buffer.append("] File Names: [");
        for (DWARFFile file : this.files) {
            buffer.append(file.toString());
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public record SourceFileAddr(long address, String fileName, byte[] md5, int lineNum, boolean isEndSequence) {
    }

    record DirectoryEntryFormat(int contentTypeCode, int formCode) {
        static DirectoryEntryFormat read(BinaryReader reader) throws IOException, IOException {
            int contentTypeCode = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
            int formCode = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
            return new DirectoryEntryFormat(contentTypeCode, formCode);
        }
    }
}

