/*
 * Decompiled with CFR 0.152.
 */
package generic.timer;

import generic.timer.GhidraSwingTimer;
import generic.timer.TimerCallback;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import utility.function.Dummy;

public class ExpiringSwingTimer
extends GhidraSwingTimer {
    private static Set<ExpiringSwingTimer> instances = new HashSet<ExpiringSwingTimer>();
    private long startMs = System.currentTimeMillis();
    private int expireMs;
    private BooleanSupplier isReady;
    private ExpiringTimerCallback expiringTimerCallback = new ExpiringTimerCallback();
    private TimerCallback clientCallback;
    private AtomicBoolean didRun = new AtomicBoolean();

    public static ExpiringSwingTimer runWhen(BooleanSupplier isReady, int expireMs, Runnable runnable) {
        int delay = 250;
        ExpiringSwingTimer timer = new ExpiringSwingTimer(delay, expireMs, isReady, runnable);
        timer.start();
        return timer;
    }

    public static <T> ExpiringSwingTimer get(Supplier<T> supplier, int expireMs, Consumer<T> consumer) {
        int delay = 250;
        BooleanSupplier isReady = () -> {
            Object t = supplier.get();
            if (t == null) {
                return false;
            }
            consumer.accept(t);
            return true;
        };
        Runnable dummy = Dummy.runnable();
        ExpiringSwingTimer timer = new ExpiringSwingTimer(delay, expireMs, isReady, dummy);
        timer.start();
        return timer;
    }

    public ExpiringSwingTimer(int delay, int expireMs, BooleanSupplier isReady, Runnable runnable) {
        super(0, delay, null);
        this.expireMs = expireMs;
        this.isReady = isReady;
        this.clientCallback = () -> runnable.run();
        super.setTimerCallback(this.expiringTimerCallback);
        this.setRepeats(true);
    }

    public boolean didRun() {
        return this.didRun.get();
    }

    @Override
    public void start() {
        if (this.didRun() || this.isExpired()) {
            return;
        }
        instances.add(this);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        instances.remove(this);
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        int elapsed = (int)(now - this.startMs);
        return elapsed > this.expireMs;
    }

    @Override
    public void setTimerCallback(TimerCallback callback) {
        this.clientCallback = Objects.requireNonNull(callback);
    }

    private class ExpiringTimerCallback
    implements TimerCallback {
        private ExpiringTimerCallback() {
        }

        @Override
        public void timerFired() {
            if (ExpiringSwingTimer.this.isReady.getAsBoolean()) {
                ExpiringSwingTimer.this.clientCallback.timerFired();
                ExpiringSwingTimer.this.didRun.set(true);
                ExpiringSwingTimer.this.stop();
                return;
            }
            if (ExpiringSwingTimer.this.isExpired()) {
                ExpiringSwingTimer.this.stop();
            }
        }
    }
}

