/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridBounds;
import ghidra.graph.viewer.layout.GridPoint;
import ghidra.graph.viewer.layout.GridRange;
import ghidra.graph.viewer.layout.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.LazyMap;

public class GridLocationMap<V, E> {
    protected Map<V, GridPoint> vertexPoints = LazyMap.lazyMap(new HashMap(), v -> new GridPoint(0, 0));
    protected Map<E, List<GridPoint>> edgePoints = new HashMap<E, List<GridPoint>>();
    private GridBounds gridBounds = new GridBounds();
    private int rootColumn = 0;

    public GridLocationMap() {
        this.rootColumn = 0;
    }

    public GridLocationMap(V root, int row, int col) {
        this.rootColumn = col;
        this.set(root, new GridPoint(row, col));
    }

    public int getRootColumn() {
        return this.rootColumn;
    }

    public Set<V> vertices() {
        return this.vertexPoints.keySet();
    }

    public Set<E> edges() {
        return this.edgePoints.keySet();
    }

    public Map<V, GridPoint> getVertexPoints() {
        return this.vertexPoints;
    }

    public void setArticulations(E edge, List<GridPoint> articulations) {
        this.edgePoints.put(edge, articulations);
        if (articulations != null) {
            for (GridPoint gridPoint : articulations) {
                this.gridBounds.update(gridPoint);
            }
        }
    }

    public List<GridPoint> getArticulations(E edge) {
        List<GridPoint> list = this.edgePoints.get(edge);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void row(V vertex, int row) {
        GridPoint gridPoint = this.vertexPoints.get(vertex);
        gridPoint.row = row;
        this.gridBounds.update(gridPoint);
    }

    public void col(V vertex, int col) {
        GridPoint gridPoint = this.vertexPoints.get(vertex);
        gridPoint.col = col;
        this.gridBounds.update(gridPoint);
    }

    public void set(V v, int row, int col) {
        this.set(v, new GridPoint(row, col));
    }

    public void set(V v, GridPoint gridPoint) {
        this.vertexPoints.put((GridPoint)v, gridPoint);
        this.gridBounds.update(gridPoint);
    }

    public int row(V vertex) {
        GridPoint gridPoint = this.vertexPoints.get(vertex);
        if (gridPoint != null) {
            return gridPoint.row;
        }
        return 0;
    }

    public int col(V vertex) {
        GridPoint gridPoint = this.vertexPoints.get(vertex);
        if (gridPoint != null) {
            return gridPoint.col;
        }
        return 0;
    }

    public GridPoint gridPoint(V vertex) {
        return this.vertexPoints.get(vertex);
    }

    public List<Row<V>> rows() {
        Map<Integer, Row<V>> rowsByIndex = this.rowsMap();
        ArrayList<Row<V>> rows = new ArrayList<Row<V>>(rowsByIndex.values());
        rows.sort((r1, r2) -> r1.index - r2.index);
        return rows;
    }

    public Map<Integer, Row<V>> rowsMap() {
        LazyMap rowsByIndex = LazyMap.lazyMap(new HashMap(), r -> new Row((int)r));
        Set<Map.Entry<V, GridPoint>> entrySet = this.vertexPoints.entrySet();
        for (Map.Entry<V, GridPoint> entry : entrySet) {
            V v = entry.getKey();
            GridPoint gridPoint = entry.getValue();
            int rowIndex = gridPoint.row;
            Row row = (Row)rowsByIndex.get(rowIndex);
            row.setColumn(v, gridPoint.col);
        }
        return rowsByIndex;
    }

    public Map<Integer, Column<V>> columnsMap() {
        LazyMap columnsMap = LazyMap.lazyMap(new HashMap(), c -> new Column((int)c));
        Set<Map.Entry<V, GridPoint>> entrySet = this.vertexPoints.entrySet();
        for (Map.Entry<V, GridPoint> entry : entrySet) {
            V v = entry.getKey();
            GridPoint gridPoint = entry.getValue();
            int colIndex = gridPoint.col;
            Column col = (Column)columnsMap.get(colIndex);
            col.setRow(v, gridPoint.row);
        }
        return columnsMap;
    }

    public void centerRows() {
        this.zeroAlignGrid();
        GridRange[] vertexColumnRanges = this.getVertexColumnRanges();
        int maxRowWidth = this.getMaxRowWidth(vertexColumnRanges);
        for (GridPoint p : this.allPoints()) {
            GridRange range = vertexColumnRanges[p.row];
            int extraSpace = maxRowWidth - range.width();
            int shift = extraSpace / 2 - range.min;
            p.col += shift;
        }
    }

    private int getMaxRowWidth(GridRange[] vertexColumnRanges) {
        int maxWidth = 0;
        for (GridRange gridRange : vertexColumnRanges) {
            maxWidth = Math.max(maxWidth, gridRange.width());
        }
        return maxWidth;
    }

    public void zeroAlignGrid() {
        this.shift(-this.gridBounds.minRow(), -this.gridBounds.minCol());
    }

    public void dispose() {
        this.vertexPoints.clear();
        this.edgePoints.clear();
    }

    public void shift(int rowShift, int colShift) {
        if (rowShift == 0 && colShift == 0) {
            return;
        }
        for (GridPoint p : this.allPoints()) {
            p.row += rowShift;
            p.col += colShift;
        }
        this.rootColumn += colShift;
        this.gridBounds.shift(rowShift, colShift);
    }

    public int height() {
        return this.gridBounds.maxRow() + 1;
    }

    public int width() {
        return this.gridBounds.maxCol() + 1;
    }

    public GridRange[] getVertexColumnRanges() {
        if (this.gridBounds.minRow() < 0) {
            throw new IllegalStateException("getVertexColumnRanges not defined for grids with negative rows!");
        }
        GridRange[] rowRanges = new GridRange[this.height()];
        for (int i = 0; i < rowRanges.length; ++i) {
            rowRanges[i] = new GridRange();
        }
        for (GridPoint p : this.vertexPoints.values()) {
            rowRanges[p.row].add(p.col);
        }
        return rowRanges;
    }

    public boolean containsVertex(V v) {
        return this.vertexPoints.containsKey(v);
    }

    public boolean containsEdge(E e) {
        return this.edgePoints.containsKey(e);
    }

    public void add(GridLocationMap<V, E> other, int rowShift, int colShift) {
        for (Map.Entry<V, GridPoint> entry : other.vertexPoints.entrySet()) {
            V v = entry.getKey();
            GridPoint point = entry.getValue();
            this.set(v, new GridPoint(point.row + rowShift, point.col + colShift));
        }
        for (Map.Entry<Object, Object> entry : other.edgePoints.entrySet()) {
            Object e = entry.getKey();
            List points = (List)entry.getValue();
            ArrayList<GridPoint> shiftedPoints = new ArrayList<GridPoint>(points.size());
            for (GridPoint point : points) {
                shiftedPoints.add(new GridPoint(point.row + rowShift, point.col + colShift));
            }
            this.setArticulations(e, shiftedPoints);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n\tvertex points=" + String.valueOf(this.vertexPoints) + "\n\tedge points=" + String.valueOf(this.edgePoints) + "]";
    }

    public String toStringGrid() {
        int minRow = this.gridBounds.minRow();
        int minCol = this.gridBounds.minCol();
        if (minRow > 10 || minCol > 10) {
            GridLocationMap<V, E> copy = this.copy();
            copy.zeroAlignGrid();
            return "grid upper left (row,col) = (" + minRow + ", " + minCol + ")\n" + copy.toStringGrid();
        }
        String[][] vGrid = new String[this.height()][this.width()];
        for (Map.Entry<V, GridPoint> entry : this.vertexPoints.entrySet()) {
            V v = entry.getKey();
            GridPoint p = entry.getValue();
            vGrid[p.row][p.col] = this.normalizeVertexName(v.toString());
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append("\n");
        for (int row = 0; row < vGrid.length; ++row) {
            for (int col = 0; col < vGrid[row].length; ++col) {
                String name = vGrid[row][col];
                name = name == null ? ".       " : name;
                buffy.append(name);
                buffy.append("");
            }
            buffy.append("\n");
        }
        return buffy.toString();
    }

    private GridLocationMap<V, E> copy() {
        GridLocationMap<V, E> map = new GridLocationMap<V, E>();
        map.rootColumn = this.rootColumn;
        Set<Map.Entry<V, GridPoint>> entries = this.vertexPoints.entrySet();
        for (Map.Entry<V, GridPoint> entry : entries) {
            map.set(entry.getKey(), new GridPoint(entry.getValue()));
        }
        Set<Map.Entry<E, List<GridPoint>>> edgeEntries = this.edgePoints.entrySet();
        for (Map.Entry<E, List<GridPoint>> entry : edgeEntries) {
            List<GridPoint> points = entry.getValue();
            ArrayList<GridPoint> copy = new ArrayList<GridPoint>(points.size());
            points.forEach(p -> copy.add(new GridPoint((GridPoint)p)));
            map.setArticulations(entry.getKey(), copy);
        }
        return map;
    }

    private String normalizeVertexName(String name) {
        if (name.length() > 8) {
            return name.substring(0, 8);
        }
        return name + "        ".substring(name.length());
    }

    private Iterable<GridPoint> allPoints() {
        Stream<GridPoint> vPoints = this.vertexPoints.values().stream();
        Stream ePoints = this.edgePoints.values().stream().flatMap(l -> l.stream());
        Stream<GridPoint> streams = Stream.concat(vPoints, ePoints);
        return () -> streams.iterator();
    }

    public boolean containsPoint(GridPoint p) {
        return this.gridBounds.contains(p);
    }
}

