/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class AddressMapDBAdapterV0
extends AddressMapDBAdapter {
    final Schema SCHEMA = new Schema(0, "Key", new Field[]{StringField.INSTANCE, IntField.INSTANCE, ShortField.INSTANCE}, new String[]{"Space Name", "Segment", "Not Used"});
    final int SPACE_NAME_COL = 0;
    final int SEGMENT_COL = 1;
    private Table table;
    private DBHandle handle;
    private AddressFactory factory;
    private Address[] addresses;

    AddressMapDBAdapterV0(DBHandle handle, AddressFactory factory) throws VersionException, IOException {
        this.handle = handle;
        this.factory = factory;
        this.table = handle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException(true);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
        this.readAddresses();
    }

    private void readAddresses() throws IOException {
        this.addresses = new Address[this.table.getRecordCount()];
        RecordIterator it = this.table.iterator();
        int deletedID = 1;
        while (it.hasNext()) {
            Address addr;
            DBRecord rec = it.next();
            String spaceName = rec.getString(0);
            int segment = rec.getIntValue(1);
            AddressSpace space = this.factory.getAddressSpace(spaceName);
            if (space == null) {
                GenericAddressSpace sp = new GenericAddressSpace("Deleted_" + spaceName, 32, 14, deletedID++);
                sp.setShowSpaceName(true);
                space = sp;
            }
            if (space.getSize() <= 32) {
                segment = 0;
            }
            this.addresses[(int)rec.getKey()] = addr = space.getAddressInThisSpaceOnly((long)segment << 32);
        }
    }

    @Override
    Address[] getBaseAddresses(boolean forceRead) throws IOException {
        if (forceRead || this.table.getRecordCount() != this.addresses.length) {
            this.readAddresses();
        }
        return this.addresses;
    }

    @Override
    List<AddressMapDBAdapter.AddressMapEntry> getEntries() throws IOException {
        ArrayList<AddressMapDBAdapter.AddressMapEntry> list = new ArrayList<AddressMapDBAdapter.AddressMapEntry>();
        for (DBRecord rec : this.table) {
            String spaceName = rec.getString(0);
            boolean deleted = this.factory.getAddressSpace(spaceName) == null;
            list.add(new AddressMapDBAdapter.AddressMapEntry((int)rec.getKey(), spaceName, rec.getIntValue(1), deleted));
        }
        return list;
    }

    @Override
    void setEntries(List<AddressMapDBAdapter.AddressMapEntry> entries) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Address[] addBaseAddress(Address addr, long normalizedOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    void clearAll() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void setAddressFactory(AddressFactory addrFactory) {
        this.factory = addrFactory;
    }

    @Override
    void renameOverlaySpace(String oldName, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteOverlaySpace(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable() throws IOException {
        this.handle.deleteTable(TABLE_NAME);
    }
}

