/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.secret.DBSValueEncryptor;
import org.jkiss.utils.IOUtils;

public class DefaultValueEncryptor
implements DBSValueEncryptor {
    public static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    public static final String KEY_ALGORITHM = "AES";
    private final SecretKey secretKey;
    private final Cipher cipher;

    public DefaultValueEncryptor(SecretKey secretKey) {
        this.secretKey = secretKey;
        try {
            this.cipher = Cipher.getInstance(CIPHER_NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException("Internal error during encrypted init", e);
        }
    }

    public static SecretKey makeSecretKeyFromPassword(String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] passBytes = Arrays.copyOf(bytes, 16);
        return new SecretKeySpec(passBytes, KEY_ALGORITHM);
    }

    @Override
    @NotNull
    public byte[] encryptValue(@NotNull byte[] value) throws DBException {
        try {
            this.cipher.init(1, this.secretKey);
            byte[] iv = this.cipher.getIV();
            ByteArrayOutputStream resultBuffer = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var5_7 = null;
            try (CipherOutputStream cipherOut = new CipherOutputStream(resultBuffer, this.cipher);){
                resultBuffer.write(iv);
                cipherOut.write(value);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return resultBuffer.toByteArray();
        }
        catch (Exception e) {
            throw new DBException("Error encrypting value", e);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public byte[] decryptValue(@NotNull byte[] value) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(value);){
                byte[] byArray;
                CipherInputStream cipherIn;
                Throwable throwable2;
                block21: {
                    byte[] fileIv = new byte[16];
                    byteStream.read(fileIv);
                    this.cipher.init(2, (Key)this.secretKey, new IvParameterSpec(fileIv));
                    throwable2 = null;
                    Object var7_11 = null;
                    cipherIn = new CipherInputStream(byteStream, this.cipher);
                    ByteArrayOutputStream resultBuffer = new ByteArrayOutputStream();
                    IOUtils.copyStream((InputStream)cipherIn, (OutputStream)resultBuffer);
                    byArray = resultBuffer.toByteArray();
                    if (cipherIn == null) break block21;
                    cipherIn.close();
                }
                return byArray;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (cipherIn != null) {
                                cipherIn.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Error decrypting value", e);
        }
    }
}

