/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class EditBootstrapQueriesDialog
extends HelpEnabledDialog {
    private static final String DIALOG_ID = "DBeaver.EditBootstrapQueriesDialog";
    private final DataSourceDescriptor dataSourceDescriptor;
    private List<String> queries;
    private boolean ignoreErrors;
    private Table queriesTable;
    private Button ignoreErrorButton;

    public EditBootstrapQueriesDialog(Shell shell, DataSourceDescriptor dataSourceDescriptor, Collection<String> queries, boolean ignoreErrors) {
        super(shell, "object-filters");
        this.dataSourceDescriptor = dataSourceDescriptor;
        this.queries = new ArrayList<String>(queries);
        this.ignoreErrors = ignoreErrors;
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        this.getShell().setText(CoreMessages.dialog_connection_edit_wizard_general_bootstrap_query_title);
        Composite composite = super.createDialogArea(parent);
        Composite group = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.dialog_connection_edit_wizard_general_bootstrap_query_sql_label, (int)2, (int)1808);
        this.queriesTable = new Table(group, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.queriesTable.setLayoutData((Object)gd);
        this.queriesTable.setLinesVisible(true);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.queriesTable, (int)16384, (String)"SQL");
        valueColumn.setWidth(300);
        for (String value : this.queries) {
            new TableItem(this.queriesTable, 16384).setText(value);
        }
        final CustomTableEditor tableEditor = new CustomTableEditor(this.queriesTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor = new Text((Composite)table, 2048);
                editor.setText(item.getText());
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(((Text)control).getText());
            }
        };
        Composite buttonsGroup = UIUtils.createPlaceholder((Composite)group, (int)1, (int)5);
        buttonsGroup.setLayoutData((Object)new GridData(2));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(UIMessages.button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableEditor.closeEditor();
                String sql = EditTextDialog.editText((Shell)EditBootstrapQueriesDialog.this.getShell(), (String)CoreMessages.dialog_connection_edit_wizard_general_bootstrap_query_sql_title, (String)"");
                if (sql != null) {
                    TableItem newItem = new TableItem(EditBootstrapQueriesDialog.this.queriesTable, 16384);
                    newItem.setText(sql);
                    EditBootstrapQueriesDialog.this.queriesTable.setSelection(newItem);
                    UIUtils.packColumns((Table)EditBootstrapQueriesDialog.this.queriesTable, (boolean)true);
                }
            }
        });
        final Button removeButton = new Button(buttonsGroup, 8);
        removeButton.setText(UIMessages.button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = EditBootstrapQueriesDialog.this.queriesTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    tableEditor.closeEditor();
                    EditBootstrapQueriesDialog.this.queriesTable.remove(selectionIndex);
                    removeButton.setEnabled(EditBootstrapQueriesDialog.this.queriesTable.getSelectionIndex() >= 0);
                }
            }
        });
        removeButton.setEnabled(false);
        this.queriesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = EditBootstrapQueriesDialog.this.queriesTable.getSelectionIndex();
                removeButton.setEnabled(selectionIndex >= 0);
            }
        });
        this.queriesTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int sbWidth = 0;
                if (EditBootstrapQueriesDialog.this.queriesTable.getVerticalBar() != null) {
                    sbWidth = EditBootstrapQueriesDialog.this.queriesTable.getVerticalBar().getSize().x;
                }
                EditBootstrapQueriesDialog.this.queriesTable.getColumn(0).setWidth(EditBootstrapQueriesDialog.this.queriesTable.getSize().x - EditBootstrapQueriesDialog.this.queriesTable.getBorderWidth() * 2 - sbWidth);
            }
        });
        this.ignoreErrorButton = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.dialog_connection_edit_wizard_general_bootstrap_query_ignore_error_lable, (boolean)this.ignoreErrors);
        VariablesHintLabel variablesHintLabel = new VariablesHintLabel(composite, CoreMessages.dialog_connection_edit_wizard_shell_cmd_variables_hint_label, CoreMessages.dialog_connection_edit_wizard_shell_cmd_variables_hint_title, DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES);
        if (this.dataSourceDescriptor != null) {
            variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver((DBPDataSourceContainer)this.dataSourceDescriptor, this.dataSourceDescriptor.getConnectionConfiguration()));
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.queriesTable, (boolean)true));
        return composite;
    }

    private List<String> collectValues(Table table) {
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String value = item.getText().trim();
            if (!value.isEmpty() && !value.equals("%")) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)DBeaverActivator.getInstance().getDialogSettings(), (String)DIALOG_ID);
    }

    protected void okPressed() {
        this.ignoreErrors = this.ignoreErrorButton.getSelection();
        this.queries = this.collectValues(this.queriesTable);
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public List<String> getQueries() {
        return this.queries;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }
}

