/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.ermodel.associations.ColumnMatchKeys;
import schemacrawler.ermodel.associations.ImplicitColumnReference;
import schemacrawler.ermodel.associations.TableColumns;
import schemacrawler.ermodel.associations.TableMatchKeys;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import us.fatehi.utility.string.StringFormat;

public final class ImplicitAssociationsAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(ImplicitAssociationsAnalyzer.class.getName());
    private final TableMatchKeys tableMatchKeys;
    private final Predicate<ColumnReference> implicitAssociationRule;

    public ImplicitAssociationsAnalyzer(TableMatchKeys matchKeys, Predicate<ColumnReference> implicitAssociationRule) {
        this.tableMatchKeys = Objects.requireNonNull(matchKeys, "No table match keys provided");
        this.implicitAssociationRule = Objects.requireNonNull(implicitAssociationRule, "No rules provided");
    }

    public Collection<ImplicitColumnReference> analyzeTables() {
        if (this.tableMatchKeys.getTables().size() < 2) {
            return Collections.emptySet();
        }
        LOGGER.log(Level.INFO, "Finding implicit associations");
        ArrayList<ImplicitColumnReference> implicitAssociations = new ArrayList<ImplicitColumnReference>();
        List<Table> tables = this.tableMatchKeys.getTables();
        ColumnMatchKeys columnMatchKeys = new ColumnMatchKeys(tables);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, new StringFormat("Column match keys <%s>", columnMatchKeys));
            LOGGER.log(Level.FINER, new StringFormat("Table match keys <%s>", this.tableMatchKeys));
        }
        for (Table table : tables) {
            TableColumns pkTableColumns = new TableColumns(table);
            LOGGER.log(Level.FINER, new StringFormat("Table candidate keys <%s>", pkTableColumns));
            for (Column pkColumn : pkTableColumns.getCandidateKeys()) {
                HashSet<String> fkColumnMatchKeys = new HashSet<String>();
                if (pkColumn.isPartOfPrimaryKey() && this.tableMatchKeys.containsKey(table)) {
                    fkColumnMatchKeys.addAll(this.tableMatchKeys.get(table));
                }
                if (columnMatchKeys.containsKey(pkColumn)) {
                    fkColumnMatchKeys.addAll(columnMatchKeys.get(pkColumn));
                }
                HashSet<Column> fkColumns = new HashSet<Column>();
                for (String fkColumnMatchKey : fkColumnMatchKeys) {
                    if (!columnMatchKeys.containsKey(fkColumnMatchKey)) continue;
                    fkColumns.addAll(columnMatchKeys.get(fkColumnMatchKey));
                }
                for (Column fkColumn : fkColumns) {
                    ImplicitColumnReference proposedAssociation;
                    if (fkColumn.isPartOfForeignKey() || !(proposedAssociation = new ImplicitColumnReference(fkColumn, pkColumn)).isValid() || !this.implicitAssociationRule.test(proposedAssociation)) continue;
                    LOGGER.log(Level.FINE, new StringFormat("Found implicit association <%s>", proposedAssociation));
                    implicitAssociations.add(proposedAssociation);
                }
            }
        }
        Collections.sort(implicitAssociations);
        return implicitAssociations;
    }
}

