/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.List;
import java.util.Objects;
import schemacrawler.ermodel.associations.ImplicitAssociationsUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import us.fatehi.utility.Multimap;
import us.fatehi.utility.Utility;

final class ColumnMatchKeys {
    private final Multimap<String, Column> columnsForMatchKey;
    private final Multimap<Column, String> matchKeysForColumn;

    ColumnMatchKeys(List<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        this.columnsForMatchKey = new Multimap();
        this.matchKeysForColumn = new Multimap();
        for (Table table : tables) {
            this.mapColumnNameMatches(table);
        }
    }

    public boolean containsKey(Column column) {
        return this.matchKeysForColumn.containsKey(column);
    }

    public boolean containsKey(String columnKey) {
        return this.columnsForMatchKey.containsKey(columnKey);
    }

    public List<String> get(Column column) {
        return (List)this.matchKeysForColumn.get(column);
    }

    public List<Column> get(String matchKey) {
        return (List)this.columnsForMatchKey.get(matchKey);
    }

    public String toString() {
        return this.columnsForMatchKey.toString();
    }

    private void mapColumnNameMatches(Table table) {
        for (Column column : table.getColumns()) {
            String columnName = column.getName().toLowerCase();
            String matchColumnName = ImplicitAssociationsUtility.ID_PATTERN.matcher(columnName).replaceAll("");
            if (Utility.isBlank(matchColumnName)) continue;
            this.columnsForMatchKey.add(matchColumnName, column);
            this.matchKeysForColumn.add(column, matchColumnName);
        }
    }
}

