/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.VP8Frame;

public class VP8Decoder {
    private int[][][][] coefProbs = Globals.getDefaultCoefProbs();
    VP8Frame f;
    private int frameCount = 0;

    public void decodeFrame(ImageInputStream stream) throws IOException {
        boolean debug = false;
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.f = new VP8Frame(stream, this.coefProbs);
        if (this.f.decodeFrame(false)) {
            // empty if block
        }
        ++this.frameCount;
    }

    public VP8Frame getFrame() {
        return this.f;
    }

    public int getHeight() {
        return this.f.getHeight();
    }

    public int getWidth() {
        return this.f.getWidth();
    }

    public void writePGMFile(String fileName, VP8Frame frame) {
        try {
            int x;
            int y;
            int[][] yData = frame.getYBuffer();
            int[][] uData = frame.getUBuffer();
            int[][] vData = frame.getVBuffer();
            int outStride = this.f.getWidth() + 1 & 0xFFFFFFFE;
            int uvHeight = (this.f.getHeight() + 1) / 2;
            FileOutputStream out = new FileOutputStream(fileName);
            out.write(80);
            out.write(53);
            out.write(10);
            out.write(("" + outStride).getBytes());
            out.write(32);
            out.write(("" + (this.f.getHeight() + uvHeight)).getBytes());
            out.write(10);
            out.write("255".getBytes());
            out.write(10);
            for (y = 0; y < this.f.getHeight(); ++y) {
                for (x = 0; x < this.f.getWidth(); ++x) {
                    out.write(yData[x][y]);
                }
                if ((this.f.getWidth() & 1) != 1) continue;
                out.write(0);
            }
            for (y = 0; y < (this.f.getHeight() + 1) / 2; ++y) {
                for (x = 0; x < (this.f.getWidth() + 1) / 2; ++x) {
                    out.write(uData[x][y]);
                }
                for (x = 0; x < (this.f.getWidth() + 1) / 2; ++x) {
                    out.write(vData[x][y]);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logme.error(e);
        }
        catch (IOException e) {
            Logme.error(e);
        }
    }

    public void writeYV12File(String fileName, VP8Frame frame) {
        try {
            int x;
            int y;
            int[][] yData = frame.getYBuffer();
            int[][] uData = frame.getUBuffer();
            int[][] vData = frame.getVBuffer();
            FileOutputStream out = new FileOutputStream(fileName);
            out.write(80);
            out.write(53);
            out.write(10);
            out.write(("" + this.f.getWidth()).getBytes());
            out.write(32);
            out.write(("" + this.f.getHeight() * 3 / 2).getBytes());
            out.write(10);
            out.write("255".getBytes());
            out.write(10);
            for (y = 0; y < this.f.getHeight(); ++y) {
                for (x = 0; x < this.f.getWidth(); ++x) {
                    out.write(yData[x][y]);
                }
            }
            for (y = 0; y < (this.f.getHeight() + 1) / 2; ++y) {
                for (x = 0; x < (this.f.getWidth() + 1) / 2; ++x) {
                    out.write(uData[x][y]);
                }
            }
            for (y = 0; y < (this.f.getHeight() + 1) / 2; ++y) {
                for (x = 0; x < (this.f.getWidth() + 1) / 2; ++x) {
                    out.write(vData[x][y]);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logme.error(e);
        }
        catch (IOException e) {
            Logme.error(e);
        }
    }
}

