/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.input.execute.agent.AgentInput;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.InputType;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;

public abstract class ModelProvider {
    public abstract Connector createConnector(String var1, Map<String, String> var2, Map<String, String> var3);

    public abstract MLRegisterModelInput createModelInput(String var1, Connector var2, Map<String, String> var3);

    public abstract String getLLMInterface();

    public abstract Map<String, String> mapTextInput(String var1, MLAgentType var2);

    public abstract Map<String, String> mapContentBlocks(List<ContentBlock> var1, MLAgentType var2);

    public abstract Map<String, String> mapMessages(List<Message> var1, MLAgentType var2);

    public Map<String, String> mapAgentInput(AgentInput agentInput, MLAgentType type) {
        if (agentInput == null || agentInput.getInput() == null) {
            throw new IllegalArgumentException("AgentInput and its input field cannot be null");
        }
        InputType inputType = agentInput.getInputType();
        return switch (inputType) {
            case InputType.TEXT -> this.mapTextInput((String)agentInput.getInput(), type);
            case InputType.CONTENT_BLOCKS -> {
                List blocks = (List)agentInput.getInput();
                yield this.mapContentBlocks(blocks, type);
            }
            case InputType.MESSAGES -> {
                List messages = (List)agentInput.getInput();
                yield this.mapMessages(messages, type);
            }
            default -> throw new IllegalArgumentException("Unsupported input type: " + String.valueOf((Object)inputType));
        };
    }
}

