/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.contextmanager;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextManagerUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagerUtils.class);

    public static int findSafePoint(List<String> interactions, int targetPoint, boolean isStartPoint) {
        if (isStartPoint && targetPoint <= 0) {
            return 0;
        }
        if (!isStartPoint && targetPoint >= interactions.size()) {
            return targetPoint;
        }
        if (isStartPoint && targetPoint >= interactions.size()) {
            return interactions.size();
        }
        int safePoint = targetPoint;
        while (safePoint < interactions.size()) {
            try {
                String message = interactions.get(safePoint);
                boolean hasToolResult = message.contains("toolResult") || message.contains("tool_call_id");
                boolean hasToolUse = message.contains("toolUse");
                boolean nextHasToolResult = false;
                if (safePoint + 1 < interactions.size()) {
                    String nextMessage = interactions.get(safePoint + 1);
                    boolean bl = nextHasToolResult = nextMessage.contains("toolResult") || nextMessage.contains("tool_call_id");
                }
                if (!hasToolResult && (!hasToolUse || safePoint + 1 >= interactions.size() || nextHasToolResult)) break;
                ++safePoint;
            }
            catch (Exception e) {
                log.warn("Error checking message at index {}: {}", (Object)safePoint, (Object)e.getMessage());
                ++safePoint;
            }
        }
        return safePoint;
    }
}

