/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.ScriptCacheStats;
import org.opensearch.script.ScriptContextStats;

@PublicApi(since="1.0.0")
public class ScriptStats
implements Writeable,
ToXContentFragment {
    private final List<ScriptContextStats> contextStats;
    private final long compilations;
    private final long cacheEvictions;
    private final long compilationLimitTriggered;

    private ScriptStats(Builder builder) {
        this.contextStats = builder.contextStats;
        this.compilations = builder.compilations;
        this.cacheEvictions = builder.cacheEvictions;
        this.compilationLimitTriggered = builder.compilationLimitTriggered;
    }

    @Deprecated
    public ScriptStats(List<ScriptContextStats> contextStats) {
        ArrayList<ScriptContextStats> ctxStats = new ArrayList<ScriptContextStats>(contextStats.size());
        ctxStats.addAll(contextStats);
        ctxStats.sort(ScriptContextStats::compareTo);
        this.contextStats = Collections.unmodifiableList(ctxStats);
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptContextStats stats : contextStats) {
            compilations += stats.getCompilations();
            cacheEvictions += stats.getCacheEvictions();
            compilationLimitTriggered += stats.getCompilationLimitTriggered();
        }
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
    }

    @Deprecated
    public ScriptStats(long compilations, long cacheEvictions, long compilationLimitTriggered) {
        this.contextStats = Collections.emptyList();
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
    }

    @Deprecated
    public ScriptStats(ScriptContextStats context) {
        this(context.getCompilations(), context.getCacheEvictions(), context.getCompilationLimitTriggered());
    }

    public ScriptStats(StreamInput in) throws IOException {
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
        this.compilationLimitTriggered = in.readVLong();
        this.contextStats = in.readList(ScriptContextStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        out.writeVLong(this.compilationLimitTriggered);
        out.writeList(this.contextStats);
    }

    public static ScriptStats aggregate(List<ScriptContextStats> contextStats) {
        ArrayList<ScriptContextStats> ctxStats = new ArrayList<ScriptContextStats>(contextStats);
        ctxStats.sort(ScriptContextStats::compareTo);
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptContextStats stat : ctxStats) {
            compilations += stat.getCompilations();
            cacheEvictions += stat.getCacheEvictions();
            compilationLimitTriggered += stat.getCompilationLimitTriggered();
        }
        return new Builder().contextStats(Collections.unmodifiableList(new ArrayList<ScriptContextStats>(ctxStats))).compilations(compilations).cacheEvictions(cacheEvictions).compilationLimitTriggered(compilationLimitTriggered).build();
    }

    public List<ScriptContextStats> getContextStats() {
        return this.contextStats;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public ScriptCacheStats toScriptCacheStats() {
        if (this.contextStats.isEmpty()) {
            return new ScriptCacheStats(this);
        }
        HashMap<String, ScriptStats> contexts = new HashMap<String, ScriptStats>(this.contextStats.size());
        for (ScriptContextStats contextStats : this.contextStats) {
            contexts.put(contextStats.getContext(), new Builder().compilations(contextStats.getCompilations()).cacheEvictions(contextStats.getCacheEvictions()).compilationLimitTriggered(contextStats.getCompilationLimitTriggered()).build());
        }
        return new ScriptCacheStats(contexts);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("compilations", this.compilations);
        builder.field("cache_evictions", this.cacheEvictions);
        builder.field("compilation_limit_triggered", this.compilationLimitTriggered);
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private List<ScriptContextStats> contextStats = Collections.emptyList();
        private long compilations = 0L;
        private long cacheEvictions = 0L;
        private long compilationLimitTriggered = 0L;

        public Builder contextStats(List<ScriptContextStats> contextStats) {
            this.contextStats = contextStats;
            return this;
        }

        public Builder compilations(long compilations) {
            this.compilations = compilations;
            return this;
        }

        public Builder cacheEvictions(long cacheEvictions) {
            this.cacheEvictions = cacheEvictions;
            return this;
        }

        public Builder compilationLimitTriggered(long compilationLimitTriggered) {
            this.compilationLimitTriggered = compilationLimitTriggered;
            return this;
        }

        public ScriptStats build() {
            return new ScriptStats(this);
        }
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String CONTEXTS = "contexts";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";

        Fields() {
        }
    }
}

