/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.internal.TypeDetailsSwitch;
import org.hibernate.models.spi.TypeDetails;

public class TypeDetailsSwitcher {
    public static <T> T switchType(TypeDetails type, TypeDetailsSwitch<T> typeSwitch) {
        switch (type.getTypeKind()) {
            case CLASS: {
                return typeSwitch.caseClass(type.asClassType());
            }
            case PRIMITIVE: {
                return typeSwitch.casePrimitive(type.asPrimitiveType());
            }
            case VOID: {
                return typeSwitch.caseVoid(type.asVoidType());
            }
            case ARRAY: {
                return typeSwitch.caseArrayType(type.asArrayType());
            }
            case PARAMETERIZED_TYPE: {
                return typeSwitch.caseParameterizedType(type.asParameterizedType());
            }
            case WILDCARD_TYPE: {
                return typeSwitch.caseWildcardType(type.asWildcardType());
            }
            case TYPE_VARIABLE: {
                return typeSwitch.caseTypeVariable(type.asTypeVariable());
            }
            case TYPE_VARIABLE_REFERENCE: {
                return typeSwitch.caseTypeVariableReference(type.asTypeVariableReference());
            }
        }
        return typeSwitch.defaultCase(type);
    }
}

