/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.function.Consumer;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmExpressionHelper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.BindableType;

public class SqmJpaCriteriaParameterWrapper<T>
extends AbstractSqmExpression<T>
implements SqmParameter<T> {
    private final JpaCriteriaParameter<T> jpaCriteriaParameter;
    private final int criteriaParameterId;
    private final int unnamedParameterId;

    public SqmJpaCriteriaParameterWrapper(BindableType<T> type, JpaCriteriaParameter<T> jpaCriteriaParameter, int criteriaParameterId, int unnamedParameterId, NodeBuilder criteriaBuilder) {
        super(SqmExpressionHelper.toSqmType(type, criteriaBuilder), criteriaBuilder);
        this.jpaCriteriaParameter = jpaCriteriaParameter;
        this.criteriaParameterId = criteriaParameterId;
        this.unnamedParameterId = unnamedParameterId;
    }

    @Override
    public SqmJpaCriteriaParameterWrapper<T> copy(SqmCopyContext context) {
        SqmJpaCriteriaParameterWrapper existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmJpaCriteriaParameterWrapper(this.getNodeType(), this.jpaCriteriaParameter.copy(context), this.criteriaParameterId, this.unnamedParameterId, this.nodeBuilder()));
    }

    @Override
    public String getName() {
        return this.jpaCriteriaParameter.getName();
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    public JpaCriteriaParameter<T> getJpaCriteriaParameter() {
        return this.jpaCriteriaParameter;
    }

    public int getCriteriaParameterId() {
        return this.criteriaParameterId;
    }

    public int getUnnamedParameterId() {
        return this.unnamedParameterId;
    }

    public Class<T> getParameterType() {
        return this.jpaCriteriaParameter.getParameterType();
    }

    @Override
    public boolean allowMultiValuedBinding() {
        return this.jpaCriteriaParameter.allowsMultiValuedBinding();
    }

    @Override
    public BindableType<T> getAnticipatedType() {
        return this.getNodeType();
    }

    @Override
    public SqmParameter<T> copy() {
        return new SqmJpaCriteriaParameterWrapper(this.getNodeType(), this.jpaCriteriaParameter, this.criteriaParameterId, this.unnamedParameterId, this.nodeBuilder());
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        throw new UnsupportedOperationException("Direct SemanticQueryWalker visitation of a SqmJpaCriteriaParameterWrapper is not supported. Visitation for a criteria parameter should be handled during SemanticQueryWalker#visitJpaCriteriaParameter. This wrapper is intended only for representing unique SQM parameter nodes for each criteria parameter in the SQM tree as part of the QueryParameter -> SqmParameter -> JdbcParameter transformation. Each occurrence requires a unique SqmParameter to make sure we ultimately get the complete set of JdbcParameter references.");
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> jpaSelectionConsumer) {
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.jpaCriteriaParameter.appendHqlString(hql, context);
    }

    public final boolean equals(Object o) {
        return o instanceof SqmJpaCriteriaParameterWrapper && this.criteriaParameterId == ((SqmJpaCriteriaParameterWrapper)o).criteriaParameterId;
    }

    public int hashCode() {
        return this.criteriaParameterId;
    }

    @Override
    public int compareTo(SqmParameter<T> anotherParameter) {
        int n;
        if (anotherParameter instanceof SqmJpaCriteriaParameterWrapper) {
            SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)anotherParameter;
            n = Integer.compare(this.criteriaParameterId, wrapper.getCriteriaParameterId());
        } else {
            n = 1;
        }
        return n;
    }
}

