/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.SB;

public final class Rgb16 {
    public int r;
    public int g;
    public int b;

    public static Rgb16 newI(int argb) {
        Rgb16 c = new Rgb16();
        c.setInt(argb);
        return c;
    }

    public void setInt(int a) {
        this.r = a >> 8 & 0xFF00 | 0x80;
        this.g = a & 0xFF00 | 0x80;
        this.b = a << 8 & 0xFF00 | 0x80;
    }

    public void setRgb(Rgb16 a) {
        this.r = a.r;
        this.g = a.g;
        this.b = a.b;
    }

    public void diffDiv(Rgb16 a, Rgb16 b, int divisor) {
        this.r = (a.r - b.r) / divisor;
        this.g = (a.g - b.g) / divisor;
        this.b = (a.b - b.b) / divisor;
    }

    public void setAndIncrement(Rgb16 base, Rgb16 inc) {
        this.r = base.r;
        base.r += inc.r;
        this.g = base.g;
        base.g += inc.g;
        this.b = base.b;
        base.b += inc.b;
    }

    public int getArgb() {
        return 0xFF000000 | this.r << 8 & 0xFF0000 | this.g & 0xFF00 | this.b >> 8;
    }

    public String toString() {
        return new SB().append("Rgb16(").appendI(this.r).appendC(',').appendI(this.g).appendC(',').appendI(this.b).append(" -> ").appendI(this.r >> 8 & 0xFF).appendC(',').appendI(this.g >> 8 & 0xFF).appendC(',').appendI(this.b >> 8 & 0xFF).appendC(')').toString();
    }
}

