/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.SuppressFBWarnings;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class LanguageAwareCompletionProvider
extends CompletionProviderBase
implements ToolTipSupplier {
    private CompletionProvider defaultProvider;
    private CompletionProvider stringCompletionProvider;
    private CompletionProvider commentCompletionProvider;
    private CompletionProvider docCommentCompletionProvider;

    protected LanguageAwareCompletionProvider() {
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public LanguageAwareCompletionProvider(CompletionProvider defaultProvider) {
        this.setDefaultCompletionProvider(defaultProvider);
    }

    @Override
    public void clearParameterizedCompletionParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent comp) {
        if (!(comp instanceof RSyntaxTextArea)) {
            return "";
        }
        CompletionProvider provider = this.getProviderFor(comp);
        return provider != null ? provider.getAlreadyEnteredText(comp) : null;
    }

    public CompletionProvider getCommentCompletionProvider() {
        return this.commentCompletionProvider;
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent tc5, Point p15) {
        return this.defaultProvider == null ? null : this.defaultProvider.getCompletionsAt(tc5, p15);
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        CompletionProvider provider;
        if (comp instanceof RSyntaxTextArea && (provider = this.getProviderFor(comp)) != null) {
            return provider.getCompletions(comp);
        }
        return Collections.emptyList();
    }

    public CompletionProvider getDefaultCompletionProvider() {
        return this.defaultProvider;
    }

    public CompletionProvider getDocCommentCompletionProvider() {
        return this.docCommentCompletionProvider;
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent tc5) {
        CompletionProvider provider = this.getProviderFor(tc5);
        return provider == this.defaultProvider ? provider.getParameterizedCompletions(tc5) : null;
    }

    @Override
    public char getParameterListEnd() {
        return this.defaultProvider.getParameterListEnd();
    }

    @Override
    public String getParameterListSeparator() {
        return this.defaultProvider.getParameterListSeparator();
    }

    @Override
    public char getParameterListStart() {
        return this.defaultProvider.getParameterListStart();
    }

    private CompletionProvider getProviderFor(JTextComponent comp) {
        int line;
        RSyntaxTextArea rsta = (RSyntaxTextArea)comp;
        RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
        Token t15 = doc.getTokenListForLine(line = rsta.getCaretLineNumber());
        if (t15 == null) {
            return this.getDefaultCompletionProvider();
        }
        int dot = rsta.getCaretPosition();
        Token curToken = RSyntaxUtilities.getTokenAtOffset(t15, dot);
        if (curToken == null) {
            int type = doc.getLastTokenTypeOnLine(line);
            if (type == 0) {
                Token temp = t15.getLastPaintableToken();
                if (temp == null) {
                    return this.getDefaultCompletionProvider();
                }
                type = temp.getType();
            } else if (type < 0) {
                type = doc.getClosestStandardTokenTypeForInternalType(type);
            }
            switch (type) {
                case 37: {
                    return this.getStringCompletionProvider();
                }
                case 1: 
                case 2: {
                    return this.getCommentCompletionProvider();
                }
                case 3: {
                    return this.getDocCommentCompletionProvider();
                }
            }
            return this.getDefaultCompletionProvider();
        }
        if (dot == curToken.getOffset()) {
            return this.getDefaultCompletionProvider();
        }
        switch (curToken.getType()) {
            case 13: 
            case 37: {
                return this.getStringCompletionProvider();
            }
            case 1: 
            case 2: {
                return this.getCommentCompletionProvider();
            }
            case 3: {
                return this.getDocCommentCompletionProvider();
            }
            case 0: 
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return this.getDefaultCompletionProvider();
            }
        }
        return null;
    }

    public CompletionProvider getStringCompletionProvider() {
        return this.stringCompletionProvider;
    }

    @Override
    public boolean isAutoActivateOkay(JTextComponent tc5) {
        CompletionProvider provider = this.getProviderFor(tc5);
        return provider != null && provider.isAutoActivateOkay(tc5);
    }

    public void setCommentCompletionProvider(CompletionProvider provider) {
        this.commentCompletionProvider = provider;
    }

    public void setDefaultCompletionProvider(CompletionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.defaultProvider = provider;
    }

    public void setDocCommentCompletionProvider(CompletionProvider provider) {
        this.docCommentCompletionProvider = provider;
    }

    @Override
    public void setParameterizedCompletionParams(char listStart, String separator, char listEnd) {
        throw new UnsupportedOperationException();
    }

    public void setStringCompletionProvider(CompletionProvider provider) {
        this.stringCompletionProvider = provider;
    }

    @Override
    public String getToolTipText(RTextArea textArea, MouseEvent e15) {
        String tip = null;
        List<Completion> completions = this.getCompletionsAt(textArea, e15.getPoint());
        if (completions != null && !completions.isEmpty()) {
            Completion c15 = completions.get(0);
            tip = c15.getToolTipText();
        }
        return tip;
    }
}

