/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionXMLParser;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultCompletionProvider
extends AbstractCompletionProvider {
    protected Segment seg;
    private String lastCompletionsAtText;
    private List<Completion> lastParameterizedCompletionsAt;

    public DefaultCompletionProvider() {
        this.init();
    }

    public DefaultCompletionProvider(String[] words) {
        this.init();
        this.addWordCompletions(words);
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent comp) {
        Document doc = comp.getDocument();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = this.seg.offset + len;
        for (start = segEnd - 1; start >= this.seg.offset && this.isValidChar(this.seg.array[start]); --start) {
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(this.seg.array, start, len);
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent tc5, Point p15) {
        int offset = tc5.viewToModel(p15);
        if (offset < 0 || offset >= tc5.getDocument().getLength()) {
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
        Segment s15 = new Segment();
        Document doc = tc5.getDocument();
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element elem = root.getElement(line);
        int start = elem.getStartOffset();
        int end = elem.getEndOffset() - 1;
        try {
            int endOffs;
            int startOffs;
            doc.getText(start, end - start, s15);
            for (startOffs = s15.offset + (offset - start) - 1; startOffs >= s15.offset && this.isValidChar(s15.array[startOffs]); --startOffs) {
            }
            for (endOffs = s15.offset + (offset - start); endOffs < s15.offset + s15.count && this.isValidChar(s15.array[endOffs]); ++endOffs) {
            }
            int len = endOffs - startOffs - 1;
            if (len <= 0) {
                this.lastParameterizedCompletionsAt = null;
                return null;
            }
            String text = new String(s15.array, startOffs + 1, len);
            if (text.equals(this.lastCompletionsAtText)) {
                return this.lastParameterizedCompletionsAt;
            }
            List<Completion> list2 = this.getCompletionByInputText(text);
            this.lastCompletionsAtText = text;
            this.lastParameterizedCompletionsAt = list2;
            return this.lastParameterizedCompletionsAt;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent tc5) {
        int line;
        ArrayList<ParameterizedCompletion> list2 = null;
        char paramListStart = this.getParameterListStart();
        if (paramListStart == '\u0000') {
            return list2;
        }
        int dot = tc5.getCaretPosition();
        Segment s15 = new Segment();
        Document doc = tc5.getDocument();
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(dot));
        int offs = elem.getStartOffset();
        int len = dot - offs - 1;
        if (len <= 0) {
            return list2;
        }
        try {
            doc.getText(offs, len, s15);
            for (offs = s15.offset + len - 1; offs >= s15.offset && Character.isWhitespace(s15.array[offs]); --offs) {
            }
            int end = offs;
            while (offs >= s15.offset && this.isValidChar(s15.array[offs])) {
                --offs;
            }
            String text = new String(s15.array, offs + 1, end - offs);
            List<Completion> l15 = this.getCompletionByInputText(text);
            if (l15 != null && !l15.isEmpty()) {
                for (Completion o15 : l15) {
                    if (!(o15 instanceof ParameterizedCompletion)) continue;
                    if (list2 == null) {
                        list2 = new ArrayList<ParameterizedCompletion>(1);
                    }
                    list2.add((ParameterizedCompletion)o15);
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return list2;
    }

    protected void init() {
        this.seg = new Segment();
    }

    protected boolean isValidChar(char ch4) {
        return Character.isLetterOrDigit(ch4) || ch4 == '_';
    }

    public void loadFromXML(File file2) throws IOException {
        try (BufferedInputStream bin = new BufferedInputStream(Files.newInputStream(file2.toPath(), new OpenOption[0]));){
            this.loadFromXML(bin);
        }
    }

    public void loadFromXML(InputStream in4) throws IOException {
        this.loadFromXML(in4, null);
    }

    public void loadFromXML(InputStream in4, ClassLoader cl4) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        CompletionXMLParser handler = new CompletionXMLParser(this, cl4);
        try (BufferedInputStream bin = new BufferedInputStream(in4);){
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)bin, (DefaultHandler)handler);
            List<Completion> completions = handler.getCompletions();
            this.addCompletions(completions);
            char startChar = handler.getParamStartChar();
            if (startChar != '\u0000') {
                char endChar = handler.getParamEndChar();
                String sep = handler.getParamSeparator();
                if (sep != null && sep.length() > 0) {
                    this.setParameterizedCompletionParams(startChar, sep, endChar);
                }
            }
        }
        catch (ParserConfigurationException | SAXException e15) {
            throw new IOException(e15.toString());
        }
    }

    public void loadFromXML(String resource) throws IOException {
        ClassLoader cl4 = this.getClass().getClassLoader();
        InputStream in4 = cl4.getResourceAsStream(resource);
        if (in4 == null) {
            File file2 = new File(resource);
            if (file2.isFile()) {
                in4 = Files.newInputStream(file2.toPath(), new OpenOption[0]);
            } else {
                throw new IOException("No such resource: " + resource);
            }
        }
        try (BufferedInputStream bin = new BufferedInputStream(in4);){
            this.loadFromXML(bin);
        }
    }
}

