/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CharSequenceUtils {
    private static final int NOT_FOUND = -1;
    static final int TO_STRING_LIMIT = 16;

    private static boolean checkLaterThan1(CharSequence cs4, CharSequence searchChar, int len2, int start1) {
        int i15 = 1;
        for (int j15 = len2 - 1; i15 <= j15; ++i15, --j15) {
            if (cs4.charAt(start1 + i15) == searchChar.charAt(i15) && cs4.charAt(start1 + j15) == searchChar.charAt(j15)) continue;
            return false;
        }
        return true;
    }

    static int indexOf(CharSequence cs4, CharSequence searchChar, int start) {
        if (cs4 == null || searchChar == null) {
            return -1;
        }
        if (cs4 instanceof String) {
            return ((String)cs4).indexOf(searchChar.toString(), start);
        }
        if (cs4 instanceof StringBuilder) {
            return ((StringBuilder)cs4).indexOf(searchChar.toString(), start);
        }
        if (cs4 instanceof StringBuffer) {
            return ((StringBuffer)cs4).indexOf(searchChar.toString(), start);
        }
        return cs4.toString().indexOf(searchChar.toString(), start);
    }

    static int indexOf(CharSequence cs4, int searchChar, int start) {
        if (cs4 instanceof String) {
            return ((String)cs4).indexOf(searchChar, start);
        }
        int sz4 = cs4.length();
        if (start < 0) {
            start = 0;
        }
        if (searchChar < 65536) {
            for (int i15 = start; i15 < sz4; ++i15) {
                if (cs4.charAt(i15) != searchChar) continue;
                return i15;
            }
            return -1;
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            for (int i16 = start; i16 < sz4 - 1; ++i16) {
                char high = cs4.charAt(i16);
                char low = cs4.charAt(i16 + 1);
                if (high != chars[0] || low != chars[1]) continue;
                return i16;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (searchChar == null || cs == null) {
            return -1;
        }
        if (searchChar instanceof String) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf((String)searchChar, start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf((String)searchChar, start);
            }
        }
        len1 = cs.length();
        len2 = searchChar.length();
        if (start > len1) {
            start = len1;
        }
        if (start < 0 || len2 > len1) {
            return -1;
        }
        if (len2 == 0) {
            return start;
        }
        if (len2 <= 16) {
            if (cs instanceof String) {
                return ((String)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuilder) {
                return ((StringBuilder)cs).lastIndexOf(searchChar.toString(), start);
            }
            if (cs instanceof StringBuffer) {
                return ((StringBuffer)cs).lastIndexOf(searchChar.toString(), start);
            }
        }
        if (start + len2 > len1) {
            start = len1 - len2;
        }
        char0 = searchChar.charAt(0);
        i = start;
        do lbl-1000:
        // 3 sources

        {
            block14: {
                if (cs.charAt(i) == char0) break block14;
                if (--i >= 0) ** GOTO lbl-1000
                return -1;
            }
            if (!CharSequenceUtils.checkLaterThan1(cs, searchChar, len2, i)) continue;
            return i;
        } while (--i >= 0);
        return -1;
    }

    static int lastIndexOf(CharSequence cs4, int searchChar, int start) {
        if (cs4 instanceof String) {
            return ((String)cs4).lastIndexOf(searchChar, start);
        }
        int sz4 = cs4.length();
        if (start < 0) {
            return -1;
        }
        if (start >= sz4) {
            start = sz4 - 1;
        }
        if (searchChar < 65536) {
            for (int i15 = start; i15 >= 0; --i15) {
                if (cs4.charAt(i15) != searchChar) continue;
                return i15;
            }
            return -1;
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            if (start == sz4 - 1) {
                return -1;
            }
            for (int i16 = start; i16 >= 0; --i16) {
                char high = cs4.charAt(i16);
                char low = cs4.charAt(i16 + 1);
                if (chars[0] != high || chars[1] != low) continue;
                return i16;
            }
        }
        return -1;
    }

    static boolean regionMatches(CharSequence cs4, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs4 instanceof String && substring instanceof String) {
            return ((String)cs4).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs4.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char u25;
            char c25;
            char c15;
            if ((c15 = cs4.charAt(index1++)) == (c25 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            char u15 = Character.toUpperCase(c15);
            if (u15 == (u25 = Character.toUpperCase(c25)) || Character.toLowerCase(u15) == Character.toLowerCase(u25)) continue;
            return false;
        }
        return true;
    }

    public static CharSequence subSequence(CharSequence cs4, int start) {
        return cs4 == null ? null : cs4.subSequence(start, cs4.length());
    }

    public static char[] toCharArray(CharSequence source) {
        int len = StringUtils.length(source);
        if (len == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        if (source instanceof String) {
            return ((String)source).toCharArray();
        }
        char[] array = new char[len];
        for (int i15 = 0; i15 < len; ++i15) {
            array[i15] = source.charAt(i15);
        }
        return array;
    }

    @Deprecated
    public CharSequenceUtils() {
    }
}

