/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(List<Integer> items) {
        this();
        for (int i15 = 0; i15 < items.size(); ++i15) {
            Integer v15 = items.get(i15);
            this.add(v15);
        }
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public static BitSet of(int el4) {
        BitSet s15 = new BitSet(el4 + 1);
        s15.add(el4);
        return s15;
    }

    public static BitSet of(int a15, int b15) {
        BitSet s15 = new BitSet(Math.max(a15, b15) + 1);
        s15.add(a15);
        s15.add(b15);
        return s15;
    }

    public static BitSet of(int a15, int b15, int c15) {
        BitSet s15 = new BitSet();
        s15.add(a15);
        s15.add(b15);
        s15.add(c15);
        return s15;
    }

    public static BitSet of(int a15, int b15, int c15, int d15) {
        BitSet s15 = new BitSet();
        s15.add(a15);
        s15.add(b15);
        s15.add(c15);
        s15.add(d15);
        return s15;
    }

    public BitSet or(BitSet a15) {
        if (a15 == null) {
            return this;
        }
        BitSet s15 = (BitSet)this.clone();
        s15.orInPlace(a15);
        return s15;
    }

    public void add(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            this.growToInclude(el4);
        }
        int n16 = n15;
        this.bits[n16] = this.bits[n16] | BitSet.bitMask(el4);
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void orInPlace(BitSet a15) {
        if (a15 == null) {
            return;
        }
        if (a15.bits.length > this.bits.length) {
            this.setSize(a15.bits.length);
        }
        int min = Math.min(this.bits.length, a15.bits.length);
        for (int i15 = min - 1; i15 >= 0; --i15) {
            int n15 = i15;
            this.bits[n15] = this.bits[n15] | a15.bits[i15];
        }
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n15 = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n15);
        this.bits = newbits;
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public Object clone() {
        BitSet s15;
        try {
            s15 = (BitSet)super.clone();
            s15.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s15.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e15) {
            throw new InternalError();
        }
        return s15;
    }

    public int size() {
        int deg = 0;
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            long word = this.bits[i15];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object other) {
        block5: {
            int i15;
            int n15;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n15 = Math.min(this.bits.length, otherSet.bits.length);
                for (i15 = 0; i15 < n15; ++i15) {
                    if (this.bits[i15] == otherSet.bits[i15]) continue;
                    return false;
                }
                if (this.bits.length <= n15) break block4;
                for (i15 = n15 + 1; i15 < this.bits.length; ++i15) {
                    if (this.bits[i15] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n15) break block5;
            for (i15 = n15 + 1; i15 < otherSet.bits.length; ++i15) {
                if (otherSet.bits[i15] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int el4) {
        if (el4 < 0) {
            return false;
        }
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            return false;
        }
        return (this.bits[n15] & BitSet.bitMask(el4)) != 0L;
    }

    public void remove(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 < this.bits.length) {
            int n16 = n15;
            this.bits[n16] = this.bits[n16] & (BitSet.bitMask(el4) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isNil() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            if (this.bits[i15] == 0L) continue;
            return false;
        }
        return true;
    }

    private final int numWordsToHold(int el4) {
        return (el4 >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en4 = 0;
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            elems[en4++] = i15;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] tokenNames) {
        StringBuilder buf = new StringBuilder();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (i15 > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (tokenNames != null) {
                buf.append(tokenNames[i15]);
            } else {
                buf.append(i15);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }
}

