/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.PredicateLabel;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.Token;
import org.antlr.tool.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFAToDFAConverter {
    protected List<DFAState> work = new LinkedList<DFAState>();
    protected NFAContext[] contextTrees;
    protected DFA dfa;
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;
    protected boolean computingStartState = false;

    public NFAToDFAConverter(DFA dfa) {
        this.dfa = dfa;
        int nAlts = dfa.getNumberOfAlts();
        this.initContextTrees(nAlts);
    }

    public void convert() {
        this.dfa.startState = this.computeStartState();
        while (this.work.size() > 0 && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
            int k15;
            DFAState d15 = this.work.get(0);
            if (this.dfa.nfa.grammar.composite.watchNFAConversion) {
                System.out.println("convert DFA state " + d15.stateNumber + " (" + d15.nfaConfigurations.size() + " nfa states)");
            }
            if ((k15 = this.dfa.getUserMaxLookahead()) > 0 && k15 == d15.getLookaheadDepth()) {
                this.resolveNonDeterminisms(d15);
                if (d15.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(d15);
                } else {
                    d15.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(d15);
            }
            this.work.remove(0);
        }
        this.dfa.findAllGatedSynPredsUsedInDFAAcceptStates();
    }

    protected DFAState computeStartState() {
        NFAState alt = this.dfa.decisionNFAStartState;
        DFAState startState = this.dfa.newState();
        this.computingStartState = true;
        int i15 = 0;
        int altNum = 1;
        while (alt != null) {
            NFAContext initialContext = this.contextTrees[i15];
            if (i15 == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int numAltsIncludingExitBranch;
                altNum = numAltsIncludingExitBranch = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                altNum = 1;
            } else {
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                ++altNum;
            }
            ++i15;
            if (alt.transition[1] == null) break;
            alt = (NFAState)alt.transition[1].target;
        }
        this.dfa.addState(startState);
        this.work.add(startState);
        this.computingStartState = false;
        return startState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState d15) {
        boolean containsEOT;
        OrderedHashSet<Label> labels = d15.getReachableLabels();
        Label EOTLabel = new Label(-2);
        boolean bl4 = containsEOT = labels != null && labels.contains(EOTLabel);
        if (!this.dfa.isGreedy() && containsEOT) {
            this.convertToEOTAcceptState(d15);
            return;
        }
        int numberOfEdgesEmanating = 0;
        HashMap<Integer, Transition> targetToLabelMap = new HashMap<Integer, Transition>();
        int numLabels = 0;
        if (labels != null) {
            numLabels = labels.size();
        }
        for (int i15 = 0; i15 < numLabels; ++i15) {
            Label label = labels.get(i15);
            DFAState t15 = this.reach(d15, label);
            if (debug) {
                System.out.println("DFA state after reach " + label + " " + d15 + "-" + label.toString(this.dfa.nfa.grammar) + "->" + t15);
            }
            if (t15 == null) continue;
            if (t15.getUniqueAlt() == -1) {
                this.closure(t15);
            }
            DFAState targetState = this.addDFAStateToWorkList(t15);
            numberOfEdgesEmanating += NFAToDFAConverter.addTransition(d15, label, targetState, targetToLabelMap);
            targetState.setLookaheadDepth(d15.getLookaheadDepth() + 1);
        }
        if (!d15.isResolvedWithPredicates() && numberOfEdgesEmanating == 0) {
            this.dfa.probe.reportDanglingState(d15);
            int minAlt = this.resolveByPickingMinAlt(d15, null);
            d15.setAcceptState(true);
            this.dfa.setAcceptState(minAlt, d15);
        }
        if (d15.isResolvedWithPredicates()) {
            this.addPredicateTransitions(d15);
        }
    }

    protected static int addTransition(DFAState d15, Label label, DFAState targetState, Map<Integer, Transition> targetToLabelMap) {
        int n15 = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer tI2 = Utils.integer(targetState.stateNumber);
            Transition oldTransition = targetToLabelMap.get(tI2);
            if (oldTransition != null) {
                if (label.getAtom() == -2) {
                    oldTransition.label = new Label(-2);
                } else if (oldTransition.label.getAtom() != -2) {
                    oldTransition.label.add(label);
                }
            } else {
                n15 = 1;
                label = (Label)label.clone();
                int transitionIndex = d15.addTransition(targetState, label);
                Transition trans = d15.getTransition(transitionIndex);
                targetToLabelMap.put(tI2, trans);
            }
        } else {
            n15 = 1;
            d15.addTransition(targetState, label);
        }
        return n15;
    }

    public void closure(DFAState d15) {
        if (debug) {
            System.out.println("closure(" + d15 + ")");
        }
        ArrayList<NFAConfiguration> configs = new ArrayList<NFAConfiguration>();
        configs.addAll(d15.nfaConfigurations);
        int numConfigs = configs.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration c15 = (NFAConfiguration)configs.get(i15);
            if (c15.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(c15.state), c15.alt, c15.context, c15.semanticContext, d15, false);
        }
        d15.closureBusy = null;
    }

    public void closure(NFAState p15, int alt, NFAContext context, SemanticContext semanticContext, DFAState d15, boolean collectPredicates) {
        NFAConfiguration proposedNFAConfiguration;
        if (debug) {
            System.out.println("closure at " + p15.enclosingRule.name + " state " + p15.stateNumber + "|" + alt + " filling DFA state " + d15.stateNumber + " with context " + context);
        }
        if (NFAToDFAConverter.closureIsBusy(d15, proposedNFAConfiguration = new NFAConfiguration(p15.stateNumber, alt, context, semanticContext))) {
            if (debug) {
                System.out.println("avoid visiting exact closure computation NFA config: " + proposedNFAConfiguration + " in " + p15.enclosingRule.name);
                System.out.println("state is " + d15.dfa.decisionNumber + "." + d15.stateNumber);
            }
            return;
        }
        d15.closureBusy.add(proposedNFAConfiguration);
        d15.addNFAConfiguration(p15, proposedNFAConfiguration);
        Transition transition0 = p15.transition[0];
        if (transition0 instanceof RuleClosureTransition) {
            int depth = context.recursionDepthEmanatingFromState(p15.stateNumber);
            if (depth == 1 && d15.dfa.getUserMaxLookahead() == 0) {
                d15.dfa.recursiveAltSet.add(alt);
                if (d15.dfa.recursiveAltSet.size() > 1) {
                    d15.abortedDueToMultipleRecursiveAlts = true;
                    throw new NonLLStarDecisionException(d15.dfa);
                }
            }
            if (depth >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                d15.abortedDueToRecursionOverflow = true;
                d15.dfa.probe.reportRecursionOverflow(d15, proposedNFAConfiguration);
                if (debug) {
                    System.out.println("analysis overflow in closure(" + d15.stateNumber + ")");
                }
                return;
            }
            RuleClosureTransition ref = (RuleClosureTransition)transition0;
            NFAContext newContext = new NFAContext(context, p15);
            NFAState ruleTarget = (NFAState)ref.target;
            this.closure(ruleTarget, alt, newContext, semanticContext, d15, collectPredicates);
        } else if (p15.isAcceptState() && context.parent != null) {
            NFAState whichStateInvokedRule = context.invokingState;
            RuleClosureTransition edgeToRule = (RuleClosureTransition)whichStateInvokedRule.transition[0];
            NFAState continueState = edgeToRule.followState;
            NFAContext newContext = context.parent;
            this.closure(continueState, alt, newContext, semanticContext, d15, collectPredicates);
        } else {
            if (transition0 != null && transition0.isEpsilon()) {
                boolean collectPredicatesAfterAction = collectPredicates;
                if (transition0.isAction() && collectPredicates) {
                    collectPredicatesAfterAction = false;
                }
                this.closure((NFAState)transition0.target, alt, context, semanticContext, d15, collectPredicatesAfterAction);
            } else if (transition0 != null && transition0.isSemanticPredicate()) {
                SemanticContext labelContext = transition0.label.getSemanticContext();
                if (this.computingStartState) {
                    if (collectPredicates) {
                        this.dfa.predicateVisible = true;
                    } else {
                        this.dfa.hasPredicateBlockedByAction = true;
                    }
                }
                SemanticContext newSemanticContext = semanticContext;
                if (collectPredicates) {
                    int walkAlt = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(alt);
                    NFAState altLeftEdge = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, walkAlt);
                    if (!labelContext.isSyntacticPredicate() || p15 == altLeftEdge.transition[0].target) {
                        newSemanticContext = SemanticContext.and(semanticContext, labelContext);
                    }
                }
                this.closure((NFAState)transition0.target, alt, context, newSemanticContext, d15, collectPredicates);
            }
            Transition transition1 = p15.transition[1];
            if (transition1 != null && transition1.isEpsilon()) {
                this.closure((NFAState)transition1.target, alt, context, semanticContext, d15, collectPredicates);
            }
        }
    }

    public static boolean closureIsBusy(DFAState d15, NFAConfiguration proposedNFAConfiguration) {
        return d15.closureBusy.contains(proposedNFAConfiguration);
    }

    public DFAState reach(DFAState d15, Label label) {
        DFAState labelDFATarget = this.dfa.newState();
        List<NFAConfiguration> configs = d15.configurationsWithLabeledEdges;
        int numConfigs = configs.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration c15 = configs.get(i15);
            if (c15.resolved || c15.resolveWithPredicate) continue;
            NFAState p15 = this.dfa.nfa.getState(c15.state);
            Transition edge = p15.transition[0];
            if (edge == null || !c15.singleAtomTransitionEmanating) continue;
            Label edgeLabel = edge.label;
            if (c15.context.parent != null && edgeLabel.label == -2 || !Label.intersect(label, edgeLabel)) continue;
            NFAConfiguration newC = labelDFATarget.addNFAConfiguration((NFAState)edge.target, c15.alt, c15.context, c15.semanticContext);
        }
        if (labelDFATarget.nfaConfigurations.size() == 0) {
            this.dfa.setState(labelDFATarget.stateNumber, null);
            labelDFATarget = null;
        }
        return labelDFATarget;
    }

    protected void convertToEOTAcceptState(DFAState d15) {
        Label eot = new Label(-2);
        int numConfigs = d15.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration c15 = d15.nfaConfigurations.get(i15);
            if (c15.resolved || c15.resolveWithPredicate) continue;
            NFAState p15 = this.dfa.nfa.getState(c15.state);
            Transition edge = p15.transition[0];
            Label edgeLabel = edge.label;
            if (!edgeLabel.equals(eot)) continue;
            d15.setAcceptState(true);
            d15.nfaConfigurations.clear();
            d15.addNFAConfiguration(p15, c15.alt, c15.context, c15.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState d15) {
        DFAState existingState = this.dfa.addState(d15);
        if (d15 != existingState) {
            this.dfa.setState(d15.stateNumber, existingState);
            return existingState;
        }
        this.resolveNonDeterminisms(d15);
        int alt = d15.getUniquelyPredictedAlt();
        if (alt != -1) {
            d15 = this.convertToAcceptState(d15, alt);
        } else {
            this.work.add(d15);
        }
        return d15;
    }

    protected DFAState convertToAcceptState(DFAState d15, int alt) {
        DFAState acceptStateForAlt;
        if (DFAOptimizer.MERGE_STOP_STATES && d15.getNonDeterministicAlts() == null && !d15.abortedDueToRecursionOverflow && !d15.abortedDueToMultipleRecursiveAlts && (acceptStateForAlt = this.dfa.getAcceptState(alt)) != null) {
            SemanticContext gatedPreds = d15.getGatedPredicatesInNFAConfigurations();
            SemanticContext existingStateGatedPreds = acceptStateForAlt.getGatedPredicatesInNFAConfigurations();
            if (gatedPreds == null && existingStateGatedPreds == null || gatedPreds != null && existingStateGatedPreds != null && gatedPreds.equals(existingStateGatedPreds)) {
                this.dfa.setState(d15.stateNumber, acceptStateForAlt);
                this.dfa.removeState(d15);
                d15 = acceptStateForAlt;
                return d15;
            }
        }
        d15.setAcceptState(true);
        this.dfa.setAcceptState(alt, d15);
        return d15;
    }

    public void resolveNonDeterminisms(DFAState d15) {
        boolean resolved;
        Set<Integer> allAlts;
        if (debug) {
            System.out.println("resolveNonDeterminisms " + d15.toString());
        }
        boolean conflictingLexerRules = false;
        Set<Integer> nondeterministicAlts = d15.getNonDeterministicAlts();
        if (debug && nondeterministicAlts != null) {
            System.out.println("nondet alts=" + nondeterministicAlts);
        }
        NFAConfiguration anyConfig = d15.nfaConfigurations.get(0);
        NFAState anyState = this.dfa.nfa.getState(anyConfig.state);
        if (anyState.isEOTTargetState() && (allAlts = d15.getAltSet()) != null && allAlts.size() > 1) {
            nondeterministicAlts = allAlts;
            if (d15.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(d15, allAlts);
                conflictingLexerRules = true;
            }
        }
        if (!d15.abortedDueToRecursionOverflow && nondeterministicAlts == null) {
            return;
        }
        if (!d15.abortedDueToRecursionOverflow && !conflictingLexerRules) {
            this.dfa.probe.reportNondeterminism(d15, nondeterministicAlts);
        }
        if (resolved = this.tryToResolveWithSemanticPredicates(d15, nondeterministicAlts)) {
            if (debug) {
                System.out.println("resolved DFA state " + d15.stateNumber + " with pred");
            }
            d15.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(d15);
            return;
        }
        this.resolveByChoosingFirstAlt(d15, nondeterministicAlts);
    }

    protected int resolveByChoosingFirstAlt(DFAState d15, Set<Integer> nondeterministicAlts) {
        int exitAlt;
        int winningAlt = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(d15, nondeterministicAlts) : (nondeterministicAlts.contains(Utils.integer(exitAlt = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(d15, nondeterministicAlts) : this.resolveByPickingMinAlt(d15, nondeterministicAlts));
        return winningAlt;
    }

    protected int resolveByPickingMinAlt(DFAState d15, Set<Integer> nondeterministicAlts) {
        int min = nondeterministicAlts != null ? NFAToDFAConverter.getMinAlt(nondeterministicAlts) : d15.minAltInConfigurations;
        NFAToDFAConverter.turnOffOtherAlts(d15, min, nondeterministicAlts);
        return min;
    }

    protected int resolveByPickingExitAlt(DFAState d15, Set<Integer> nondeterministicAlts) {
        int exitAlt = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(d15, exitAlt, nondeterministicAlts);
        return exitAlt;
    }

    protected static void turnOffOtherAlts(DFAState d15, int min, Set<Integer> nondeterministicAlts) {
        int numConfigs = d15.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = d15.nfaConfigurations.get(i15);
            if (configuration.alt == min || nondeterministicAlts != null && !nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
            configuration.resolved = true;
        }
    }

    protected static int getMinAlt(Set<Integer> nondeterministicAlts) {
        int min = Integer.MAX_VALUE;
        for (Integer altI : nondeterministicAlts) {
            int alt = altI;
            if (alt >= min) continue;
            min = alt;
        }
        return min;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState d15, Set<Integer> nondeterministicAlts) {
        Map<Integer, SemanticContext> altToPredMap = this.getPredicatesPerNonDeterministicAlt(d15, nondeterministicAlts);
        if (altToPredMap.isEmpty()) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(d15, altToPredMap);
        if (nondeterministicAlts.size() - altToPredMap.size() > 1) {
            return false;
        }
        if (altToPredMap.size() == nondeterministicAlts.size() - 1) {
            SemanticContext unionOfPredicatesFromAllAlts;
            BitSet predSet;
            BitSet ndSet = BitSet.of(nondeterministicAlts);
            int nakedAlt = ndSet.subtract(predSet = BitSet.of(altToPredMap)).getSingleElement();
            SemanticContext nakedAltPred = nakedAlt == NFAToDFAConverter.max(nondeterministicAlts) ? new SemanticContext.TruePredicate() : ((unionOfPredicatesFromAllAlts = NFAToDFAConverter.getUnionOfPredicates(altToPredMap)).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not(unionOfPredicatesFromAllAlts));
            altToPredMap.put(Utils.integer(nakedAlt), nakedAltPred);
            int numConfigs = d15.nfaConfigurations.size();
            for (int i15 = 0; i15 < numConfigs; ++i15) {
                NFAConfiguration configuration = d15.nfaConfigurations.get(i15);
                if (configuration.alt != nakedAlt) continue;
                configuration.semanticContext = nakedAltPred;
            }
        }
        if (altToPredMap.size() == nondeterministicAlts.size()) {
            if (d15.abortedDueToRecursionOverflow) {
                d15.dfa.probe.removeRecursiveOverflowState(d15);
            }
            int numConfigs = d15.nfaConfigurations.size();
            for (int i16 = 0; i16 < numConfigs; ++i16) {
                NFAConfiguration configuration = d15.nfaConfigurations.get(i16);
                SemanticContext semCtx = altToPredMap.get(Utils.integer(configuration.alt));
                if (semCtx != null) {
                    configuration.resolveWithPredicate = true;
                    configuration.semanticContext = semCtx;
                    altToPredMap.remove(Utils.integer(configuration.alt));
                    if (!semCtx.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semCtx);
                    continue;
                }
                if (!nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
                configuration.resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map<Integer, SemanticContext> getPredicatesPerNonDeterministicAlt(DFAState d15, Set<Integer> nondeterministicAlts) {
        HashMap<Integer, SemanticContext> altToPredicateContextMap = new HashMap<Integer, SemanticContext>();
        HashMap altToSetOfContextsMap = new HashMap();
        for (Integer altI : nondeterministicAlts) {
            altToSetOfContextsMap.put(altI, new OrderedHashSet());
        }
        HashMap<Integer, Set<Token>> altToLocationsReachableWithoutPredicate = new HashMap<Integer, Set<Token>>();
        HashSet<Integer> nondetAltsWithUncoveredConfiguration = new HashSet<Integer>();
        int numConfigs = d15.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration configuration = d15.nfaConfigurations.get(i15);
            Integer altI = Utils.integer(configuration.alt);
            if (!nondeterministicAlts.contains(altI)) continue;
            if (configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                Set predSet = (Set)altToSetOfContextsMap.get(altI);
                predSet.add(configuration.semanticContext);
                continue;
            }
            nondetAltsWithUncoveredConfiguration.add(altI);
        }
        ArrayList<Integer> incompletelyCoveredAlts = new ArrayList<Integer>();
        for (Integer altI : nondeterministicAlts) {
            Set contextsForThisAlt = (Set)altToSetOfContextsMap.get(altI);
            if (nondetAltsWithUncoveredConfiguration.contains(altI)) {
                if (contextsForThisAlt.size() <= 0) continue;
                incompletelyCoveredAlts.add(altI);
                continue;
            }
            SemanticContext combinedContext = null;
            for (SemanticContext ctx : contextsForThisAlt) {
                combinedContext = SemanticContext.or(combinedContext, ctx);
            }
            altToPredicateContextMap.put(altI, combinedContext);
        }
        if (incompletelyCoveredAlts.size() > 0) {
            for (int i16 = 0; i16 < numConfigs; ++i16) {
                NFAConfiguration configuration = d15.nfaConfigurations.get(i16);
                Integer altI = Utils.integer(configuration.alt);
                if (!incompletelyCoveredAlts.contains(altI) || configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) continue;
                NFAState s15 = this.dfa.nfa.getState(configuration.state);
                if (s15.incidentEdgeLabel == null || s15.incidentEdgeLabel.label == -1) continue;
                if (s15.associatedASTNode == null || s15.associatedASTNode.token == null) {
                    ErrorManager.internalError("no AST/token for nonepsilon target w/o predicate");
                    continue;
                }
                HashSet<Token> locations = (HashSet<Token>)altToLocationsReachableWithoutPredicate.get(altI);
                if (locations == null) {
                    locations = new HashSet<Token>();
                    altToLocationsReachableWithoutPredicate.put(altI, locations);
                }
                locations.add(s15.associatedASTNode.token);
            }
            this.dfa.probe.reportIncompletelyCoveredAlts(d15, altToLocationsReachableWithoutPredicate);
        }
        return altToPredicateContextMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map<?, SemanticContext> altToPredMap) {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        for (SemanticContext semCtx : altToPredMap.values()) {
            if (unionOfPredicatesFromAllAlts == null) {
                unionOfPredicatesFromAllAlts = semCtx;
                continue;
            }
            unionOfPredicatesFromAllAlts = SemanticContext.or(unionOfPredicatesFromAllAlts, semCtx);
        }
        return unionOfPredicatesFromAllAlts;
    }

    protected void addPredicateTransitions(DFAState d15) {
        ArrayList<NFAConfiguration> configsWithPreds = new ArrayList<NFAConfiguration>();
        int numConfigs = d15.nfaConfigurations.size();
        for (int i15 = 0; i15 < numConfigs; ++i15) {
            NFAConfiguration c15 = d15.nfaConfigurations.get(i15);
            if (!c15.resolveWithPredicate) continue;
            configsWithPreds.add(c15);
        }
        Collections.sort(configsWithPreds, new Comparator<NFAConfiguration>(){

            @Override
            public int compare(NFAConfiguration a15, NFAConfiguration b15) {
                if (a15.alt < b15.alt) {
                    return -1;
                }
                if (a15.alt > b15.alt) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<NFAConfiguration> predConfigsSortedByAlt = configsWithPreds;
        for (int i16 = 0; i16 < predConfigsSortedByAlt.size(); ++i16) {
            NFAConfiguration c16 = (NFAConfiguration)predConfigsSortedByAlt.get(i16);
            DFAState predDFATarget = d15.dfa.getAcceptState(c16.alt);
            if (predDFATarget == null) {
                predDFATarget = this.dfa.newState();
                predDFATarget.addNFAConfiguration(this.dfa.nfa.getState(c16.state), c16.alt, c16.context, c16.semanticContext);
                predDFATarget.setAcceptState(true);
                this.dfa.setAcceptState(c16.alt, predDFATarget);
                DFAState existingState = this.dfa.addState(predDFATarget);
                if (predDFATarget != existingState) {
                    this.dfa.setState(predDFATarget.stateNumber, existingState);
                    predDFATarget = existingState;
                }
            }
            d15.addTransition(predDFATarget, new PredicateLabel(c16.semanticContext));
        }
    }

    protected void initContextTrees(int numberOfAlts) {
        this.contextTrees = new NFAContext[numberOfAlts];
        for (int i15 = 0; i15 < this.contextTrees.length; ++i15) {
            int alt = i15 + 1;
            this.contextTrees[i15] = new NFAContext(null, null);
        }
    }

    public static int max(Set<Integer> s15) {
        if (s15 == null) {
            return Integer.MIN_VALUE;
        }
        int i15 = 0;
        int m15 = 0;
        for (Integer value : s15) {
            Integer I11 = value;
            if (++i15 == 1) {
                m15 = I11;
                continue;
            }
            if (I11 <= m15) continue;
            m15 = I11;
        }
        return m15;
    }
}

