/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.MultiMap;
import org.antlr.misc.Utils;
import org.antlr.runtime.Token;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionProbe {
    public DFA dfa;
    protected Set<DFAState> statesWithSyntacticallyAmbiguousAltsSet = new HashSet<DFAState>();
    protected Map<DFAState, Set<Integer>> stateToSyntacticallyAmbiguousTokensRuleAltsMap = new HashMap<DFAState, Set<Integer>>();
    protected Set<DFAState> statesResolvedWithSemanticPredicatesSet = new HashSet<DFAState>();
    protected Map<DFAState, Map<Integer, SemanticContext>> stateToAltSetWithSemanticPredicatesMap = new HashMap<DFAState, Map<Integer, SemanticContext>>();
    protected Map<DFAState, Map<Integer, Set<Token>>> stateToIncompletelyCoveredAltsMap = new HashMap<DFAState, Map<Integer, Set<Token>>>();
    protected Set<DFAState> danglingStates = new HashSet<DFAState>();
    protected Set<Integer> altsWithProblem = new HashSet<Integer>();
    public boolean nonLLStarDecision = false;
    protected MultiMap<Integer, NFAConfiguration> stateToRecursionOverflowConfigurationsMap = new MultiMap();
    protected boolean timedOut = false;
    protected Map<Integer, Integer> stateReachable;
    public static final Integer REACHABLE_BUSY = Utils.integer(-1);
    public static final Integer REACHABLE_NO = Utils.integer(0);
    public static final Integer REACHABLE_YES = Utils.integer(1);
    protected Set<String> statesVisitedAtInputDepth;
    protected Set<Integer> statesVisitedDuringSampleSequence;
    public static boolean verbose = false;

    public DecisionProbe(DFA dfa) {
        this.dfa = dfa;
    }

    public String getDescription() {
        return this.dfa.getNFADecisionStartState().getDescription();
    }

    public boolean isReduced() {
        return this.dfa.isReduced();
    }

    public boolean isCyclic() {
        return this.dfa.isCyclic();
    }

    public boolean isDeterministic() {
        if (this.danglingStates.isEmpty() && this.statesWithSyntacticallyAmbiguousAltsSet.isEmpty() && this.dfa.getUnreachableAlts().isEmpty()) {
            return true;
        }
        if (this.statesWithSyntacticallyAmbiguousAltsSet.size() > 0) {
            for (DFAState d15 : this.statesWithSyntacticallyAmbiguousAltsSet) {
                if (this.statesResolvedWithSemanticPredicatesSet.contains(d15)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean analysisOverflowed() {
        return this.stateToRecursionOverflowConfigurationsMap.size() > 0;
    }

    public boolean isNonLLStarDecision() {
        return this.nonLLStarDecision;
    }

    public int getNumberOfStates() {
        return this.dfa.getNumberOfStates();
    }

    public List<Integer> getUnreachableAlts() {
        return this.dfa.getUnreachableAlts();
    }

    public Set<DFAState> getDanglingStates() {
        return this.danglingStates;
    }

    public Set<Integer> getNonDeterministicAlts() {
        return this.altsWithProblem;
    }

    public List<Integer> getNonDeterministicAltsForState(DFAState targetState) {
        Set<Integer> nondetAlts = targetState.getNonDeterministicAlts();
        if (nondetAlts == null) {
            return null;
        }
        LinkedList<Integer> sorted2 = new LinkedList<Integer>();
        sorted2.addAll(nondetAlts);
        Collections.sort(sorted2);
        return sorted2;
    }

    public Set<DFAState> getDFAStatesWithSyntacticallyAmbiguousAlts() {
        return this.statesWithSyntacticallyAmbiguousAltsSet;
    }

    public Set<Integer> getDisabledAlternatives(DFAState d15) {
        return d15.getDisabledAlternatives();
    }

    public void removeRecursiveOverflowState(DFAState d15) {
        Integer stateI = Utils.integer(d15.stateNumber);
        this.stateToRecursionOverflowConfigurationsMap.remove(stateI);
    }

    public List<Label> getSampleNonDeterministicInputSequence(DFAState targetState) {
        Set<DFAState> dfaStates = this.getDFAPathStatesToTarget(targetState);
        this.statesVisitedDuringSampleSequence = new HashSet<Integer>();
        ArrayList<Label> labels = new ArrayList<Label>();
        if (this.dfa == null || this.dfa.startState == null) {
            return labels;
        }
        this.getSampleInputSequenceUsingStateSet(this.dfa.startState, targetState, dfaStates, labels);
        return labels;
    }

    public String getInputSequenceDisplay(List<? extends Label> labels) {
        Grammar g15 = this.dfa.nfa.grammar;
        StringBuilder buf = new StringBuilder();
        Iterator<? extends Label> it = labels.iterator();
        while (it.hasNext()) {
            Label label = it.next();
            buf.append(label.toString(g15));
            if (!it.hasNext() || g15.type == 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public List<? extends NFAState> getNFAPathStatesForAlt(int firstAlt, int alt, List<? extends Label> labels) {
        NFAState nfaStart = this.dfa.getNFADecisionStartState();
        LinkedList<NFAState> path = new LinkedList<NFAState>();
        for (int a15 = firstAlt; a15 <= alt; ++a15) {
            NFAState s15 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, a15);
            path.add(s15);
        }
        NFAState altStart = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, alt);
        NFAState isolatedAltStart = (NFAState)altStart.transition[0].target;
        path.add(isolatedAltStart);
        this.statesVisitedAtInputDepth = new HashSet<String>();
        this.getNFAPath(isolatedAltStart, 0, labels, path);
        return path;
    }

    public SemanticContext getSemanticContextForAlt(DFAState d15, int alt) {
        Map<Integer, SemanticContext> altToPredMap = this.stateToAltSetWithSemanticPredicatesMap.get(d15);
        if (altToPredMap == null) {
            return null;
        }
        return altToPredMap.get(Utils.integer(alt));
    }

    public boolean hasPredicate() {
        return this.stateToAltSetWithSemanticPredicatesMap.size() > 0;
    }

    public Set<DFAState> getNondeterministicStatesResolvedWithSemanticPredicate() {
        return this.statesResolvedWithSemanticPredicatesSet;
    }

    public Map<Integer, Set<Token>> getIncompletelyCoveredAlts(DFAState d15) {
        return this.stateToIncompletelyCoveredAltsMap.get(d15);
    }

    public void issueWarnings() {
        List<Integer> unreachableAlts;
        Set<DFAState> danglingStates;
        if (this.nonLLStarDecision && !this.dfa.getAutoBacktrackMode()) {
            ErrorManager.nonLLStarDecision(this);
        }
        this.issueRecursionWarnings();
        Set<DFAState> resolvedStates = this.getNondeterministicStatesResolvedWithSemanticPredicate();
        Set<DFAState> problemStates = this.getDFAStatesWithSyntacticallyAmbiguousAlts();
        if (problemStates.size() > 0) {
            Iterator<DFAState> it = problemStates.iterator();
            while (it.hasNext() && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
                String greedyS;
                DFAState d15 = it.next();
                Map<Integer, Set<Token>> insufficientAltToLocations = this.getIncompletelyCoveredAlts(d15);
                if (insufficientAltToLocations != null && insufficientAltToLocations.size() > 0) {
                    ErrorManager.insufficientPredicates(this, d15, insufficientAltToLocations);
                }
                if (resolvedStates != null && resolvedStates.contains(d15)) continue;
                Set<Integer> disabledAlts = this.getDisabledAlternatives(d15);
                this.stripWildCardAlts(disabledAlts);
                if (disabledAlts.size() <= 0) continue;
                boolean explicitlyGreedy = false;
                GrammarAST blockAST = d15.dfa.nfa.grammar.getDecisionBlockAST(d15.dfa.decisionNumber);
                if (blockAST != null && (greedyS = (String)blockAST.getBlockOption("greedy")) != null && greedyS.equals("true")) {
                    explicitlyGreedy = true;
                }
                if (explicitlyGreedy) continue;
                ErrorManager.nondeterminism(this, d15);
            }
        }
        if ((danglingStates = this.getDanglingStates()).size() > 0) {
            for (DFAState d16 : danglingStates) {
                ErrorManager.danglingState(this, d16);
            }
        }
        if (!this.nonLLStarDecision && (unreachableAlts = this.dfa.getUnreachableAlts()) != null && unreachableAlts.size() > 0) {
            boolean isInheritedTokensRule = false;
            if (this.dfa.isTokensRuleDecision()) {
                for (Integer altI : unreachableAlts) {
                    GrammarAST decAST = this.dfa.getDecisionASTNode();
                    GrammarAST altAST = (GrammarAST)decAST.getChild(altI - 1);
                    GrammarAST delegatedTokensAlt = (GrammarAST)altAST.getFirstChildWithType(29);
                    if (delegatedTokensAlt == null) continue;
                    isInheritedTokensRule = true;
                    ErrorManager.grammarWarning(162, this.dfa.nfa.grammar, null, this.dfa.nfa.grammar.name, delegatedTokensAlt.getChild(0).getText());
                }
            }
            if (!isInheritedTokensRule) {
                ErrorManager.unreachableAlts(this, unreachableAlts);
            }
        }
    }

    protected void stripWildCardAlts(Set<Integer> disabledAlts) {
        ArrayList<Integer> sortedDisableAlts = new ArrayList<Integer>(disabledAlts);
        Collections.sort(sortedDisableAlts);
        Integer lastAlt = (Integer)sortedDisableAlts.get(sortedDisableAlts.size() - 1);
        GrammarAST blockAST = this.dfa.nfa.grammar.getDecisionBlockAST(this.dfa.decisionNumber);
        GrammarAST lastAltAST = blockAST.getChild(0).getType() == 58 ? (GrammarAST)blockAST.getChild(lastAlt) : (GrammarAST)blockAST.getChild(lastAlt - 1);
        if (lastAltAST.getType() != 33 && lastAltAST.getChild(0).getType() == 98 && lastAltAST.getChild(1).getType() == 32) {
            disabledAlts.remove(lastAlt);
        }
    }

    protected void issueRecursionWarnings() {
        Set<Integer> dfaStatesWithRecursionProblems = this.stateToRecursionOverflowConfigurationsMap.keySet();
        HashMap<Integer, Map<String, Set<NFAState>>> altToTargetToCallSitesMap = new HashMap<Integer, Map<String, Set<NFAState>>>();
        HashMap<Integer, DFAState> altToDFAState = new HashMap<Integer, DFAState>();
        this.computeAltToProblemMaps(dfaStatesWithRecursionProblems, this.stateToRecursionOverflowConfigurationsMap, altToTargetToCallSitesMap, altToDFAState);
        Set alts = altToTargetToCallSitesMap.keySet();
        ArrayList sortedAlts = new ArrayList(alts);
        Collections.sort(sortedAlts);
        for (Integer altI : sortedAlts) {
            Map targetToCallSiteMap = (Map)altToTargetToCallSitesMap.get(altI);
            Set<String> targetRules = targetToCallSiteMap.keySet();
            Collection callSiteStates = targetToCallSiteMap.values();
            DFAState sampleBadState = (DFAState)altToDFAState.get(altI);
            ErrorManager.recursionOverflow(this, sampleBadState, altI, targetRules, callSiteStates);
        }
    }

    private void computeAltToProblemMaps(Set<Integer> dfaStatesUnaliased, Map<Integer, List<NFAConfiguration>> configurationsMap, Map<Integer, Map<String, Set<NFAState>>> altToTargetToCallSitesMap, Map<Integer, DFAState> altToDFAState) {
        for (Integer stateI : dfaStatesUnaliased) {
            List<NFAConfiguration> configs = configurationsMap.get(stateI);
            for (int i15 = 0; i15 < configs.size(); ++i15) {
                Set<NFAState> callSites;
                NFAConfiguration c15 = configs.get(i15);
                NFAState ruleInvocationState = this.dfa.nfa.getState(c15.state);
                Transition transition0 = ruleInvocationState.transition[0];
                RuleClosureTransition ref = (RuleClosureTransition)transition0;
                String targetRule = ((NFAState)ref.target).enclosingRule.name;
                Integer altI = Utils.integer(c15.alt);
                Map<String, Set<NFAState>> targetToCallSiteMap = altToTargetToCallSitesMap.get(altI);
                if (targetToCallSiteMap == null) {
                    targetToCallSiteMap = new HashMap<String, Set<NFAState>>();
                    altToTargetToCallSitesMap.put(altI, targetToCallSiteMap);
                }
                if ((callSites = targetToCallSiteMap.get(targetRule)) == null) {
                    callSites = new HashSet<NFAState>();
                    targetToCallSiteMap.put(targetRule, callSites);
                }
                callSites.add(ruleInvocationState);
                if (altToDFAState.get(altI) != null) continue;
                DFAState sampleBadState = this.dfa.getState(stateI);
                altToDFAState.put(altI, sampleBadState);
            }
        }
    }

    private Set<Integer> getUnaliasedDFAStateSet(Set<Integer> dfaStatesWithRecursionProblems) {
        HashSet<Integer> dfaStatesUnaliased = new HashSet<Integer>();
        for (Integer stateI : dfaStatesWithRecursionProblems) {
            DFAState d15 = this.dfa.getState(stateI);
            dfaStatesUnaliased.add(Utils.integer(d15.stateNumber));
        }
        return dfaStatesUnaliased;
    }

    public void reportDanglingState(DFAState d15) {
        this.danglingStates.add(d15);
    }

    public void reportNonLLStarDecision(DFA dfa) {
        this.nonLLStarDecision = true;
        ++dfa.nfa.grammar.numNonLLStar;
        this.altsWithProblem.addAll(dfa.recursiveAltSet.toList());
    }

    public void reportRecursionOverflow(DFAState d15, NFAConfiguration recursionNFAConfiguration) {
        if (d15.stateNumber > 0) {
            Integer stateI = Utils.integer(d15.stateNumber);
            this.stateToRecursionOverflowConfigurationsMap.map(stateI, recursionNFAConfiguration);
        }
    }

    public void reportNondeterminism(DFAState d15, Set<Integer> nondeterministicAlts) {
        this.altsWithProblem.addAll(nondeterministicAlts);
        this.statesWithSyntacticallyAmbiguousAltsSet.add(d15);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbers.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportLexerRuleNondeterminism(DFAState d15, Set<Integer> nondeterministicAlts) {
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap.put(d15, nondeterministicAlts);
    }

    public void reportNondeterminismResolvedWithSemanticPredicate(DFAState d15) {
        if (d15.abortedDueToRecursionOverflow) {
            d15.dfa.probe.removeRecursiveOverflowState(d15);
        }
        this.statesResolvedWithSemanticPredicatesSet.add(d15);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportAltPredicateContext(DFAState d15, Map<Integer, ? extends SemanticContext> altPredicateContext) {
        HashMap<Integer, ? extends SemanticContext> copy = new HashMap<Integer, SemanticContext>();
        copy.putAll(altPredicateContext);
        this.stateToAltSetWithSemanticPredicatesMap.put(d15, copy);
    }

    public void reportIncompletelyCoveredAlts(DFAState d15, Map<Integer, Set<Token>> altToLocationsReachableWithoutPredicate) {
        this.stateToIncompletelyCoveredAltsMap.put(d15, altToLocationsReachableWithoutPredicate);
    }

    protected boolean reachesState(DFAState startState, DFAState targetState, Set<DFAState> states) {
        if (startState == targetState) {
            states.add(targetState);
            this.stateReachable.put(startState.stateNumber, REACHABLE_YES);
            return true;
        }
        DFAState s15 = startState;
        this.stateReachable.put(s15.stateNumber, REACHABLE_BUSY);
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            Transition t15 = s15.transition(i15);
            DFAState edgeTarget = (DFAState)t15.target;
            Integer targetStatus = this.stateReachable.get(edgeTarget.stateNumber);
            if (targetStatus == REACHABLE_BUSY) continue;
            if (targetStatus == REACHABLE_YES) {
                this.stateReachable.put(s15.stateNumber, REACHABLE_YES);
                return true;
            }
            if (targetStatus == REACHABLE_NO || !this.reachesState(edgeTarget, targetState, states)) continue;
            states.add(s15);
            this.stateReachable.put(s15.stateNumber, REACHABLE_YES);
            return true;
        }
        this.stateReachable.put(s15.stateNumber, REACHABLE_NO);
        return false;
    }

    protected Set<DFAState> getDFAPathStatesToTarget(DFAState targetState) {
        HashSet<DFAState> dfaStates = new HashSet<DFAState>();
        this.stateReachable = new HashMap<Integer, Integer>();
        if (this.dfa == null || this.dfa.startState == null) {
            return dfaStates;
        }
        boolean reaches = this.reachesState(this.dfa.startState, targetState, dfaStates);
        return dfaStates;
    }

    protected void getSampleInputSequenceUsingStateSet(State startState, State targetState, Set<DFAState> states, List<Label> labels) {
        this.statesVisitedDuringSampleSequence.add(startState.stateNumber);
        for (int i15 = 0; i15 < startState.getNumberOfTransitions(); ++i15) {
            Transition t15 = startState.transition(i15);
            DFAState edgeTarget = (DFAState)t15.target;
            if (!states.contains(edgeTarget) || this.statesVisitedDuringSampleSequence.contains(edgeTarget.stateNumber)) continue;
            labels.add(t15.label);
            if (edgeTarget != targetState) {
                this.getSampleInputSequenceUsingStateSet(edgeTarget, targetState, states, labels);
            }
            return;
        }
        labels.add(new Label(-5));
    }

    protected boolean getNFAPath(NFAState s15, int labelIndex, List<? extends Label> labels, List<? super NFAState> path) {
        String thisStateKey = this.getStateLabelIndexKey(s15.stateNumber, labelIndex);
        if (this.statesVisitedAtInputDepth.contains(thisStateKey)) {
            return false;
        }
        this.statesVisitedAtInputDepth.add(thisStateKey);
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            boolean found;
            Transition t15 = s15.transition[i15];
            NFAState edgeTarget = (NFAState)t15.target;
            Label label = labels.get(labelIndex);
            if (t15.label.isEpsilon() || t15.label.isSemanticPredicate()) {
                path.add(edgeTarget);
                found = this.getNFAPath(edgeTarget, labelIndex, labels, path);
                if (found) {
                    this.statesVisitedAtInputDepth.remove(thisStateKey);
                    return true;
                }
                path.remove(path.size() - 1);
                continue;
            }
            if (!t15.label.matches(label)) continue;
            path.add(edgeTarget);
            if (labelIndex == labels.size() - 1) {
                this.statesVisitedAtInputDepth.remove(thisStateKey);
                return true;
            }
            found = this.getNFAPath(edgeTarget, labelIndex + 1, labels, path);
            if (found) {
                this.statesVisitedAtInputDepth.remove(thisStateKey);
                return true;
            }
            path.remove(path.size() - 1);
        }
        this.statesVisitedAtInputDepth.remove(thisStateKey);
        return false;
    }

    protected String getStateLabelIndexKey(int s15, int i15) {
        StringBuilder buf = new StringBuilder();
        buf.append(s15);
        buf.append('_');
        buf.append(i15);
        return buf.toString();
    }

    public String getTokenNameForTokensRuleAlt(int alt) {
        NFAState decisionState = this.dfa.getNFADecisionStartState();
        NFAState altState = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(decisionState, alt);
        NFAState decisionLeft = (NFAState)altState.transition[0].target;
        RuleClosureTransition ruleCallEdge = (RuleClosureTransition)decisionLeft.transition[0];
        NFAState ruleStartState = (NFAState)ruleCallEdge.target;
        return ruleStartState.enclosingRule.name;
    }

    public void reset() {
        this.stateToRecursionOverflowConfigurationsMap.clear();
    }
}

