/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.kotlin.metadata.utils;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import jadx.plugins.kotlin.metadata.model.ClassAliasRename;
import jadx.plugins.kotlin.metadata.model.CompanionRename;
import jadx.plugins.kotlin.metadata.model.FieldRename;
import jadx.plugins.kotlin.metadata.model.MethodArgRename;
import jadx.plugins.kotlin.metadata.utils.KotlinMetadataExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmValueParameter;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmFieldSignature;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001d"}, d2={"Ljadx/plugins/kotlin/metadata/utils/KotlinMetadataUtils;", "", "<init>", "()V", "getAlias", "Ljadx/plugins/kotlin/metadata/model/ClassAliasRename;", "cls", "Ljadx/core/dex/nodes/ClassNode;", "getClassAlias", "annotation", "Lkotlin/Metadata;", "splitAndCheckClsName", "originCls", "fullClsName", "", "countPkgParts", "", "pkg", "mapMethodArgs", "", "Ljadx/core/dex/nodes/MethodNode;", "", "Ljadx/plugins/kotlin/metadata/model/MethodArgRename;", "kmCls", "Lkotlin/metadata/KmClass;", "mapFields", "Ljadx/plugins/kotlin/metadata/model/FieldRename;", "mapCompanion", "Ljadx/plugins/kotlin/metadata/model/CompanionRename;", "jadx-kotlin-metadata"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataUtils.kt\njadx/plugins/kotlin/metadata/utils/KotlinMetadataUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LogExt.kt\njadx/plugins/kotlin/metadata/utils/LogExtKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KmExt.kt\njadx/plugins/kotlin/metadata/utils/KmExtKt\n*L\n1#1,143:1\n1#2:144\n1#2:165\n6#3:145\n1915#4:146\n1586#4:148\n1661#4,3:149\n1916#4:152\n1642#4,10:153\n1915#4:163\n1916#4:166\n1652#4:167\n296#4,2:168\n296#4,2:170\n1786#4,3:172\n8#5:147\n10#5:164\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataUtils.kt\njadx/plugins/kotlin/metadata/utils/KotlinMetadataUtils\n*L\n112#1:165\n40#1:145\n95#1:146\n102#1:148\n102#1:149,3\n95#1:152\n112#1:153,10\n112#1:163\n112#1:166\n112#1:167\n120#1:168,2\n126#1:170,2\n131#1:172,3\n96#1:147\n113#1:164\n*E\n"})
public final class KotlinMetadataUtils {
    @NotNull
    public static final KotlinMetadataUtils INSTANCE = new KotlinMetadataUtils();

    private KotlinMetadataUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassAliasRename getAlias(@NotNull ClassNode cls) {
        Intrinsics.checkNotNullParameter(cls, "cls");
        Metadata metadata = KotlinMetadataExtKt.getMetadata(cls);
        if (metadata == null) {
            return null;
        }
        Metadata annotation = metadata;
        return INSTANCE.getClassAlias(cls, annotation);
    }

    private final ClassAliasRename getClassAlias(ClassNode cls, Metadata annotation) {
        String string = ArraysKt.getOrNull(annotation.d2(), 0);
        if (string == null) {
            return null;
        }
        String firstValue = string;
        try {
            String string2;
            block9: {
                block8: {
                    String string3;
                    String p05 = string2 = ((Object)StringsKt.trim((CharSequence)firstValue)).toString();
                    boolean bl4 = false;
                    String string4 = string3 = !(((CharSequence)p05).length() == 0) ? string2 : null;
                    if (string3 == null) break block8;
                    String p06 = string3;
                    boolean bl5 = false;
                    string2 = Utils.cleanObjectName(p06);
                    if (string2 != null) break block9;
                }
                return null;
            }
            String clsName = string2;
            ClassAliasRename alias = this.splitAndCheckClsName(cls, clsName);
            if (alias != null) {
                RenameReasonAttr.forNode(cls).append("from Kotlin metadata");
                return alias;
            }
        }
        catch (Exception e15) {
            KotlinMetadataUtils $this$LOG$iv = this;
            boolean $i$f$getLOG = false;
            Logger logger = LoggerFactory.getLogger(KotlinMetadataUtils.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
            logger.error("Failed to parse kotlin metadata", e15);
        }
        return null;
    }

    private final ClassAliasRename splitAndCheckClsName(ClassNode originCls, String fullClsName) {
        String name;
        String pkg;
        block7: {
            block6: {
                if (!NameMapper.isValidFullIdentifier(fullClsName)) {
                    return null;
                }
                pkg = null;
                name = null;
                int dot = StringsKt.lastIndexOf$default((CharSequence)fullClsName, '.', 0, false, 6, null);
                if (dot == -1) {
                    pkg = "";
                    name = fullClsName;
                } else {
                    String string = fullClsName.substring(0, dot);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    pkg = string;
                    String string2 = fullClsName.substring(dot + 1);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    name = string2;
                }
                ClassInfo originClsInfo = originCls.getClassInfo();
                String originName = originClsInfo.getShortName();
                if (Intrinsics.areEqual(originName, name) || StringsKt.contains$default((CharSequence)name, "$", false, 2, null) || !NameMapper.isValidIdentifier(name)) break block6;
                String string = originClsInfo.getPackage();
                Intrinsics.checkNotNullExpressionValue(string, "getPackage(...)");
                if (this.countPkgParts(string) == this.countPkgParts(pkg) && !StringsKt.startsWith$default(pkg, "java.", false, 2, null)) break block7;
            }
            return null;
        }
        ClassNode newClsNode = originCls.root().resolveClass(fullClsName);
        return newClsNode != null ? null : new ClassAliasRename(pkg, name);
    }

    private final int countPkgParts(String pkg) {
        if (((CharSequence)pkg).length() == 0) {
            return 0;
        }
        int count = 1;
        int pos = 0;
        while ((pos = StringsKt.indexOf$default((CharSequence)pkg, '.', pos, false, 4, null)) != -1) {
            ++pos;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<MethodNode, List<MethodArgRename>> mapMethodArgs(@NotNull ClassNode cls, @NotNull KmClass kmCls) {
        Map<MethodNode, List> map;
        Intrinsics.checkNotNullParameter(cls, "cls");
        Intrinsics.checkNotNullParameter(kmCls, "kmCls");
        Map<MethodNode, List> $this$mapMethodArgs_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl4 = false;
        Iterable $this$forEach$iv = kmCls.getFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            int paramCount;
            MethodNode node;
            int argCount;
            KmFunction kmFunction = (KmFunction)element$iv;
            boolean bl5 = false;
            KmFunction $this$shortId$iv = kmFunction;
            boolean $i$f$getShortId = false;
            JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature($this$shortId$iv);
            if (cls.searchMethodByShortId(jvmMethodSignature != null ? jvmMethodSignature.toString() : null) == null || (argCount = node.getArgTypes().size()) != (paramCount = kmFunction.getValueParameters().size())) continue;
            List<RegisterArg> list2 = node.getArgRegs();
            Intrinsics.checkNotNullExpressionValue(list2, "getArgRegs(...)");
            Iterable $this$map$iv = CollectionsKt.zip((Iterable)list2, (Iterable)kmFunction.getValueParameters());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                RegisterArg rArg = (RegisterArg)pair.component1();
                KmValueParameter kmValueParameter = (KmValueParameter)pair.component2();
                Intrinsics.checkNotNull(rArg);
                collection.add(new MethodArgRename(rArg, kmValueParameter.getName()));
            }
            List aliasList = (List)destination$iv$iv;
            $this$mapMethodArgs_u24lambda_u240.put(node, aliasList);
        }
        return MapsKt.build(map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FieldRename> mapFields(@NotNull ClassNode cls, @NotNull KmClass kmCls) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(cls, "cls");
        Intrinsics.checkNotNullParameter(kmCls, "kmCls");
        Iterable $this$mapNotNull$iv = kmCls.getProperties();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FieldRename it$iv$iv;
            FieldNode node;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            KmProperty kmProperty = (KmProperty)element$iv$iv;
            boolean bl5 = false;
            KmProperty $this$shortId$iv = kmProperty;
            boolean $i$f$getShortId = false;
            JvmFieldSignature jvmFieldSignature = JvmExtensionsKt.getFieldSignature($this$shortId$iv);
            if ((cls.searchFieldByShortId(jvmFieldSignature != null ? jvmFieldSignature.toString() : null) == null ? null : new FieldRename(node, kmProperty.getName())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final CompanionRename mapCompanion(@NotNull ClassNode cls, @NotNull KmClass kmCls) {
        block11: {
            Intrinsics.checkNotNullParameter(cls, "cls");
            Intrinsics.checkNotNullParameter(kmCls, "kmCls");
            v0 = kmCls.getCompanionObject();
            if (v0 == null) {
                return null;
            }
            compName = v0;
            v1 = cls.getFields();
            Intrinsics.checkNotNullExpressionValue(v1, "getFields(...)");
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (FieldNode)element$iv;
                $i$a$-firstOrNull-KotlinMetadataUtils$mapCompanion$compField$1 = false;
                if (!Intrinsics.areEqual(it.getName(), compName)) ** GOTO lbl-1000
                $this$mapCompanion_u24lambda_u240_u240 = it.getAccessFlags();
                $i$a$-run-KotlinMetadataUtils$mapCompanion$compField$1$1 = false;
                v2 = $this$mapCompanion_u24lambda_u240_u240.isStatic() && $this$mapCompanion_u24lambda_u240_u240.isFinal() && $this$mapCompanion_u24lambda_u240_u240.isPublic();
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                v4 = element$iv;
                break block11;
            }
            v4 = null;
        }
        v5 = v4;
        if (v5 == null) {
            return null;
        }
        compField = v5;
        if (compField.getType().isObject()) {
            block13: {
                block12: {
                    compType = compField.getType().getObject();
                    v6 = cls.getInnerClasses();
                    Intrinsics.checkNotNullExpressionValue(v6, "getInnerClasses(...)");
                    $this$firstOrNull$iv = v6;
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (ClassNode)element$iv;
                        $i$a$-firstOrNull-KotlinMetadataUtils$mapCompanion$compCls$1 = false;
                        if (!Intrinsics.areEqual(it.getClassInfo().makeRawFullName(), compType)) continue;
                        v7 = element$iv;
                        break block12;
                    }
                    v7 = null;
                }
                v8 = v7;
                if (v8 == null) {
                    return null;
                }
                compCls = v8;
                isOnlyInit = compField.getUseIn().size() == 1 && compField.getUseIn().get(0).getMethodInfo().isClassInit() != false;
                $this$mapCompanion_u24lambda_u242 = compCls;
                $i$a$-run-KotlinMetadataUtils$mapCompanion$isEmpty$1 = false;
                v9 = $this$mapCompanion_u24lambda_u242.getMethods();
                Intrinsics.checkNotNullExpressionValue(v9, "getMethods(...)");
                $this$all$iv = v9;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v10 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (MethodNode)element$iv;
                        $i$a$-all-KotlinMetadataUtils$mapCompanion$isEmpty$1$1 = false;
                        if (it.isConstructor()) continue;
                        v10 = false;
                        break block13;
                    }
                    v10 = true;
                }
            }
            isEmpty = v10 && $this$mapCompanion_u24lambda_u242.getFields().isEmpty();
            return new CompanionRename(compField, compCls, isOnlyInit != false && isEmpty != false);
        }
        return null;
    }
}

