/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.mods;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.InsnUtils;
import java.util.Collection;
import java.util.function.Consumer;

public final class TernaryInsn
extends InsnNode {
    private IfCondition condition;

    public TernaryInsn(IfCondition condition2, RegisterArg result, InsnArg th4, InsnArg els) {
        this();
        this.setResult(result);
        if (th4.isFalse() && els.isTrue()) {
            this.condition = IfCondition.invert(condition2);
            this.addArg(els);
            this.addArg(th4);
        } else {
            this.condition = condition2;
            this.addArg(th4);
            this.addArg(els);
        }
        this.visitInsns(this::inheritMetadata);
    }

    private TernaryInsn() {
        super(InsnType.TERNARY, 2);
    }

    public IfCondition getCondition() {
        return this.condition;
    }

    public void simplifyCondition() {
        this.condition = IfCondition.simplify(this.condition);
        if (this.condition.getMode() == IfCondition.Mode.NOT) {
            this.invert();
        }
    }

    private void invert() {
        this.condition = IfCondition.invert(this.condition);
        InsnArg tmp = this.getArg(0);
        this.setArg(0, this.getArg(1));
        this.setArg(1, tmp);
    }

    @Override
    public void getRegisterArgs(Collection<RegisterArg> list2) {
        super.getRegisterArgs(list2);
        list2.addAll(this.condition.getRegisterArgs());
    }

    @Override
    public boolean replaceArg(InsnArg from, InsnArg to4) {
        if (super.replaceArg(from, to4)) {
            return true;
        }
        return this.condition.replaceArg(from, to4);
    }

    @Override
    public void visitInsns(Consumer<InsnNode> visitor2) {
        super.visitInsns(visitor2);
        this.condition.visitInsns(visitor2);
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TernaryInsn) || !super.isSame(obj)) {
            return false;
        }
        TernaryInsn that = (TernaryInsn)obj;
        return this.condition.equals(that.condition);
    }

    @Override
    public InsnNode copy() {
        TernaryInsn copy = new TernaryInsn();
        copy.condition = this.condition;
        return this.copyCommonParams(copy);
    }

    @Override
    public void rebindArgs() {
        super.rebindArgs();
        for (RegisterArg reg : this.condition.getRegisterArgs()) {
            InsnNode parentInsn = reg.getParentInsn();
            if (parentInsn == null) continue;
            parentInsn.rebindArgs();
        }
    }

    @Override
    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": TERNARY " + String.valueOf(this.getResult()) + " = (" + String.valueOf(this.condition) + ") ? " + String.valueOf(this.getArg(0)) + " : " + String.valueOf(this.getArg(1));
    }
}

