/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Timed<T> {
    final T value;
    final long time;
    final TimeUnit unit;

    public Timed(@NonNull T value, long time, @NonNull TimeUnit unit) {
        this.value = Objects.requireNonNull(value, "value is null");
        this.time = time;
        this.unit = Objects.requireNonNull(unit, "unit is null");
    }

    @NonNull
    public T value() {
        return this.value;
    }

    @NonNull
    public TimeUnit unit() {
        return this.unit;
    }

    public long time() {
        return this.time;
    }

    public long time(@NonNull TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public boolean equals(Object other) {
        if (other instanceof Timed) {
            Timed o15 = (Timed)other;
            return Objects.equals(this.value, o15.value) && this.time == o15.time && Objects.equals((Object)this.unit, (Object)o15.unit);
        }
        return false;
    }

    public int hashCode() {
        int h15 = this.value.hashCode();
        h15 = h15 * 31 + (int)(this.time >>> 31 ^ this.time);
        h15 = h15 * 31 + this.unit.hashCode();
        return h15;
    }

    public String toString() {
        return "Timed[time=" + this.time + ", unit=" + (Object)((Object)this.unit) + ", value=" + this.value + "]";
    }
}

