/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class BasicFuseableSubscriber<T, R>
implements FlowableSubscriber<T>,
QueueSubscription<R> {
    protected final Subscriber<? super R> downstream;
    protected Subscription upstream;
    protected QueueSubscription<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableSubscriber(Subscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            if (s15 instanceof QueueSubscription) {
                this.qs = (QueueSubscription)s15;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t15) {
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        this.downstream.onError(t15);
    }

    protected final void fail(Throwable t15) {
        Exceptions.throwIfFatal(t15);
        this.upstream.cancel();
        this.onError(t15);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueSubscription<T> qs4 = this.qs;
        if (qs4 != null && (mode & 4) == 0) {
            int m15 = qs4.requestFusion(mode);
            if (m15 != 0) {
                this.sourceMode = m15;
            }
            return m15;
        }
        return 0;
    }

    @Override
    public void request(long n15) {
        this.upstream.request(n15);
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public final boolean offer(R e15) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v15, R v25) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

