/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelPeek<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;

    public ParallelPeek(ParallelFlowable<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminated, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.source = source;
        this.onNext = Objects.requireNonNull(onNext, "onNext is null");
        this.onAfterNext = Objects.requireNonNull(onAfterNext, "onAfterNext is null");
        this.onError = Objects.requireNonNull(onError, "onError is null");
        this.onComplete = Objects.requireNonNull(onComplete, "onComplete is null");
        this.onAfterTerminated = Objects.requireNonNull(onAfterTerminated, "onAfterTerminated is null");
        this.onSubscribe = Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        this.onRequest = Objects.requireNonNull(onRequest, "onRequest is null");
        this.onCancel = Objects.requireNonNull(onCancel, "onCancel is null");
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            parents[i15] = new ParallelPeekSubscriber<T>(subscribers[i15], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelPeekSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final ParallelPeek<T> parent;
        Subscription upstream;
        boolean done;

        ParallelPeekSubscriber(Subscriber<? super T> actual, ParallelPeek<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n15) {
            try {
                this.parent.onRequest.accept(n15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            try {
                this.parent.onCancel.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                try {
                    this.parent.onSubscribe.accept(s15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    s15.cancel();
                    this.downstream.onSubscribe(EmptySubscription.INSTANCE);
                    this.onError(ex4);
                    return;
                }
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (!this.done) {
                try {
                    this.parent.onNext.accept(t15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.onError(ex4);
                    return;
                }
                this.downstream.onNext(t15);
                try {
                    this.parent.onAfterNext.accept(t15);
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    this.onError(ex5);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            try {
                this.parent.onError.accept(t15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                t15 = new CompositeException(t15, ex4);
            }
            this.downstream.onError(t15);
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex5) {
                Exceptions.throwIfFatal(ex5);
                RxJavaPlugins.onError(ex5);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                try {
                    this.parent.onComplete.run();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.downstream.onError(ex4);
                    return;
                }
                this.downstream.onComplete();
                try {
                    this.parent.onAfterTerminated.run();
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    RxJavaPlugins.onError(ex5);
                }
            }
        }
    }
}

