/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.schedulers.TrampolineScheduler;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableIntervalRange
extends Flowable<Long> {
    final Scheduler scheduler;
    final long start;
    final long end;
    final long initialDelay;
    final long period;
    final TimeUnit unit;

    public FlowableIntervalRange(long start, long end, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.start = start;
        this.end = end;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s15) {
        IntervalRangeSubscriber is4 = new IntervalRangeSubscriber(s15, this.start, this.end);
        s15.onSubscribe(is4);
        Scheduler sch = this.scheduler;
        if (sch instanceof TrampolineScheduler) {
            Scheduler.Worker worker = sch.createWorker();
            is4.setResource(worker);
            worker.schedulePeriodically(is4, this.initialDelay, this.period, this.unit);
        } else {
            Disposable d15 = sch.schedulePeriodicallyDirect(is4, this.initialDelay, this.period, this.unit);
            is4.setResource(d15);
        }
    }

    static final class IntervalRangeSubscriber
    extends AtomicLong
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -2809475196591179431L;
        final Subscriber<? super Long> downstream;
        final long end;
        long count;
        final AtomicReference<Disposable> resource = new AtomicReference();

        IntervalRangeSubscriber(Subscriber<? super Long> actual, long start, long end) {
            this.downstream = actual;
            this.count = start;
            this.end = end;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this, n15);
            }
        }

        @Override
        public void cancel() {
            DisposableHelper.dispose(this.resource);
        }

        @Override
        public void run() {
            if (this.resource.get() != DisposableHelper.DISPOSED) {
                long r15 = this.get();
                if (r15 != 0L) {
                    long c15 = this.count;
                    this.downstream.onNext((Long)c15);
                    if (c15 == this.end) {
                        if (this.resource.get() != DisposableHelper.DISPOSED) {
                            this.downstream.onComplete();
                        }
                        DisposableHelper.dispose(this.resource);
                        return;
                    }
                    this.count = c15 + 1L;
                    if (r15 != Long.MAX_VALUE) {
                        this.decrementAndGet();
                    }
                } else {
                    this.downstream.onError(new MissingBackpressureException("Could not emit value " + this.count + " due to lack of requests"));
                    DisposableHelper.dispose(this.resource);
                }
            }
        }

        public void setResource(Disposable d15) {
            DisposableHelper.setOnce(this.resource, d15);
        }
    }
}

