/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.flowables.GroupedFlowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.EmptyComponent;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableGroupBy<T, K, V>
extends AbstractFlowableWithUpstream<T, GroupedFlowable<K, V>> {
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Function<? super Consumer<Object>, ? extends Map<K, Object>> mapFactory;

    public FlowableGroupBy(Flowable<T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Function<? super Consumer<Object>, ? extends Map<K, Object>> mapFactory) {
        super(source);
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.mapFactory = mapFactory;
    }

    @Override
    protected void subscribeActual(Subscriber<? super GroupedFlowable<K, V>> s15) {
        ConcurrentHashMap groups2;
        ConcurrentLinkedQueue evictedGroups;
        try {
            if (this.mapFactory == null) {
                evictedGroups = null;
                groups2 = new ConcurrentHashMap();
            } else {
                evictedGroups = new ConcurrentLinkedQueue();
                EvictionAction evictionAction = new EvictionAction(evictedGroups);
                groups2 = this.mapFactory.apply(evictionAction);
            }
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            s15.onSubscribe(EmptyComponent.INSTANCE);
            s15.onError(e15);
            return;
        }
        GroupBySubscriber<? super T, ? extends K, ? extends V> subscriber = new GroupBySubscriber<T, K, V>(s15, this.keySelector, this.valueSelector, this.bufferSize, this.delayError, groups2, evictedGroups);
        this.source.subscribe(subscriber);
    }

    static final class State<T, K>
    extends BasicIntQueueSubscription<T>
    implements Publisher<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final SpscLinkedArrayQueue<T> queue;
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        final AtomicLong requested = new AtomicLong();
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicReference<Subscriber<? super T>> actual = new AtomicReference();
        boolean outputFused;
        int produced;
        final AtomicInteger once = new AtomicInteger();
        static final int FRESH = 0;
        static final int HAS_SUBSCRIBER = 1;
        static final int ABANDONED = 2;
        static final int ABANDONED_HAS_SUBSCRIBER = 3;
        final AtomicBoolean evictOnce = new AtomicBoolean();

        State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key, boolean delayError) {
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.cancelParent();
                this.drain();
            }
        }

        @Override
        public void subscribe(Subscriber<? super T> subscriber) {
            int s15;
            while (((s15 = this.once.get()) & 1) == 0) {
                int u15 = s15 | 1;
                if (!this.once.compareAndSet(s15, u15)) continue;
                subscriber.onSubscribe(this);
                this.actual.lazySet(subscriber);
                if (this.cancelled.get()) {
                    this.actual.lazySet(null);
                } else {
                    this.drain();
                }
                return;
            }
            EmptySubscription.error(new IllegalStateException("Only one Subscriber allowed!"), subscriber);
        }

        public void onNext(T t15) {
            this.queue.offer(t15);
            this.drain();
        }

        public void onError(Throwable e15) {
            this.error = e15;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        boolean tryComplete() {
            boolean canEvict = this.evictOnce.compareAndSet(false, true);
            this.done = true;
            this.drain();
            return canEvict;
        }

        void cancelParent() {
            if ((this.once.get() & 2) == 0 && this.evictOnce.compareAndSet(false, true)) {
                this.parent.cancel(this.key);
            }
        }

        boolean tryAbandon() {
            return this.once.get() == 0 && this.once.compareAndSet(0, 2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }

        void drainFused() {
            int missed = 1;
            SpscLinkedArrayQueue<T> q15 = this.queue;
            Subscriber<T> a15 = this.actual.get();
            while (true) {
                if (a15 != null) {
                    Throwable ex4;
                    if (this.cancelled.get()) {
                        return;
                    }
                    boolean d15 = this.done;
                    if (d15 && !this.delayError && (ex4 = this.error) != null) {
                        q15.clear();
                        a15.onError(ex4);
                        return;
                    }
                    a15.onNext(null);
                    if (d15) {
                        ex4 = this.error;
                        if (ex4 != null) {
                            a15.onError(ex4);
                        } else {
                            a15.onComplete();
                        }
                        return;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) {
                    return;
                }
                if (a15 != null) continue;
                a15 = this.actual.get();
            }
        }

        void drainNormal() {
            int missed = 1;
            SpscLinkedArrayQueue<T> q15 = this.queue;
            boolean delayError = this.delayError;
            Subscriber<T> a15 = this.actual.get();
            AtomicBoolean cancelled = this.cancelled;
            block0: while (true) {
                if (cancelled.get()) {
                    this.cleanupQueue(0L, false);
                } else if (a15 != null) {
                    long e15;
                    long r15 = this.requested.get();
                    for (e15 = 0L; e15 != r15; ++e15) {
                        boolean d15 = this.done;
                        T v15 = q15.poll();
                        boolean empty = v15 == null;
                        if (this.checkTerminated(d15, empty, a15, delayError, e15, !empty)) continue block0;
                        if (empty) break;
                        a15.onNext(v15);
                    }
                    if (e15 == r15 && this.checkTerminated(this.done, q15.isEmpty(), a15, delayError, e15, false)) continue;
                    if (e15 != 0L) {
                        BackpressureHelper.produced(this.requested, e15);
                        this.requestParent(e15);
                    }
                }
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                if (a15 != null) continue;
                a15 = this.actual.get();
            }
        }

        void requestParent(long e15) {
            if ((this.once.get() & 2) == 0) {
                this.parent.requestGroup(e15);
            }
        }

        void cleanupQueue(long emitted, boolean polled) {
            while (this.queue.poll() != null) {
                ++emitted;
            }
            this.replenishParent(emitted, polled);
        }

        void replenishParent(long emitted, boolean polled) {
            if (polled) {
                ++emitted;
            }
            if (emitted != 0L) {
                this.requestParent(emitted);
            }
        }

        boolean checkTerminated(boolean d15, boolean empty, Subscriber<? super T> a15, boolean delayError, long emitted, boolean polled) {
            if (this.cancelled.get()) {
                this.cleanupQueue(emitted, polled);
                return true;
            }
            if (d15) {
                if (delayError) {
                    if (empty) {
                        this.cancelled.lazySet(true);
                        Throwable e15 = this.error;
                        if (e15 != null) {
                            a15.onError(e15);
                        } else {
                            a15.onComplete();
                            this.replenishParent(emitted, polled);
                        }
                        return true;
                    }
                } else {
                    Throwable e16 = this.error;
                    if (e16 != null) {
                        this.queue.clear();
                        this.cancelled.lazySet(true);
                        a15.onError(e16);
                        return true;
                    }
                    if (empty) {
                        this.cancelled.lazySet(true);
                        a15.onComplete();
                        this.replenishParent(emitted, polled);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            return 0;
        }

        void tryReplenish() {
            int p15 = this.produced;
            if (p15 != 0) {
                this.produced = 0;
                this.requestParent(p15);
            }
        }

        @Override
        @Nullable
        public T poll() {
            T v15 = this.queue.poll();
            if (v15 != null) {
                ++this.produced;
                return v15;
            }
            this.tryReplenish();
            return null;
        }

        @Override
        public boolean isEmpty() {
            if (this.queue.isEmpty()) {
                this.tryReplenish();
                return true;
            }
            this.tryReplenish();
            return false;
        }

        @Override
        public void clear() {
            SpscLinkedArrayQueue<T> q15 = this.queue;
            while (q15.poll() != null) {
                ++this.produced;
            }
            this.tryReplenish();
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedFlowable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new GroupedUnicast<K, T>(key, state);
        }

        protected GroupedUnicast(K key, State<T, K> state) {
            super(key);
            this.state = state;
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s15) {
            this.state.subscribe(s15);
        }

        public void onNext(T t15) {
            this.state.onNext(t15);
        }

        public void onError(Throwable e15) {
            this.state.onError(e15);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    static final class EvictionAction<K, V>
    implements Consumer<GroupedUnicast<K, V>> {
        final Queue<GroupedUnicast<K, V>> evictedGroups;

        EvictionAction(Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void accept(GroupedUnicast<K, V> value) {
            this.evictedGroups.offer(value);
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3688291656102519502L;
        final Subscriber<? super GroupedFlowable<K, V>> downstream;
        final Function<? super T, ? extends K> keySelector;
        final Function<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final int limit;
        final boolean delayError;
        final Map<Object, GroupedUnicast<K, V>> groups;
        final Queue<GroupedUnicast<K, V>> evictedGroups;
        static final Object NULL_KEY = new Object();
        Subscription upstream;
        final AtomicBoolean cancelled = new AtomicBoolean();
        long emittedGroups;
        final AtomicInteger groupCount = new AtomicInteger(1);
        final AtomicLong groupConsumed = new AtomicLong();
        boolean done;

        public GroupBySubscriber(Subscriber<? super GroupedFlowable<K, V>> actual, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Map<Object, GroupedUnicast<K, V>> groups2, Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.downstream = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.delayError = delayError;
            this.groups = groups2;
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t15) {
            V v15;
            K key;
            if (this.done) {
                return;
            }
            try {
                key = this.keySelector.apply(t15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.cancel();
                this.onError(ex4);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key != null ? key : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.cancelled.get()) {
                    return;
                }
                group = GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
                this.groups.put(mapKey, group);
                this.groupCount.getAndIncrement();
                newGroup = true;
            }
            try {
                v15 = ExceptionHelper.nullCheck(this.valueSelector.apply(t15), "The valueSelector returned a null value.");
            }
            catch (Throwable ex5) {
                Exceptions.throwIfFatal(ex5);
                this.upstream.cancel();
                if (newGroup) {
                    if (this.emittedGroups != this.get()) {
                        this.downstream.onNext(group);
                    } else {
                        MissingBackpressureException mbe = GroupBySubscriber.groupHangWarning(this.emittedGroups);
                        mbe.initCause(ex5);
                        this.onError(mbe);
                        return;
                    }
                }
                this.onError(ex5);
                return;
            }
            group.onNext(v15);
            this.completeEvictions();
            if (newGroup) {
                if (this.emittedGroups != this.get()) {
                    ++this.emittedGroups;
                    this.downstream.onNext(group);
                    if (group.state.tryAbandon()) {
                        this.cancel(key);
                        group.onComplete();
                        this.requestGroup(1L);
                    }
                } else {
                    this.upstream.cancel();
                    this.onError(GroupBySubscriber.groupHangWarning(this.emittedGroups));
                }
            }
        }

        static MissingBackpressureException groupHangWarning(long n15) {
            return new MissingBackpressureException("Unable to emit a new group (#" + n15 + ") due to lack of requests. Please make sure the downstream can always accept a new group as well as each group is consumed in order for the whole operator to be able to proceed.");
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            for (GroupedUnicast<K, V> g15 : this.groups.values()) {
                g15.onError(t15);
            }
            this.groups.clear();
            this.completeEvictions();
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                for (GroupedUnicast<K, V> g15 : this.groups.values()) {
                    g15.onComplete();
                }
                this.groups.clear();
                this.completeEvictions();
                this.done = true;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this, n15);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.completeEvictions();
                if (this.groupCount.decrementAndGet() == 0) {
                    this.upstream.cancel();
                }
            }
        }

        private void completeEvictions() {
            if (this.evictedGroups != null) {
                GroupedUnicast<K, V> evictedGroup;
                int count = 0;
                while ((evictedGroup = this.evictedGroups.poll()) != null) {
                    if (!evictedGroup.state.tryComplete()) continue;
                    ++count;
                }
                if (count != 0) {
                    this.groupCount.addAndGet(-count);
                }
            }
        }

        public void cancel(K key) {
            Object mapKey;
            Object object = mapKey = key != null ? key : NULL_KEY;
            if (this.groups.remove(mapKey) != null && this.groupCount.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }

        void requestGroup(long n15) {
            long newConsumed;
            long currentConsumed;
            AtomicLong groupConsumed = this.groupConsumed;
            int limit = this.limit;
            while (!groupConsumed.compareAndSet(currentConsumed = groupConsumed.get(), newConsumed = BackpressureHelper.addCap(currentConsumed, n15))) {
            }
            while (newConsumed >= (long)limit) {
                long newConsumedAfterLimit = newConsumed - (long)limit;
                if (groupConsumed.compareAndSet(newConsumed, newConsumedAfterLimit)) {
                    this.upstream.request(limit);
                }
                newConsumed = groupConsumed.get();
            }
            return;
        }
    }
}

