/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SafeCompletableObserver
implements CompletableObserver {
    final CompletableObserver downstream;
    boolean onSubscribeFailed;

    public SafeCompletableObserver(CompletableObserver downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        try {
            this.downstream.onSubscribe(d15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            this.onSubscribeFailed = true;
            d15.dispose();
            RxJavaPlugins.onError(ex4);
        }
    }

    @Override
    public void onError(@NonNull Throwable e15) {
        if (this.onSubscribeFailed) {
            RxJavaPlugins.onError(e15);
        } else {
            try {
                this.downstream.onError(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(new CompositeException(e15, ex4));
            }
        }
    }

    @Override
    public void onComplete() {
        if (!this.onSubscribeFailed) {
            try {
                this.downstream.onComplete();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

