/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFailureHandling;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelMapTryOptional<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, Optional<? extends R>> mapper;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelMapTryOptional(ParallelFlowable<T> source, Function<? super T, Optional<? extends R>> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.mapper = mapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            Subscriber<R> a15 = subscribers[i15];
            parents[i15] = a15 instanceof ConditionalSubscriber ? new ParallelMapTryConditionalSubscriber<T, R>((ConditionalSubscriber)a15, this.mapper, this.errorHandler) : new ParallelMapTrySubscriber<T, R>(a15, this.mapper, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelMapTryConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelMapTryConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, Optional<? extends R>> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15) && !this.done) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            Optional<R> v15;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Optional");
                }
                catch (Throwable ex4) {
                    ParallelFailureHandling h15;
                    Exceptions.throwIfFatal(ex4);
                    try {
                        h15 = Objects.requireNonNull(this.errorHandler.apply((Long)(++retries), ex4), "The errorHandler returned a null ParallelFailureHandling");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex4, exc));
                        return false;
                    }
                    switch (h15) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex4);
                    return false;
                }
                break;
            }
            return v15.isPresent() && this.downstream.tryOnNext(v15.get());
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }

    static final class ParallelMapTrySubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelMapTrySubscriber(Subscriber<? super R> actual, Function<? super T, Optional<? extends R>> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15) && !this.done) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            Optional<R> v15;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Optional");
                }
                catch (Throwable ex4) {
                    ParallelFailureHandling h15;
                    Exceptions.throwIfFatal(ex4);
                    try {
                        h15 = Objects.requireNonNull(this.errorHandler.apply((Long)(++retries), ex4), "The errorHandler returned a null ParallelFailureHandling");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex4, exc));
                        return false;
                    }
                    switch (h15) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex4);
                    return false;
                }
                break;
            }
            if (v15.isPresent()) {
                this.downstream.onNext(v15.get());
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

