/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum DisposableHelper implements Disposable
{
    DISPOSED;


    public static boolean isDisposed(Disposable d15) {
        return d15 == DISPOSED;
    }

    public static boolean set(AtomicReference<Disposable> field, Disposable d15) {
        Disposable current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d15 != null) {
                d15.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d15));
        if (current != null) {
            current.dispose();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Disposable> field, Disposable d15) {
        Objects.requireNonNull(d15, "d is null");
        if (!field.compareAndSet(null, d15)) {
            d15.dispose();
            if (field.get() != DISPOSED) {
                DisposableHelper.reportDisposableSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Disposable> field, Disposable d15) {
        Disposable current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d15 != null) {
                d15.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d15));
        return true;
    }

    public static boolean dispose(AtomicReference<Disposable> field) {
        DisposableHelper d15;
        Disposable current = field.get();
        if (current != (d15 = DISPOSED) && (current = field.getAndSet(d15)) != d15) {
            if (current != null) {
                current.dispose();
            }
            return true;
        }
        return false;
    }

    public static boolean validate(Disposable current, Disposable next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.dispose();
            DisposableHelper.reportDisposableSet();
            return false;
        }
        return true;
    }

    public static void reportDisposableSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Disposable already set!"));
    }

    public static boolean trySet(AtomicReference<Disposable> field, Disposable d15) {
        if (!field.compareAndSet(null, d15)) {
            if (field.get() == DISPOSED) {
                d15.dispose();
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return true;
    }
}

