/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.utils;

import io.github.skylot.raung.common.utils.LimitedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtils.class);
    private static final int MAX_SIZE_DIFF = 100;
    private static final int MAX_ENTRIES_COUNT = 100000;

    private ZipUtils() {
    }

    private static boolean isInSubDirectoryInternal(File baseDir, File canonFile) {
        if (canonFile == null) {
            return false;
        }
        if (canonFile.equals(baseDir)) {
            return true;
        }
        return ZipUtils.isInSubDirectoryInternal(baseDir, canonFile.getParentFile());
    }

    public static boolean isInSubDirectory(File baseDir, File file2) {
        try {
            file2 = file2.getCanonicalFile();
            baseDir = baseDir.getCanonicalFile();
        }
        catch (IOException e15) {
            return false;
        }
        return ZipUtils.isInSubDirectoryInternal(baseDir, file2);
    }

    public static boolean isValidZipEntryName(String entryName) {
        try {
            File currentPath = new File(".").getCanonicalFile();
            File canonical = new File(currentPath, entryName).getCanonicalFile();
            if (ZipUtils.isInSubDirectoryInternal(currentPath, canonical)) {
                return true;
            }
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
        catch (Exception e15) {
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
    }

    public static boolean isZipBomb(ZipEntry entry) {
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
            return true;
        }
        if (compressedSize * 100L < uncompressedSize) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
            return true;
        }
        return false;
    }

    public static boolean isValidZipEntry(ZipEntry entry) {
        return ZipUtils.isValidZipEntryName(entry.getName()) && !ZipUtils.isZipBomb(entry);
    }

    public static InputStream getInputStreamForEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        InputStream in4 = zipFile.getInputStream(entry);
        LimitedInputStream limited = new LimitedInputStream(in4, entry.getSize());
        return new BufferedInputStream(limited);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <R> R visitZipEntries(File file2, BiFunction<ZipFile, ZipEntry, R> visitor2) {
        try (ZipFile zip = new ZipFile(file2);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int entriesProcessed = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!ZipUtils.isValidZipEntry(entry)) continue;
                R result = visitor2.apply(zip, entry);
                if (result != null) {
                    R r15 = result;
                    return r15;
                }
                if (++entriesProcessed > 100000) throw new IllegalStateException("Zip entries count limit exceeded: 100000, last entry: " + entry.getName());
            }
            return null;
        }
        catch (Exception e15) {
            throw new RuntimeException("Failed to process zip file: " + file2.getAbsolutePath(), e15);
        }
    }

    public static void readZipEntries(File file2, BiConsumer<ZipEntry, InputStream> visitor2) {
        ZipUtils.visitZipEntries(file2, (zip, entry) -> {
            if (!entry.isDirectory()) {
                try (InputStream in4 = ZipUtils.getInputStreamForEntry(zip, entry);){
                    visitor2.accept((ZipEntry)entry, in4);
                }
                catch (Exception e15) {
                    throw new RuntimeException("Error process zip entry: " + entry.getName());
                }
            }
            return null;
        });
    }
}

