/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.CustomViewportLayout;
import hu.kazocsaba.imageviewer.DefaultStatusBar;
import hu.kazocsaba.imageviewer.DefaultViewerPopup;
import hu.kazocsaba.imageviewer.ImageComponent;
import hu.kazocsaba.imageviewer.ImageMouseClickListener;
import hu.kazocsaba.imageviewer.ImageMouseMotionListener;
import hu.kazocsaba.imageviewer.LayeredImageView;
import hu.kazocsaba.imageviewer.Overlay;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import hu.kazocsaba.imageviewer.StatusBar;
import hu.kazocsaba.imageviewer.Synchronizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public final class ImageViewer {
    private final LayeredImageView view;
    private ImageComponent theImage;
    private final JScrollPane scroller;
    private JPanel panel;
    private StatusBar statusBar;
    private boolean statusBarVisible = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Synchronizer synchronizer;

    public ImageViewer() {
        this(null);
    }

    public ImageViewer(BufferedImage image) {
        this(image, true);
    }

    public ImageViewer(BufferedImage image, boolean defaultPopupMenu) {
        this.panel = new JPanel(new BorderLayout());
        this.scroller = new JScrollPane(){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){

                    @Override
                    protected LayoutManager createLayoutManager() {
                        return new CustomViewportLayout(ImageViewer.this);
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
                    }
                };
            }

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        this.synchronizer = new Synchronizer(this);
        this.theImage = new ImageComponent(this, this.propertyChangeSupport);
        this.view = new LayeredImageView(this.theImage);
        this.scroller.setViewportView(this.view.getComponent());
        this.theImage.setImage(image);
        this.panel.add((Component)this.scroller, "Center");
        this.setStatusBar(new DefaultStatusBar());
        if (defaultPopupMenu) {
            this.theImage.addMouseListener(new MouseAdapter(){
                JPopupMenu popup;

                private void showPopup(MouseEvent e15) {
                    Point p15;
                    e15.consume();
                    if (this.popup == null) {
                        this.popup = new DefaultViewerPopup(ImageViewer.this);
                    }
                    if ((p15 = ImageViewer.this.panel.getPopupLocation(e15)) == null) {
                        p15 = e15.getPoint();
                    }
                    this.popup.show(e15.getComponent(), p15.x, p15.y);
                }

                @Override
                public void mousePressed(MouseEvent e15) {
                    if (e15.isPopupTrigger()) {
                        this.showPopup(e15);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e15) {
                    if (e15.isPopupTrigger()) {
                        this.showPopup(e15);
                    }
                }
            });
        }
    }

    public void setStatusBar(StatusBar statusBar) {
        if (statusBar == this.statusBar) {
            return;
        }
        if (statusBar.getImageViewer() != null) {
            throw new IllegalArgumentException("Status bar already added to an image viewer");
        }
        StatusBar oldStatusBar = this.statusBar;
        if (oldStatusBar != null) {
            this.panel.remove(oldStatusBar.getComponent());
            oldStatusBar.setImageViewer(null);
        }
        this.statusBar = statusBar;
        if (this.statusBar != null) {
            this.statusBar.setImageViewer(this);
            if (this.statusBarVisible) {
                this.panel.add((Component)this.statusBar.getComponent(), "South");
                this.panel.revalidate();
                this.panel.repaint();
            }
        }
        this.propertyChangeSupport.firePropertyChange("statusBar", oldStatusBar, statusBar);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBarVisible(boolean statusBarVisible) {
        if (this.statusBarVisible == statusBarVisible) {
            return;
        }
        if (this.statusBar != null) {
            if (statusBarVisible) {
                this.panel.add((Component)this.statusBar.getComponent(), "South");
            } else {
                this.panel.remove(this.statusBar.getComponent());
            }
            this.panel.revalidate();
            this.panel.repaint();
        }
        boolean prev = this.statusBarVisible;
        this.statusBarVisible = statusBarVisible;
        this.synchronizer.statusBarVisibilityChanged(this);
        this.propertyChangeSupport.firePropertyChange("statusBarVisible", prev, statusBarVisible);
    }

    public boolean isStatusBarVisible() {
        return this.statusBarVisible;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setImage(BufferedImage image) {
        this.theImage.setImage(image);
    }

    public BufferedImage getImage() {
        return this.theImage.getImage();
    }

    public void setResizeStrategy(ResizeStrategy resizeStrategy) {
        this.theImage.setResizeStrategy(resizeStrategy);
    }

    public ResizeStrategy getResizeStrategy() {
        return this.theImage.getResizeStrategy();
    }

    public void setPixelatedZoom(boolean pixelatedZoom) {
        this.theImage.setPixelatedZoom(pixelatedZoom);
    }

    public boolean isPixelatedZoom() {
        return this.theImage.isPixelatedZoom();
    }

    public Object getInterpolationType() {
        return this.theImage.getInterpolationType();
    }

    public void setInterpolationType(Object type) {
        this.theImage.setInterpolationType(type);
    }

    public double getZoomFactor() {
        return this.theImage.getZoomFactor();
    }

    public void setZoomFactor(double newZoomFactor) {
        this.theImage.setZoomFactor(newZoomFactor);
    }

    public AffineTransform getImageTransform() {
        return this.theImage.getImageTransform();
    }

    public void addOverlay(Overlay overlay, int layer) {
        this.view.addOverlay(overlay, layer);
    }

    public void addOverlay(Overlay overlay) {
        this.addOverlay(overlay, 1);
    }

    public void removeOverlay(Overlay overlay) {
        this.view.removeOverlay(overlay);
    }

    public void addMouseListener(MouseListener l15) {
        this.theImage.addMouseListener(l15);
    }

    public void removeMouseListener(MouseListener l15) {
        this.theImage.removeMouseListener(l15);
    }

    public void addMouseMotionListener(MouseMotionListener l15) {
        this.theImage.addMouseMotionListener(l15);
    }

    public void removeMouseMotionListener(MouseMotionListener l15) {
        this.theImage.removeMouseMotionListener(l15);
    }

    public void addImageMouseMotionListener(ImageMouseMotionListener l15) {
        this.theImage.addImageMouseMoveListener(l15);
    }

    public void removeImageMouseMotionListener(ImageMouseMotionListener l15) {
        this.theImage.removeImageMouseMoveListener(l15);
    }

    public void addImageMouseClickListener(ImageMouseClickListener l15) {
        this.theImage.addImageMouseClickListener(l15);
    }

    public void removeImageMouseClickListener(ImageMouseClickListener l15) {
        this.theImage.removeImageMouseClickListener(l15);
    }

    public void addPropertyChangeListener(PropertyChangeListener l15) {
        this.propertyChangeSupport.addPropertyChangeListener(l15);
    }

    public void removePropertyChangeListener(PropertyChangeListener l15) {
        this.propertyChangeSupport.removePropertyChangeListener(l15);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l15) {
        this.propertyChangeSupport.addPropertyChangeListener(name, l15);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l15) {
        this.propertyChangeSupport.removePropertyChangeListener(name, l15);
    }

    JScrollPane getScrollPane() {
        return this.scroller;
    }

    Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    void setSynchronizer(Synchronizer newSync) {
        this.synchronizer = newSync;
    }

    public Point pointToPixel(Point p15, boolean clipToImage) {
        return this.theImage.pointToPixel(p15, clipToImage);
    }
}

