/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageSequenceViewer {
    private final ImageViewer imageViewer;
    private int number;
    private int position;
    private JButton forwardButton;
    private JButton backwardButton;
    private JLabel locationLabel;
    private JPanel panel = new JPanel(new BorderLayout()){

        @Override
        public void addNotify() {
            super.addNotify();
            ImageSequenceViewer.this.positionChanged();
        }
    };

    public ImageSequenceViewer(int number) {
        this(number, 0);
    }

    public ImageSequenceViewer(int number, int startPos) {
        if (number <= 0 || startPos < 0 || startPos >= number) {
            throw new IllegalArgumentException();
        }
        this.imageViewer = new ImageViewer();
        this.number = number;
        this.position = startPos;
        this.panel.add((Component)this.imageViewer.getComponent(), "Center");
        this.forwardButton = new JButton(">");
        this.backwardButton = new JButton("<");
        JPanel locationPanel = new JPanel(new FlowLayout());
        locationPanel.add(this.backwardButton);
        locationPanel.add(this.createLocationDefinition());
        locationPanel.add(this.forwardButton);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e15) {
                ImageSequenceViewer.this.setPosition(ImageSequenceViewer.this.position + 1);
            }
        });
        this.backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e15) {
                ImageSequenceViewer.this.setPosition(ImageSequenceViewer.this.position - 1);
            }
        });
        this.panel.add((Component)locationPanel, "North");
        this.setPosition(this.position);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    protected void positionChanged() {
    }

    public ImageViewer getImageViewer() {
        return this.imageViewer;
    }

    public void setPosition(int pos) {
        if (pos < 0 || pos >= this.number) {
            throw new IllegalArgumentException("Position " + pos + " out of range");
        }
        this.position = pos;
        this.updateLocationDefinition(this.position);
        this.forwardButton.setEnabled(this.position < this.number - 1);
        this.backwardButton.setEnabled(this.position > 0);
        if (this.panel.getParent() != null) {
            this.positionChanged();
        }
    }

    public int getPosition() {
        return this.position;
    }

    protected JComponent createLocationDefinition() {
        this.locationLabel = new JLabel();
        return this.locationLabel;
    }

    protected void updateLocationDefinition(int pos) {
        this.locationLabel.setText(String.format("%d/%d", pos + 1, this.number));
    }
}

