/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.SeekableInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileSeekableStream
extends SeekableInputStream {
    final RandomAccessFile mRandomAccess;

    public FileSeekableStream(File file2) throws FileNotFoundException {
        this(new RandomAccessFile(file2, "r"));
    }

    public FileSeekableStream(RandomAccessFile randomAccessFile) {
        this.mRandomAccess = randomAccessFile;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public int available() throws IOException {
        long l15 = this.mRandomAccess.length() - this.position;
        return l15 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l15;
    }

    @Override
    public void closeImpl() throws IOException {
        this.mRandomAccess.close();
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int n15 = this.mRandomAccess.read();
        if (n15 >= 0) {
            ++this.position;
        }
        return n15;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        this.checkOpen();
        int n17 = this.mRandomAccess.read(byArray, n15, n16);
        if (n17 > 0) {
            this.position += (long)n17;
        }
        return n17;
    }

    @Override
    protected void flushBeforeImpl(long l15) {
    }

    @Override
    protected void seekImpl(long l15) throws IOException {
        this.mRandomAccess.seek(l15);
    }
}

