/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.lang.Validate;

final class ColorCache {
    private final int[] colors;
    private final int hashShift;
    private static final long K_HASH_MUL = 506832829L;

    private static int hashPix(int n15, int n16) {
        return (int)(((long)n15 * 506832829L & 0xFFFFFFFFL) >> n16);
    }

    ColorCache(int n15) {
        Validate.isTrue(n15 > 0, "hasBits must > 0");
        int n16 = 1 << n15;
        this.colors = new int[n16];
        this.hashShift = 32 - n15;
    }

    int lookup(int n15) {
        return this.colors[n15];
    }

    void set(int n15, int n16) {
        this.colors[n15] = n16;
    }

    void insert(int n15) {
        this.colors[this.index((int)n15)] = n15;
    }

    int index(int n15) {
        return ColorCache.hashPix(n15, this.hashShift);
    }

    int contains(int n15) {
        int n16 = this.index(n15);
        return this.colors[n16] == n15 ? n16 : -1;
    }
}

