/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.output.impl;

import com.github.weisj.jsvg.renderer.output.Output;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphicsUtil {
    private static final Logger LOGGER = Logger.getLogger(GraphicsUtil.class.getName());

    private GraphicsUtil() {
    }

    static void safelySetPaint(@NotNull Output output, @NotNull Graphics2D g15, @NotNull Paint paint) {
        g15.setPaint(GraphicsUtil.exchangePaint(output, g15.getPaint(), paint, true));
    }

    static void cleanupPaint(@NotNull Output output, @NotNull Paint paint) {
        if (paint instanceof WrappingPaint) {
            GraphicsUtil.cleanupPaint(output, ((WrappingPaint)((Object)paint)).paint());
        }
        if (paint instanceof DisposablePaint) {
            ((DisposablePaint)((Object)paint)).cleanupIfNeeded(output);
        }
    }

    static void preparePaint(@NotNull Paint paint) {
        if (paint instanceof WrappingPaint) {
            GraphicsUtil.preparePaint(((WrappingPaint)((Object)paint)).paint());
        }
    }

    @NotNull
    private static Paint exchangePaint(@NotNull Output output, @NotNull Paint current, @NotNull Paint paint, boolean doCleanUp) {
        if (paint instanceof WrappingPaint) {
            WrappingPaint wrappingPaint = (WrappingPaint)((Object)paint);
            wrappingPaint.safelySetPaint(output, current, doCleanUp);
            return paint;
        }
        if (current instanceof WrappingPaint) {
            WrappingPaint wrappingPaint = (WrappingPaint)((Object)current);
            wrappingPaint.safelySetPaint(output, paint, doCleanUp);
            return current;
        }
        if (doCleanUp) {
            GraphicsUtil.preparePaint(paint);
            GraphicsUtil.cleanupPaint(output, current);
        }
        return paint;
    }

    @NotNull
    public static Graphics2D createGraphics(@NotNull BufferedImage image) {
        Graphics2D g15 = image.createGraphics();
        g15.clipRect(0, 0, image.getWidth(), image.getHeight());
        return g15;
    }

    @NotNull
    public static Composite deriveComposite(@NotNull Graphics2D g15, float opacity) {
        Composite composite = g15.getComposite();
        if (composite instanceof AlphaComposite) {
            AlphaComposite ac5 = (AlphaComposite)composite;
            return AlphaComposite.getInstance(ac5.getRule(), ac5.getAlpha() * opacity);
        }
        if (composite != null) {
            LOGGER.warning(() -> String.format("Composite %s will be overridden by opacity %s", composite, Float.valueOf(opacity)));
        }
        return AlphaComposite.getInstance(3, opacity);
    }

    public static void safelyDrawImage(@NotNull Output output, @NotNull Graphics2D g15, @NotNull Image image, @Nullable ImageObserver observer) {
        Paint p15 = g15.getPaint();
        if (p15 instanceof WrappingPaint) {
            WrappingPaint wrappingPaint = (WrappingPaint)((Object)p15);
            Paint inner = wrappingPaint.innerPaint();
            Rectangle r15 = new Rectangle(0, 0, image.getWidth(observer), image.getHeight(observer));
            BufferedImage img = image instanceof BufferedImage ? (BufferedImage)image : ImageUtil.toBufferedImage(image);
            TexturePaint texturePaint = new TexturePaint(img, r15);
            wrappingPaint.setPaint(GraphicsUtil.exchangePaint(output, wrappingPaint.paint(), texturePaint, false));
            g15.fill(r15);
            wrappingPaint.setPaint(GraphicsUtil.exchangePaint(output, texturePaint, inner, false));
        } else {
            g15.drawImage(image, 0, 0, observer);
        }
    }

    public static interface WrappingPaint {
        public void setPaint(@NotNull Paint var1);

        @NotNull
        public Paint paint();

        @NotNull
        default public Paint innerPaint() {
            Paint p15 = this.paint();
            if (p15 instanceof WrappingPaint) {
                return ((WrappingPaint)((Object)p15)).innerPaint();
            }
            return p15;
        }

        default public void safelySetPaint(@NotNull Output output, @NotNull Paint paint, boolean updateRefCounts) {
            this.setPaint(GraphicsUtil.exchangePaint(output, this.paint(), paint, updateRefCounts));
        }
    }

    public static interface DisposablePaint {
        public void cleanupIfNeeded(@NotNull Output var1);
    }
}

