/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.IdentityHashMap;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeCellEditor;

public class FlatUIUtils {
    private static boolean useSharedUIs = true;
    private static final WeakHashMap<LookAndFeel, IdentityHashMap<Object, ComponentUI>> sharedUIinstances = new WeakHashMap();
    private static UIDefaults lightAWTPeerDefaults;
    public static final double MOVE_TO = -1.000000000001E12;
    public static final double QUAD_TO = -1.000000000002E12;
    public static final double CURVE_TO = -1.000000000003E12;
    public static final double ROUNDED = -1.000000000004E12;
    public static final double CLOSE_PATH = -1.000000000005E12;

    public static Rectangle addInsets(Rectangle r15, Insets insets) {
        return new Rectangle(r15.x - insets.left, r15.y - insets.top, r15.width + insets.left + insets.right, r15.height + insets.top + insets.bottom);
    }

    public static Rectangle subtractInsets(Rectangle r15, Insets insets) {
        return new Rectangle(r15.x + insets.left, r15.y + insets.top, r15.width - insets.left - insets.right, r15.height - insets.top - insets.bottom);
    }

    public static Dimension addInsets(Dimension dim, Insets insets) {
        return new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
    }

    public static Insets addInsets(Insets insets1, Insets insets2) {
        if (insets1 == null) {
            return insets2;
        }
        if (insets2 == null) {
            return insets1;
        }
        return new Insets(insets1.top + insets2.top, insets1.left + insets2.left, insets1.bottom + insets2.bottom, insets1.right + insets2.right);
    }

    public static void setInsets(Insets dest, Insets src) {
        dest.top = src.top;
        dest.left = src.left;
        dest.bottom = src.bottom;
        dest.right = src.right;
    }

    public static boolean isInsetsEmpty(Insets insets) {
        return insets.top == 0 && insets.left == 0 && insets.bottom == 0 && insets.right == 0;
    }

    public static Color stateColor(boolean state, Color stateColor, Color defaultColor) {
        return state && stateColor != null ? stateColor : defaultColor;
    }

    public static Color stateColor(boolean state1, Color state1Color, boolean state2, Color state2Color, Color defaultColor) {
        return state1 && state1Color != null ? state1Color : (state2 && state2Color != null ? state2Color : defaultColor);
    }

    public static Color getUIColor(String key, int defaultColorRGB) {
        Color color = UIManager.getColor(key);
        return color != null ? color : new Color(defaultColorRGB);
    }

    public static Color getUIColor(String key, Color defaultColor) {
        Color color = UIManager.getColor(key);
        return color != null ? color : defaultColor;
    }

    public static Color getUIColor(String key, String defaultKey) {
        Color color = UIManager.getColor(key);
        return color != null ? color : UIManager.getColor(defaultKey);
    }

    public static boolean getUIBoolean(String key, boolean defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static int getUIInt(String key, int defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static float getUIFloat(String key, float defaultValue) {
        Object value = UIManager.get(key);
        return value instanceof Number ? ((Number)value).floatValue() : defaultValue;
    }

    public static <T extends Enum<T>> T getUIEnum(String key, Class<T> enumType, T defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof String) {
            try {
                return Enum.valueOf(enumType, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Color getSubUIColor(String key, String subKey) {
        Color value;
        if (subKey != null && (value = UIManager.getColor(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getColor(key);
    }

    public static boolean getSubUIBoolean(String key, String subKey, boolean defaultValue) {
        Object value;
        if (subKey != null && (value = UIManager.get(FlatUIUtils.buildSubKey(key, subKey))) instanceof Boolean) {
            return (Boolean)value;
        }
        return FlatUIUtils.getUIBoolean(key, defaultValue);
    }

    public static int getSubUIInt(String key, String subKey, int defaultValue) {
        Object value;
        if (subKey != null && (value = UIManager.get(FlatUIUtils.buildSubKey(key, subKey))) instanceof Integer) {
            return (Integer)value;
        }
        return FlatUIUtils.getUIInt(key, defaultValue);
    }

    public static Insets getSubUIInsets(String key, String subKey) {
        Insets value;
        if (subKey != null && (value = UIManager.getInsets(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getInsets(key);
    }

    public static Dimension getSubUIDimension(String key, String subKey) {
        Dimension value;
        if (subKey != null && (value = UIManager.getDimension(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getDimension(key);
    }

    public static Icon getSubUIIcon(String key, String subKey) {
        Icon value;
        if (subKey != null && (value = UIManager.getIcon(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getIcon(key);
    }

    public static Font getSubUIFont(String key, String subKey) {
        Font value;
        if (subKey != null && (value = UIManager.getFont(FlatUIUtils.buildSubKey(key, subKey))) != null) {
            return value;
        }
        return UIManager.getFont(key);
    }

    private static String buildSubKey(String key, String subKey) {
        int dot = key.lastIndexOf(46);
        return dot >= 0 ? key.substring(0, dot) + '.' + subKey + '.' + key.substring(dot + 1) : key;
    }

    public static boolean getBoolean(JComponent c15, String systemPropertyKey, String clientPropertyKey, String uiKey, boolean defaultValue) {
        Boolean value = FlatSystemProperties.getBooleanStrict(systemPropertyKey, null);
        if (value != null) {
            return value;
        }
        value = FlatClientProperties.clientPropertyBooleanStrict(c15, clientPropertyKey, null);
        if (value != null) {
            return value;
        }
        return FlatUIUtils.getUIBoolean(uiKey, defaultValue);
    }

    public static boolean isChevron(String arrowType) {
        return !"triangle".equals(arrowType);
    }

    public static Color nonUIResource(Color c15) {
        return c15 instanceof UIResource ? new Color(c15.getRGB(), true) : c15;
    }

    public static Font nonUIResource(Font font) {
        return font instanceof UIResource ? font.deriveFont(font.getStyle()) : font;
    }

    public static Border nonUIResource(Border border) {
        return border instanceof UIResource ? new NonUIResourceBorder(border) : border;
    }

    static Border unwrapNonUIResourceBorder(Border border) {
        return border instanceof NonUIResourceBorder ? ((NonUIResourceBorder)border).delegate : border;
    }

    public static int minimumWidth(JComponent c15, int minimumWidth) {
        return FlatClientProperties.clientPropertyInt(c15, "JComponent.minimumWidth", minimumWidth);
    }

    public static int minimumHeight(JComponent c15, int minimumHeight) {
        return FlatClientProperties.clientPropertyInt(c15, "JComponent.minimumHeight", minimumHeight);
    }

    public static boolean isCellEditor(Component c15) {
        if (c15 == null) {
            return false;
        }
        Container parent = c15.getParent();
        if (parent instanceof JTable && ((JTable)parent).getEditorComponent() == c15) {
            return true;
        }
        if (parent instanceof DefaultTreeCellEditor.EditorContainer) {
            return true;
        }
        String name = c15.getName();
        if ("Table.editor".equals(name) || "Tree.cellEditor".equals(name)) {
            return true;
        }
        return c15 instanceof JComponent && Boolean.TRUE.equals(((JComponent)c15).getClientProperty("JComboBox.isTableCellEditor"));
    }

    public static boolean isPermanentFocusOwner(Component c15) {
        Object value;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (c15 instanceof JComponent && (value = ((JComponent)c15).getClientProperty("JComponent.focusOwner")) instanceof Predicate) {
            return ((Predicate)value).test((JComponent)c15) && FlatUIUtils.isInActiveWindow(c15, keyboardFocusManager.getActiveWindow());
        }
        if (c15.hasFocus()) {
            return true;
        }
        return keyboardFocusManager.getPermanentFocusOwner() == c15 && FlatUIUtils.isInActiveWindow(c15, keyboardFocusManager.getActiveWindow());
    }

    static boolean isInActiveWindow(Component c15, Window activeWindow) {
        Window window = SwingUtilities.windowForComponent(c15);
        return window == activeWindow || window != null && window.getType() == Window.Type.POPUP && window.getOwner() == activeWindow;
    }

    static boolean isAWTPeer(Component c15) {
        if (SystemInfo.isMacOS) {
            return c15.getClass().getName().startsWith("sun.lwawt.LW");
        }
        return false;
    }

    static boolean needsLightAWTPeer(JComponent c15) {
        return FlatUIUtils.isAWTPeer(c15) && FlatLaf.isLafDark();
    }

    static void runWithLightAWTPeerUIDefaults(Runnable runnable) {
        if (lightAWTPeerDefaults == null) {
            FlatLightLaf lightLaf = UIManager.getInt("Component.focusWidth") >= 2 ? new FlatIntelliJLaf() : new FlatLightLaf();
            lightAWTPeerDefaults = lightLaf.getDefaults();
        }
        FlatLaf.runWithUIDefaultsGetter(key -> {
            Object value = lightAWTPeerDefaults.get(key);
            return value != null ? value : FlatLaf.NULL_VALUE;
        }, runnable);
    }

    public static boolean isFullScreen(Component c15) {
        GraphicsConfiguration gc5 = c15.getGraphicsConfiguration();
        GraphicsDevice gd5 = gc5 != null ? gc5.getDevice() : null;
        Window fullScreenWindow = gd5 != null ? gd5.getFullScreenWindow() : null;
        return fullScreenWindow != null && fullScreenWindow == SwingUtilities.windowForComponent(c15);
    }

    public static Insets getScreenInsets(GraphicsConfiguration gc5) {
        if (SystemInfo.isLinux && GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length > 1) {
            return new Insets(0, 0, 0, 0);
        }
        return Toolkit.getDefaultToolkit().getScreenInsets(gc5);
    }

    public static Boolean isRoundRect(Component c15) {
        return c15 instanceof JComponent ? FlatClientProperties.clientPropertyBooleanStrict((JComponent)c15, "JComponent.roundRect", null) : null;
    }

    public static float getBorderFocusWidth(JComponent c15) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c15);
        return border != null ? UIScale.scale((float)border.getFocusWidth(c15)) : 0.0f;
    }

    public static float getBorderLineWidth(JComponent c15) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c15);
        return border != null ? UIScale.scale((float)border.getLineWidth(c15)) : 0.0f;
    }

    public static int getBorderFocusAndLineWidth(JComponent c15) {
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c15);
        return border != null ? Math.round(UIScale.scale((float)border.getFocusWidth(c15)) + UIScale.scale((float)border.getLineWidth(c15))) : 0;
    }

    public static float getBorderArc(JComponent c15) {
        if (c15.getBorder() instanceof FlatLineBorder) {
            return UIScale.scale(((FlatLineBorder)c15.getBorder()).getArc());
        }
        FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c15);
        return border != null ? UIScale.scale((float)border.getArc(c15)) : 0.0f;
    }

    public static boolean hasRoundBorder(JComponent c15) {
        return FlatUIUtils.getBorderArc(c15) >= (float)c15.getHeight();
    }

    public static FlatBorder getOutsideFlatBorder(JComponent c15) {
        Border border = c15.getBorder();
        while (true) {
            if (border instanceof FlatBorder) {
                return (FlatBorder)border;
            }
            if (!(border instanceof CompoundBorder)) break;
            border = ((CompoundBorder)border).getOutsideBorder();
        }
        return null;
    }

    public static Object[] setRenderingHints(Graphics g15) {
        Graphics2D g25 = (Graphics2D)g15;
        Object[] oldRenderingHints = new Object[]{g25.getRenderingHint(RenderingHints.KEY_ANTIALIASING), g25.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        g25.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g25.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return oldRenderingHints;
    }

    public static void resetRenderingHints(Graphics g15, Object[] oldRenderingHints) {
        Graphics2D g25 = (Graphics2D)g15;
        if (oldRenderingHints[0] != null) {
            g25.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHints[0]);
        }
        if (oldRenderingHints[1] != null) {
            g25.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldRenderingHints[1]);
        }
    }

    public static void runWithoutRenderingHints(Graphics g15, Object[] oldRenderingHints, Runnable runnable) {
        if (oldRenderingHints == null) {
            runnable.run();
            return;
        }
        Graphics2D g25 = (Graphics2D)g15;
        Object[] oldRenderingHints2 = new Object[]{g25.getRenderingHint(RenderingHints.KEY_ANTIALIASING), g25.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        FlatUIUtils.resetRenderingHints(g25, oldRenderingHints);
        runnable.run();
        FlatUIUtils.resetRenderingHints(g25, oldRenderingHints2);
    }

    public static Color deriveColor(Color color, Color baseColor) {
        return color instanceof DerivedColor ? ((DerivedColor)color).derive(baseColor) : color;
    }

    public static void paintComponentBackground(Graphics2D g15, int x15, int y15, int width, int height, float focusWidth, float arc) {
        FlatUIUtils.paintOutlinedComponent(g15, x15, y15, width, height, focusWidth, 0.0f, 0.0f, 0.0f, arc, null, null, g15.getPaint());
    }

    public static void paintOutlinedComponent(Graphics2D g15, int x15, int y15, int width, int height, float focusWidth, float focusWidthFraction, float focusInnerWidth, float borderWidth, float arc, Paint focusColor, Paint borderColor, Paint background) {
        FlatUIUtils.paintOutlinedComponent(g15, x15, y15, width, height, focusWidth, focusWidthFraction, focusInnerWidth, borderWidth, arc, focusColor, borderColor, background, false);
    }

    static void paintOutlinedComponent(Graphics2D g15, int x15, int y15, int width, int height, float focusWidth, float focusWidthFraction, float focusInnerWidth, float borderWidth, float arc, Paint focusColor, Paint borderColor, Paint background, boolean scrollPane) {
        double systemScaleFactor = UIScale.getSystemScaleFactor(g15);
        if ((double)((int)systemScaleFactor) != systemScaleFactor) {
            HiDPIUtils.paintAtScale1x(g15, x15, y15, width, height, (g2d, x25, y25, width2, height2, scaleFactor) -> FlatUIUtils.paintOutlinedComponentImpl(g2d, x25, y25, width2, height2, (float)((double)focusWidth * scaleFactor), focusWidthFraction, (float)((double)focusInnerWidth * scaleFactor), (float)((double)borderWidth * scaleFactor), (float)((double)arc * scaleFactor), focusColor, borderColor, background, scrollPane, scaleFactor));
            return;
        }
        FlatUIUtils.paintOutlinedComponentImpl(g15, x15, y15, width, height, focusWidth, focusWidthFraction, focusInnerWidth, borderWidth, arc, focusColor, borderColor, background, scrollPane, systemScaleFactor);
    }

    private static void paintOutlinedComponentImpl(Graphics2D g15, int x15, int y15, int width, int height, float focusWidth, float focusWidthFraction, float focusInnerWidth, float borderWidth, float arc, Paint focusColor, Paint borderColor, Paint background, boolean scrollPane, double scaleFactor) {
        if (scrollPane && scaleFactor != (double)((int)scaleFactor)) {
            if (focusWidth > 0.0f) {
                int totalWidth = (int)(focusWidth + borderWidth);
                focusWidth = (float)totalWidth - borderWidth;
            } else {
                borderWidth = (int)borderWidth;
            }
        }
        float x16 = (float)x15 + focusWidth;
        float y16 = (float)y15 + focusWidth;
        float w15 = (float)width - focusWidth * 2.0f;
        float h15 = (float)height - focusWidth * 2.0f;
        if (background != null) {
            g15.setPaint(background);
            g15.fill(FlatUIUtils.createComponentRectangle(x16, y16, w15, h15, arc));
        }
        if (borderColor != null && borderColor.equals(focusColor)) {
            borderColor = null;
            focusInnerWidth = Math.max(focusInnerWidth, borderWidth);
        }
        float paintedFocusWidth = focusWidth * focusWidthFraction + focusInnerWidth;
        if (focusColor != null && paintedFocusWidth != 0.0f) {
            float inset = focusWidth - focusWidth * focusWidthFraction;
            float x25 = (float)x15 + inset;
            float y25 = (float)y15 + inset;
            float w25 = (float)width - inset * 2.0f;
            float h25 = (float)height - inset * 2.0f;
            float outerArc = arc + focusWidth * 2.0f;
            float innerArc = arc - focusInnerWidth * 2.0f;
            if (focusWidth > 0.0f && arc > 0.0f && arc < (float)UIScale.scale(10)) {
                outerArc -= UIScale.scale(2.0f);
            }
            if (focusWidthFraction != 1.0f) {
                outerArc = arc + (outerArc - arc) * focusWidthFraction;
            }
            g15.setPaint(focusColor);
            FlatUIUtils.paintOutline(g15, x25, y25, w25, h25, paintedFocusWidth, outerArc, innerArc);
        }
        if (borderColor != null && borderWidth != 0.0f) {
            g15.setPaint(borderColor);
            FlatUIUtils.paintOutline(g15, x16, y16, w15, h15, borderWidth, arc);
        }
    }

    public static void paintOutline(Graphics2D g15, float x15, float y15, float w15, float h15, float lineWidth, float arc) {
        FlatUIUtils.paintOutline(g15, x15, y15, w15, h15, lineWidth, arc, arc - lineWidth * 2.0f);
    }

    public static void paintOutline(Graphics2D g15, float x15, float y15, float w15, float h15, float lineWidth, float arc, float innerArc) {
        if (lineWidth == 0.0f || w15 <= 0.0f || h15 <= 0.0f) {
            return;
        }
        float t15 = lineWidth;
        float t2x = t15 * 2.0f;
        Path2D.Float border = new Path2D.Float(0);
        border.append(FlatUIUtils.createComponentRectangle(x15, y15, w15, h15, arc), false);
        border.append(FlatUIUtils.createComponentRectangle(x15 + t15, y15 + t15, w15 - t2x, h15 - t2x, innerArc), false);
        g15.fill(border);
    }

    public static Shape createComponentRectangle(float x15, float y15, float w15, float h15, float arc) {
        if (arc <= 0.0f) {
            return new Rectangle2D.Float(x15, y15, w15, h15);
        }
        if (w15 == h15 && arc >= w15) {
            return new Ellipse2D.Float(x15, y15, w15, h15);
        }
        arc = Math.min(arc, Math.min(w15, h15));
        return new RoundRectangle2D.Float(x15, y15, w15, h15, arc, arc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintFilledRectangle(Graphics g15, Color color, float x15, float y15, float w15, float h15) {
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            g25.setColor(color);
            g25.fill(new Rectangle2D.Float(x15, y15, w15, h15));
        }
        finally {
            g25.dispose();
        }
    }

    public static void paintSelection(Graphics2D g15, int x15, int y15, int width, int height, Insets insets, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight, int flags) {
        if (insets != null) {
            x15 += insets.left;
            y15 += insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (arcTopLeft > 0.0f || arcTopRight > 0.0f || arcBottomLeft > 0.0f || arcBottomRight > 0.0f) {
            double systemScaleFactor = UIScale.getSystemScaleFactor(g15);
            if (systemScaleFactor != (double)((int)systemScaleFactor)) {
                HiDPIUtils.paintAtScale1x(g15, x15, y15, width, height, (g2d, x25, y25, width2, height2, scaleFactor) -> FlatUIUtils.paintRoundedSelectionImpl(g2d, x25, y25, width2, height2, (float)((double)arcTopLeft * scaleFactor), (float)((double)arcTopRight * scaleFactor), (float)((double)arcBottomLeft * scaleFactor), (float)((double)arcBottomRight * scaleFactor)));
            } else {
                FlatUIUtils.paintRoundedSelectionImpl(g15, x15, y15, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight);
            }
        } else {
            g15.fillRect(x15, y15, width, height);
        }
    }

    private static void paintRoundedSelectionImpl(Graphics2D g15, int x15, int y15, int width, int height, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        g15.fill(FlatUIUtils.createRoundRectanglePath(x15, y15, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight));
        FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
    }

    public static void paintGrip(Graphics g15, int x15, int y15, int width, int height, boolean horizontal, int dotCount, int dotSize, int gap, boolean centerPrecise) {
        float gy4;
        float gx4;
        dotSize = UIScale.scale(dotSize);
        gap = UIScale.scale(gap);
        int gripSize = dotSize * dotCount + gap * (dotCount - 1);
        if (horizontal) {
            gx4 = x15 + Math.round((float)(width - gripSize) / 2.0f);
            gy4 = (float)y15 + (float)(height - dotSize) / 2.0f;
            if (!centerPrecise) {
                gy4 = Math.round(gy4);
            }
        } else {
            gx4 = (float)x15 + (float)(width - dotSize) / 2.0f;
            gy4 = y15 + Math.round((float)(height - gripSize) / 2.0f);
            if (!centerPrecise) {
                gx4 = Math.round(gx4);
            }
        }
        for (int i15 = 0; i15 < dotCount; ++i15) {
            ((Graphics2D)g15).fill(new Ellipse2D.Float(gx4, gy4, dotSize, dotSize));
            if (horizontal) {
                gx4 += (float)(dotSize + gap);
                continue;
            }
            gy4 += (float)(dotSize + gap);
        }
    }

    public static void paintParentBackground(Graphics g15, JComponent c15) {
        Color background = FlatUIUtils.getParentBackground(c15);
        if (background != null) {
            g15.setColor(background);
            g15.fillRect(0, 0, c15.getWidth(), c15.getHeight());
        }
    }

    public static Color getParentBackground(JComponent c15) {
        Color background;
        Container parent = FlatUIUtils.findOpaqueParent(c15);
        Color color = background = parent != null ? parent.getBackground() : null;
        if (background != null) {
            return background;
        }
        if (FlatUIUtils.isAWTPeer(c15)) {
            return c15 instanceof JTextField || c15 instanceof JScrollPane || c15.getBackground() == null ? SystemColor.window : c15.getBackground();
        }
        return UIManager.getColor("Panel.background");
    }

    private static Container findOpaqueParent(Container c15) {
        while ((c15 = c15.getParent()) != null) {
            if (!c15.isOpaque()) continue;
            return c15;
        }
        return null;
    }

    public static Path2D createRectangle(float x15, float y15, float width, float height, float lineWidth) {
        Path2D.Float path = new Path2D.Float(0);
        path.append(new Rectangle2D.Float(x15, y15, width, height), false);
        path.append(new Rectangle2D.Float(x15 + lineWidth, y15 + lineWidth, width - lineWidth * 2.0f, height - lineWidth * 2.0f), false);
        return path;
    }

    public static Path2D createRoundRectangle(float x15, float y15, float width, float height, float lineWidth, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        Path2D.Float path = new Path2D.Float(0);
        path.append(FlatUIUtils.createRoundRectanglePath(x15, y15, width, height, arcTopLeft, arcTopRight, arcBottomLeft, arcBottomRight), false);
        path.append(FlatUIUtils.createRoundRectanglePath(x15 + lineWidth, y15 + lineWidth, width - lineWidth * 2.0f, height - lineWidth * 2.0f, arcTopLeft - lineWidth, arcTopRight - lineWidth, arcBottomLeft - lineWidth, arcBottomRight - lineWidth), false);
        return path;
    }

    public static Shape createRoundRectanglePath(float x15, float y15, float width, float height, float arcTopLeft, float arcTopRight, float arcBottomLeft, float arcBottomRight) {
        if (arcTopLeft <= 0.0f && arcTopRight <= 0.0f && arcBottomLeft <= 0.0f && arcBottomRight <= 0.0f) {
            return new Rectangle2D.Float(x15, y15, width, height);
        }
        float maxArc = Math.min(width, height) / 2.0f;
        arcTopLeft = arcTopLeft > 0.0f ? Math.min(arcTopLeft, maxArc) : 0.0f;
        arcTopRight = arcTopRight > 0.0f ? Math.min(arcTopRight, maxArc) : 0.0f;
        arcBottomLeft = arcBottomLeft > 0.0f ? Math.min(arcBottomLeft, maxArc) : 0.0f;
        arcBottomRight = arcBottomRight > 0.0f ? Math.min(arcBottomRight, maxArc) : 0.0f;
        float x25 = x15 + width;
        float y25 = y15 + height;
        double c15 = 0.5522847498307933;
        double ci4 = 1.0 - c15;
        double ciTopLeft = (double)arcTopLeft * ci4;
        double ciTopRight = (double)arcTopRight * ci4;
        double ciBottomLeft = (double)arcBottomLeft * ci4;
        double ciBottomRight = (double)arcBottomRight * ci4;
        Path2D.Float rect = new Path2D.Float(1, 16);
        ((Path2D)rect).moveTo(x25 - arcTopRight, y15);
        ((Path2D)rect).curveTo((double)x25 - ciTopRight, y15, x25, (double)y15 + ciTopRight, x25, y15 + arcTopRight);
        ((Path2D)rect).lineTo(x25, y25 - arcBottomRight);
        ((Path2D)rect).curveTo(x25, (double)y25 - ciBottomRight, (double)x25 - ciBottomRight, y25, x25 - arcBottomRight, y25);
        ((Path2D)rect).lineTo(x15 + arcBottomLeft, y25);
        ((Path2D)rect).curveTo((double)x15 + ciBottomLeft, y25, x15, (double)y25 - ciBottomLeft, x15, y25 - arcBottomLeft);
        ((Path2D)rect).lineTo(x15, y15 + arcTopLeft);
        ((Path2D)rect).curveTo(x15, (double)y15 + ciTopLeft, (double)x15 + ciTopLeft, y15, x15 + arcTopLeft, y15);
        rect.closePath();
        return rect;
    }

    public static Shape createRoundTrianglePath(float x15, float y15, float x25, float y25, float x35, float y35, float arc) {
        double averageSideLength = (FlatUIUtils.distance(x15, y15, x25, y25) + FlatUIUtils.distance(x25, y25, x35, y35) + FlatUIUtils.distance(x35, y35, x15, y15)) / 3.0;
        double t15 = 1.0 / averageSideLength * (double)arc;
        double t25 = 1.0 - t15;
        return FlatUIUtils.createPath(FlatUIUtils.lerp(x35, x15, t25), FlatUIUtils.lerp(y35, y15, t25), -1.000000000002E12, x15, y15, FlatUIUtils.lerp(x15, x25, t15), FlatUIUtils.lerp(y15, y25, t15), FlatUIUtils.lerp(x15, x25, t25), FlatUIUtils.lerp(y15, y25, t25), -1.000000000002E12, x25, y25, FlatUIUtils.lerp(x25, x35, t15), FlatUIUtils.lerp(y25, y35, t15), FlatUIUtils.lerp(x25, x35, t25), FlatUIUtils.lerp(y25, y35, t25), -1.000000000002E12, x35, y35, FlatUIUtils.lerp(x35, x15, t15), FlatUIUtils.lerp(y35, y15, t15));
    }

    public static void paintArrow(Graphics2D g15, int x15, int y15, int width, int height, int direction, boolean chevron, int arrowSize, float arrowThickness, float xOffset, float yOffset) {
        boolean vert;
        float aw4 = UIScale.scale(arrowSize + (chevron ? -1 : 0));
        float ah4 = chevron ? aw4 / 2.0f : (float)UIScale.scale(arrowSize / 2 + 1);
        boolean bl4 = vert = direction == 1 || direction == 5;
        if (!vert) {
            float temp = aw4;
            aw4 = ah4;
            ah4 = temp;
        }
        boolean extra = chevron;
        float ox4 = ((float)width - (aw4 + (float)extra)) / 2.0f + UIScale.scale(xOffset);
        float oy4 = ((float)height - (ah4 + (float)extra)) / 2.0f + UIScale.scale(yOffset);
        float ax4 = (float)x15 + (direction == 7 ? (float)(-Math.round(-(ox4 + aw4))) - aw4 : (float)Math.round(ox4));
        float ay4 = (float)y15 + (direction == 1 ? (float)(-Math.round(-(oy4 + ah4))) - ah4 : (float)Math.round(oy4));
        g15.translate(ax4, ay4);
        Shape arrowShape = FlatUIUtils.createArrowShape(direction, chevron, aw4, ah4);
        if (chevron) {
            Stroke oldStroke = g15.getStroke();
            g15.setStroke(new BasicStroke(UIScale.scale(arrowThickness)));
            FlatUIUtils.drawShapePure(g15, arrowShape);
            g15.setStroke(oldStroke);
        } else {
            g15.fill(arrowShape);
        }
        g15.translate(-ax4, -ay4);
    }

    public static Shape createArrowShape(int direction, boolean chevron, float w15, float h15) {
        switch (direction) {
            case 1: {
                return FlatUIUtils.createPath(!chevron, 0.0, h15, w15 / 2.0f, 0.0, w15, h15);
            }
            case 5: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, w15 / 2.0f, h15, w15, 0.0);
            }
            case 7: {
                return FlatUIUtils.createPath(!chevron, w15, 0.0, 0.0, h15 / 2.0f, w15, h15);
            }
            case 3: {
                return FlatUIUtils.createPath(!chevron, 0.0, 0.0, w15, h15 / 2.0f, 0.0, h15);
            }
        }
        return new Path2D.Float();
    }

    public static Path2D createPath(double ... points) {
        return FlatUIUtils.createPath(true, points);
    }

    public static Path2D createPath(boolean close, double ... points) {
        Path2D.Float path = new Path2D.Float(1, points.length / 2 + (close ? 1 : 0));
        ((Path2D)path).moveTo(points[0], points[1]);
        int i15 = 2;
        while (i15 < points.length) {
            double p15 = points[i15];
            if (p15 == -1.000000000001E12) {
                ((Path2D)path).moveTo(points[i15 + 1], points[i15 + 2]);
                i15 += 3;
                continue;
            }
            if (p15 == -1.000000000002E12) {
                ((Path2D)path).quadTo(points[i15 + 1], points[i15 + 2], points[i15 + 3], points[i15 + 4]);
                i15 += 5;
                continue;
            }
            if (p15 == -1.000000000003E12) {
                ((Path2D)path).curveTo(points[i15 + 1], points[i15 + 2], points[i15 + 3], points[i15 + 4], points[i15 + 5], points[i15 + 6]);
                i15 += 7;
                continue;
            }
            if (p15 == -1.000000000004E12) {
                double x15 = points[i15 + 1];
                double y15 = points[i15 + 2];
                double arc = points[i15 + 3];
                int ip22 = i15 + 4;
                if (points[ip22] == -1.000000000002E12 || points[ip22] == -1.000000000004E12) {
                    ++ip22;
                }
                Point2D p16 = path.getCurrentPoint();
                double x16 = p16.getX();
                double y16 = p16.getY();
                double x25 = points[ip22];
                double y25 = points[ip22 + 1];
                double d15 = FlatUIUtils.distance(x15, y15, x16, y16);
                double d25 = FlatUIUtils.distance(x15, y15, x25, y25);
                double t15 = 1.0 - 1.0 / d15 * arc;
                double t25 = 1.0 / d25 * arc;
                ((Path2D)path).lineTo(FlatUIUtils.lerp(x16, x15, t15), FlatUIUtils.lerp(y16, y15, t15));
                ((Path2D)path).quadTo(x15, y15, FlatUIUtils.lerp(x15, x25, t25), FlatUIUtils.lerp(y15, y25, t25));
                i15 += 4;
                continue;
            }
            if (p15 == -1.000000000005E12) {
                path.closePath();
                ++i15;
                continue;
            }
            ((Path2D)path).lineTo(p15, points[i15 + 1]);
            i15 += 2;
        }
        if (close) {
            path.closePath();
        }
        return path;
    }

    private static double lerp(double v15, double v25, double t15) {
        return v15 * (1.0 - t15) + v25 * t15;
    }

    private static double distance(double x15, double y15, double x25, double y25) {
        double dx4 = x25 - x15;
        double dy4 = y25 - y15;
        return Math.sqrt(dx4 * dx4 + dy4 * dy4);
    }

    public static void drawShapePure(Graphics2D g15, Shape shape) {
        Object oldStrokeControl = g15.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g15.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g15.translate(0.5, 0.5);
        g15.draw(shape);
        g15.translate(-0.5, -0.5);
        g15.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControl);
    }

    public static void drawString(JComponent c15, Graphics g15, String text, int x15, int y15) {
        HiDPIUtils.drawStringWithYCorrection(c15, (Graphics2D)g15, text, x15, y15);
    }

    public static void drawStringUnderlineCharAt(JComponent c15, Graphics g15, String text, int underlinedIndex, int x15, int y15) {
        if (underlinedIndex >= 0 && UIScale.getUserScaleFactor() > 1.0f) {
            g15 = new Graphics2DProxy((Graphics2D)g15){

                @Override
                public void fillRect(int x15, int y15, int width, int height) {
                    if (height == 1) {
                        height = Math.round(UIScale.scale(0.9f));
                        y15 += height - 1;
                    }
                    super.fillRect(x15, y15, width, height);
                }
            };
        }
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(c15, (Graphics2D)g15, text, underlinedIndex, x15, y15);
    }

    public static boolean hasOpaqueBeenExplicitlySet(JComponent c15) {
        boolean oldOpaque = c15.isOpaque();
        LookAndFeel.installProperty(c15, "opaque", !oldOpaque);
        boolean explicitlySet = c15.isOpaque() == oldOpaque;
        LookAndFeel.installProperty(c15, "opaque", oldOpaque);
        return explicitlySet;
    }

    public static boolean isUseSharedUIs() {
        return useSharedUIs;
    }

    public static boolean setUseSharedUIs(boolean useSharedUIs) {
        boolean old = FlatUIUtils.useSharedUIs;
        FlatUIUtils.useSharedUIs = useSharedUIs;
        return old;
    }

    public static ComponentUI createSharedUI(Object key, Supplier<ComponentUI> newInstanceSupplier) {
        if (!useSharedUIs) {
            return newInstanceSupplier.get();
        }
        return sharedUIinstances.computeIfAbsent(UIManager.getLookAndFeel(), k15 -> new IdentityHashMap()).computeIfAbsent(key, k15 -> (ComponentUI)newInstanceSupplier.get());
    }

    public static boolean canUseSharedUI(JComponent c15) {
        return !FlatStylingSupport.hasStyleProperty(c15);
    }

    private static class NonUIResourceBorder
    implements Border {
        private final Border delegate;

        NonUIResourceBorder(Border delegate2) {
            this.delegate = delegate2;
        }

        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            this.delegate.paintBorder(c15, g15, x15, y15, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c15) {
            return this.delegate.getBorderInsets(c15);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    public static class RepaintFocusListener
    implements FocusListener {
        private final Component repaintComponent;
        private final Predicate<Component> repaintCondition;

        public RepaintFocusListener(Component repaintComponent, Predicate<Component> repaintCondition) {
            this.repaintComponent = repaintComponent;
            this.repaintCondition = repaintCondition;
        }

        @Override
        public void focusGained(FocusEvent e15) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                HiDPIUtils.repaint(this.repaintComponent);
            }
        }

        @Override
        public void focusLost(FocusEvent e15) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                HiDPIUtils.repaint(this.repaintComponent);
            }
        }
    }
}

