/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatCheckBoxIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class FlatRadioButtonUI
extends BasicRadioButtonUI
implements FlatStylingSupport.StyleableUI {
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    private Color defaultBackground;
    private final boolean shared;
    private boolean iconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private static final Insets tempInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) && !FlatUIUtils.needsLightAWTPeer(c15) ? FlatUIUtils.createSharedUI(FlatRadioButtonUI.class, () -> new FlatRadioButtonUI(true)) : new FlatRadioButtonUI(false);
    }

    protected FlatRadioButtonUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c15) {
        if (FlatUIUtils.needsLightAWTPeer(c15)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c15));
        } else {
            this.installUIImpl(c15);
        }
    }

    private void installUIImpl(JComponent c15) {
        super.installUI(c15);
        if (FlatUIUtils.isAWTPeer(c15)) {
            AWTPeerMouseExitedFix.install(c15);
        }
        this.installStyle((AbstractButton)c15);
    }

    @Override
    public void uninstallUI(JComponent c15) {
        super.uninstallUI(c15);
        if (FlatUIUtils.isAWTPeer(c15)) {
            AWTPeerMouseExitedFix.uninstall(c15);
        }
    }

    @Override
    public void installDefaults(AbstractButton b15) {
        super.installDefaults(b15);
        if (!this.defaults_initialized) {
            String prefix = this.getPropertyPrefix();
            this.iconTextGap = FlatUIUtils.getUIInt(prefix + "iconTextGap", 4);
            this.disabledText = UIManager.getColor(prefix + "disabledText");
            this.defaultBackground = UIManager.getColor(prefix + "background");
            this.iconShared = true;
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(b15, "opaque", false);
        LookAndFeel.installProperty(b15, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install(b15, null);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b15) {
        super.uninstallDefaults(b15);
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(b15);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b15) {
        return new FlatRadioButtonListener(b15);
    }

    protected void propertyChange(AbstractButton b15, PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "html": {
                FlatHTML.updateRendererCSSFontBaseSize(b15);
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(b15)) {
                    b15.updateUI();
                } else {
                    this.installStyle(b15);
                }
                b15.revalidate();
                HiDPIUtils.repaint(b15);
            }
        }
    }

    protected void installStyle(AbstractButton b15) {
        try {
            this.applyStyle(b15, FlatStylingSupport.getResolvedStyle(b15, this.getStyleType()));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    String getStyleType() {
        return "RadioButton";
    }

    protected void applyStyle(AbstractButton b15, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(b15, (String)key, value));
    }

    protected Object applyStyleProperty(AbstractButton b15, String key, Object value) {
        if (key.startsWith("icon.")) {
            Icon icon = this.getRealIcon(b15);
            if (!(icon instanceof FlatStylingSupport.StyleableObject)) {
                throw new FlatStylingSupport.UnknownStyleException(key);
            }
            if (icon == this.icon && this.iconShared) {
                this.icon = icon = FlatStylingSupport.cloneIcon(icon);
                this.iconShared = false;
            }
            key = key.substring("icon.".length());
            return ((FlatStylingSupport.StyleableObject)((Object)icon)).applyStyleProperty(key, value);
        }
        if ("iconTextGap".equals(key) && value instanceof Integer) {
            value = UIScale.scale((Integer)value);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, b15, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        Map<String, Class<?>> infos = FlatStylingSupport.getAnnotatedStyleableInfos(this);
        Icon icon = this.getRealIcon(c15);
        if (icon instanceof FlatStylingSupport.StyleableObject) {
            FlatStylingSupport.putAllPrefixKey(infos, "icon.", ((FlatStylingSupport.StyleableObject)((Object)icon)).getStyleableInfos());
        }
        return infos;
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        if (key.startsWith("icon.")) {
            Icon icon = this.getRealIcon(c15);
            return icon instanceof FlatStylingSupport.StyleableObject ? ((FlatStylingSupport.StyleableObject)((Object)icon)).getStyleableValue(key.substring("icon.".length())) : null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        Dimension size = super.getPreferredSize(c15);
        if (size == null) {
            return null;
        }
        int focusWidth = this.getIconFocusWidth(c15);
        if (focusWidth > 0) {
            Insets insets = c15.getInsets(tempInsets);
            size.width += Math.max(focusWidth - insets.left, 0) + Math.max(focusWidth - insets.right, 0);
            size.height += Math.max(focusWidth - insets.top, 0) + Math.max(focusWidth - insets.bottom, 0);
        }
        return size;
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        int focusWidth;
        if (!c15.isOpaque() && ((AbstractButton)c15).isContentAreaFilled() && !Objects.equals(c15.getBackground(), this.getDefaultBackground(c15))) {
            g15.setColor(c15.getBackground());
            g15.fillRect(0, 0, c15.getWidth(), c15.getHeight());
        }
        if ((focusWidth = this.getIconFocusWidth(c15)) > 0) {
            boolean ltr = c15.getComponentOrientation().isLeftToRight();
            int halign = ((AbstractButton)c15).getHorizontalAlignment();
            if (halign == 10) {
                halign = ltr ? 2 : 4;
            } else if (halign == 11) {
                halign = ltr ? 4 : 2;
            }
            Insets insets = c15.getInsets(tempInsets);
            if (!(focusWidth <= insets.left && focusWidth <= insets.right || halign != 2 && halign != 4)) {
                int offset = halign == 2 ? Math.max(focusWidth - insets.left, 0) : -Math.max(focusWidth - insets.right, 0);
                g15.translate(offset, 0);
                super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(g15, c15), c15);
                g15.translate(-offset, 0);
                return;
            }
        }
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(g15, c15), c15);
    }

    @Override
    protected void paintText(Graphics g15, AbstractButton b15, Rectangle textRect, String text) {
        FlatButtonUI.paintText(g15, b15, textRect, text, b15.isEnabled() ? b15.getForeground() : this.disabledText);
    }

    private Color getDefaultBackground(JComponent c15) {
        Container parent = c15.getParent();
        return parent instanceof CellRendererPane && parent.getParent() != null ? parent.getParent().getBackground() : this.defaultBackground;
    }

    private int getIconFocusWidth(JComponent c15) {
        Icon icon = this.getRealIcon(c15);
        return icon instanceof FlatCheckBoxIcon ? Math.round(UIScale.scale(((FlatCheckBoxIcon)icon).getFocusWidth())) : 0;
    }

    private Icon getRealIcon(JComponent c15) {
        AbstractButton b15 = (AbstractButton)c15;
        Icon icon = b15.getIcon();
        return icon != null ? icon : this.getDefaultIcon();
    }

    @Override
    public int getBaseline(JComponent c15, int width, int height) {
        return FlatButtonUI.getBaselineImpl(c15, width, height);
    }

    private static class AWTPeerMouseExitedFix
    extends MouseAdapter
    implements PropertyChangeListener {
        private final JComponent button;

        static void install(JComponent button) {
            AWTPeerMouseExitedFix l15 = new AWTPeerMouseExitedFix(button);
            button.addPropertyChangeListener("ancestor", l15);
            Container parent = button.getParent();
            if (parent != null) {
                parent.addMouseListener(l15);
            }
        }

        static void uninstall(JComponent button) {
            for (PropertyChangeListener l15 : button.getPropertyChangeListeners("ancestor")) {
                if (!(l15 instanceof AWTPeerMouseExitedFix)) continue;
                button.removePropertyChangeListener("ancestor", l15);
                Container parent = button.getParent();
                if (parent == null) break;
                parent.removeMouseListener((AWTPeerMouseExitedFix)l15);
                break;
            }
        }

        AWTPeerMouseExitedFix(JComponent button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e15) {
            if (e15.getOldValue() instanceof Component) {
                ((Component)e15.getOldValue()).removeMouseListener(this);
            }
            if (e15.getNewValue() instanceof Component) {
                ((Component)e15.getNewValue()).removeMouseListener(this);
                ((Component)e15.getNewValue()).addMouseListener(this);
            }
        }

        @Override
        public void mouseExited(MouseEvent e15) {
            this.button.dispatchEvent(SwingUtilities.convertMouseEvent(e15.getComponent(), e15, this.button));
        }
    }

    protected class FlatRadioButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatRadioButtonListener(AbstractButton b15) {
            super(b15);
            this.b = b15;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e15) {
            super.propertyChange(e15);
            FlatRadioButtonUI.this.propertyChange(this.b, e15);
        }
    }
}

