/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FullWindowContentSupport;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class FlatPanelUI
extends BasicPanelUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) ? FlatUIUtils.createSharedUI(FlatPanelUI.class, () -> new FlatPanelUI(true)) : new FlatPanelUI(false);
    }

    protected FlatPanelUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        c15.addPropertyChangeListener(this);
        if (c15.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.registerPlaceholder(c15);
        }
        this.installStyle((JPanel)c15);
    }

    @Override
    public void uninstallUI(JComponent c15) {
        super.uninstallUI(c15);
        c15.removePropertyChangeListener(this);
        if (c15.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.unregisterPlaceholder(c15);
        }
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults(JPanel p15) {
        super.installDefaults(p15);
        if (p15.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            LookAndFeel.installProperty(p15, "opaque", false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JPanel c15 = (JPanel)e15.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(c15)) {
                    c15.updateUI();
                } else {
                    this.installStyle(c15);
                }
                c15.revalidate();
                HiDPIUtils.repaint(c15);
                break;
            }
            case "FlatLaf.fullWindowContent.buttonsPlaceholder": {
                JPanel p15 = (JPanel)e15.getSource();
                if (e15.getOldValue() != null) {
                    FullWindowContentSupport.unregisterPlaceholder(p15);
                }
                if (e15.getNewValue() != null) {
                    FullWindowContentSupport.registerPlaceholder(p15);
                }
                LookAndFeel.installProperty(p15, "opaque", e15.getNewValue() == null);
            }
        }
    }

    protected void installStyle(JPanel c15) {
        try {
            this.applyStyle(c15, FlatStylingSupport.getResolvedStyle(c15, "Panel"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(JPanel c15, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(c15, (String)key, value));
    }

    protected Object applyStyleProperty(JPanel c15, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, c15, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        FlatPanelUI.fillRoundedBackground(g15, c15, this.arc);
        this.paint(g15, c15);
    }

    public static void fillRoundedBackground(Graphics g15, JComponent c15, int arc) {
        if (arc < 0) {
            Border border = c15.getBorder();
            int n15 = arc = border instanceof FlatLineBorder ? ((FlatLineBorder)border).getArc() : 0;
        }
        if (c15.isOpaque()) {
            if (arc > 0) {
                FlatUIUtils.paintParentBackground(g15, c15);
            } else {
                g15.setColor(c15.getBackground());
                g15.fillRect(0, 0, c15.getWidth(), c15.getHeight());
            }
        }
        if (arc > 0) {
            g15.setColor(c15.getBackground());
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
            FlatUIUtils.paintComponentBackground((Graphics2D)g15, 0, 0, c15.getWidth(), c15.getHeight(), 0.0f, UIScale.scale(arc));
            FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        Object value = c15.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder");
        if (value != null) {
            return FullWindowContentSupport.getPlaceholderPreferredSize(c15, (String)value);
        }
        return super.getPreferredSize(c15);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        if (c15.getClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder") != null) {
            FullWindowContentSupport.debugPaint(g15, c15);
        }
    }
}

