/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

@FlatStylingSupport.StyleableFields(value={@FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionBackground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="disabledForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorSelectionForeground")})
public class FlatMenuItemUI
extends BasicMenuItemUI
implements FlatStylingSupport.StyleableUI,
FlatStylingSupport.StyleableLookupProvider {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatMenuItemUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JMenuItem menuItem) {
        super.installComponents(menuItem);
        FlatHTML.updateRendererCSSFontBaseSize(menuItem);
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuItemRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c15) {
        return FlatHTML.createPropertyChangeListener(FlatStylingSupport.createPropertyChangeListener(c15, this::installStyle, super.createPropertyChangeListener(c15)));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuItem, "MenuItem"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatMenuItemUI.applyStyleProperty(this.menuItem, this, this.renderer, key, value);
    }

    static Object applyStyleProperty(JMenuItem menuItem, BasicMenuItemUI ui4, FlatMenuItemRenderer renderer, String key, Object value) {
        try {
            return renderer.applyStyleProperty(key, value);
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
            return FlatStylingSupport.applyToAnnotatedObjectOrComponent(ui4, menuItem, key, value);
        }
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatMenuItemUI.getStyleableInfos(this, this.renderer);
    }

    static Map<String, Class<?>> getStyleableInfos(BasicMenuItemUI ui4, FlatMenuItemRenderer renderer) {
        Map<String, Class<?>> infos = FlatStylingSupport.getAnnotatedStyleableInfos(ui4);
        infos.putAll(renderer.getStyleableInfos());
        return infos;
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatMenuItemUI.getStyleableValue(this, this.renderer, key);
    }

    static Object getStyleableValue(BasicMenuItemUI ui4, FlatMenuItemRenderer renderer, String key) {
        Object value = renderer.getStyleableValue(key);
        if (value == null) {
            value = FlatStylingSupport.getAnnotatedStyleableValue(ui4, key);
        }
        return value;
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c15, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        this.renderer.paintMenuItem(g15, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }
}

