/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.instruction;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.ReferenceType;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedReference;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20bc;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import javax.annotation.Nonnull;

public class DexBackedInstruction20bc
extends DexBackedInstruction
implements Instruction20bc {
    public DexBackedInstruction20bc(@Nonnull DexBackedDexFile dexFile, @Nonnull Opcode opcode, int instructionStart) {
        super(dexFile, opcode, instructionStart);
    }

    @Override
    public int getVerificationError() {
        return this.dexFile.getDataBuffer().readUbyte(this.instructionStart + 1) & 0x3F;
    }

    @Override
    @Nonnull
    public Reference getReference() {
        final int referenceIndex = this.dexFile.getDataBuffer().readUshort(this.instructionStart + 2);
        try {
            int referenceType = this.getReferenceType();
            return DexBackedReference.makeReference(this.dexFile, referenceType, referenceIndex);
        }
        catch (ReferenceType.InvalidReferenceTypeException ex4) {
            return new Reference(){

                @Override
                public void validateReference() throws Reference.InvalidReferenceException {
                    throw new Reference.InvalidReferenceException(String.format("%d@%d", ex4.getReferenceType(), referenceIndex), ex4);
                }
            };
        }
    }

    @Override
    public int getReferenceType() {
        int referenceType = (this.dexFile.getDataBuffer().readUbyte(this.instructionStart + 1) >>> 6) + 1;
        ReferenceType.validateReferenceType(referenceType);
        return referenceType;
    }
}

