/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.BundleTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class BundleModeTransparencyChecker {
    public static TransparencyCheckResult checkTransparency(CheckTransparencyCommand command) {
        TransparencyCheckResult transparencyCheckResult;
        ZipFile bundleZip = new ZipFile(command.getBundlePath().get().toFile());
        try {
            AppBundle inputBundle = AppBundle.buildFromZip(bundleZip);
            transparencyCheckResult = BundleTransparencyCheckUtils.checkTransparency(inputBundle);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bundleZip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ZipException e15) {
                throw InvalidBundleException.builder().withCause(e15).withUserMessage("The App Bundle is not a valid zip file.").build();
            }
            catch (IOException e16) {
                throw new UncheckedIOException("An error occurred when processing the App Bundle.", e16);
            }
        }
        bundleZip.close();
        return transparencyCheckResult;
    }

    private BundleModeTransparencyChecker() {
    }
}

